/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.dump.thread;

import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import com.gigaspaces.internal.jvm.JVMHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;

public class ThreadDumpProcessor
implements InternalDumpProcessor {
    private static final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    public static final String NAME = "thread";

    public String getName() {
        return NAME;
    }

    public void process(InternalDump dump) throws InternalDumpProcessorFailedException {
        PrintWriter writer = new PrintWriter(dump.createFileWriter("threads.txt"));
        try {
            this.processDeadlocks(writer);
            this.processAllThreads(writer);
        }
        catch (Exception e) {
            throw new InternalDumpProcessorFailedException(this.getName(), "Failed to generate 'threads.txt'", (Throwable)e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
        PrintWriter tdumpWriter = new PrintWriter(dump.createFileWriter("threads.tdump"));
        try {
            this.processAllNewThreadsWithJStack(tdumpWriter);
        }
        catch (Exception e) {
            throw new InternalDumpProcessorFailedException(this.getName(), "Failed to generate '.tdump' using jstack", (Throwable)e);
        }
        finally {
            try {
                tdumpWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    public void processDeadlocks(PrintWriter dump) throws Exception {
        dump.println("=====  Deadlocked Threads =====");
        long[] deadlockedThreadIds = this.findDeadlockedThreads();
        if (deadlockedThreadIds != null) {
            this.dumpThreads(dump, this.getThreadInfo(deadlockedThreadIds));
        }
    }

    public void processAllThreads(PrintWriter dump) throws Exception {
        dump.println();
        dump.println("===== All Threads =====");
        ThreadInfo[] threadInfos = this.dumpAllThreads();
        dump.println("Threads count:" + threadInfos.length);
        this.dumpThreads(dump, threadInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAllNewThreadsWithJStack(PrintWriter dump) throws IOException {
        String pid = Long.toString(JVMHelper.getDetails().getPid());
        String[] cmd = new String[]{"jstack", "-l", pid};
        Process p = Runtime.getRuntime().exec(cmd);
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String line;
            while ((line = input.readLine()) != null) {
                dump.println(line);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    private void dumpThreads(PrintWriter dump, ThreadInfo[] infos) throws Exception {
        for (ThreadInfo info : infos) {
            dump.println();
            this.write(info, dump);
        }
    }

    private ThreadInfo[] dumpAllThreads() throws Exception {
        return threadBean.dumpAllThreads(true, true);
    }

    public long[] findDeadlockedThreads() throws Exception {
        return threadBean.findDeadlockedThreads();
    }

    public ThreadInfo[] getThreadInfo(long[] threadIds) throws Exception {
        return threadBean.getThreadInfo(threadIds, true, true);
    }

    private void write(ThreadInfo threadInfo, PrintWriter writer) throws Exception {
        StackTraceElement[] stackTraceElements;
        writer.print(String.format("\"%s\" Id=%s %s", new Object[]{threadInfo.getThreadName(), threadInfo.getThreadId(), threadInfo.getThreadState()}));
        if (threadInfo.getLockName() != null) {
            writer.print(String.format(" on %s", threadInfo.getLockName()));
            if (threadInfo.getLockOwnerName() != null) {
                writer.print(String.format(" owned by \"%s\" Id=%s", threadInfo.getLockOwnerName(), threadInfo.getLockOwnerId()));
            }
        }
        if (threadInfo.isInNative()) {
            writer.println(" (in native)");
        } else {
            writer.println();
        }
        Class<?> monitorInfoClass = Class.forName("java.lang.management.MonitorInfo", true, ThreadDumpProcessor.class.getClassLoader());
        Method getLockedStackFrameMethod = monitorInfoClass.getMethod("getLockedStackFrame", new Class[0]);
        getLockedStackFrameMethod.setAccessible(true);
        Method getClassNameMethod = monitorInfoClass.getMethod("getClassName", new Class[0]);
        getClassNameMethod.setAccessible(true);
        Method getIdentityHashCodeMethod = monitorInfoClass.getMethod("getIdentityHashCode", new Class[0]);
        getIdentityHashCodeMethod.setAccessible(true);
        Method lockedMonitorsMethod = ThreadInfo.class.getDeclaredMethod("getLockedMonitors", new Class[0]);
        lockedMonitorsMethod.setAccessible(true);
        Object[] lockedMonitors = (Object[])lockedMonitorsMethod.invoke((Object)threadInfo, new Object[0]);
        for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
            writer.println("    at " + stackTraceElement);
            Object lockedMonitor = ThreadDumpProcessor.findLockedMonitor(stackTraceElement, lockedMonitors, getLockedStackFrameMethod);
            if (lockedMonitor == null) continue;
            writer.println("    - locked " + getClassNameMethod.invoke(lockedMonitor, new Object[0]) + "@" + getIdentityHashCodeMethod.invoke(lockedMonitor, new Object[0]));
        }
    }

    private static Object findLockedMonitor(StackTraceElement stackTraceElement, Object[] lockedMonitors, Method getLockedStackFrameMethod) throws Exception {
        for (Object monitorInfo : lockedMonitors) {
            if (!stackTraceElement.equals(getLockedStackFrameMethod.invoke(monitorInfo, new Object[0]))) continue;
            return monitorInfo;
        }
        return null;
    }
}

