/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.quiesce;

import com.gigaspaces.admin.quiesce.InstancesQuiesceState;
import com.gigaspaces.admin.quiesce.QuiesceState;
import com.gigaspaces.admin.quiesce.QuiesceStateChangedEvent;
import com.gigaspaces.internal.quiesce.InternalQuiesceDetails;
import com.gigaspaces.internal.quiesce.QuiesceAware;
import com.gigaspaces.lrmi.nio.async.FutureContext;
import com.gigaspaces.lrmi.nio.async.IFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;

public class QuiesceTask
implements Runnable {
    static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsm");
    private final OperationalStringManager operationalStringManager;
    private final InternalQuiesceDetails details;
    private final OperationalString opString;
    private final List<ServiceBeanInstance> serviceBeanInstances;
    private final InstancesQuiesceState instancesQuiesceState;
    private final boolean enterQuiesce;

    public QuiesceTask(OperationalStringManager operationalStringManager, InternalQuiesceDetails details, OperationalString opString) {
        this.operationalStringManager = operationalStringManager;
        this.details = details;
        this.opString = opString;
        this.serviceBeanInstances = this.getServiceBeanInstancesForQuiesce();
        this.instancesQuiesceState = new InstancesQuiesceState(this.getMissingInstancesForQuiesce());
        this.enterQuiesce = details.getStatus().equals((Object)QuiesceState.QUIESCED);
    }

    @Override
    public void run() {
        this.executeQuiesce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalQuiesceDetails executeQuiesce() {
        HashMap<String, IFuture> futures = new HashMap<String, IFuture>();
        for (ServiceBeanInstance serviceBeanInstance : this.serviceBeanInstances) {
            try {
                Object service = serviceBeanInstance.getService();
                if (!(service instanceof QuiesceAware)) continue;
                ((QuiesceAware)service).quiesceStateChanged(new QuiesceStateChangedEvent(this.details.getStatus(), this.details.getToken(), this.details.getDescription()));
                IFuture futureResult = FutureContext.getFutureResult();
                futures.put(serviceBeanInstance.getPresentationName(), futureResult);
            }
            catch (Throwable ignored) {
                this.instancesQuiesceState.addFailure(serviceBeanInstance.getPresentationName(), ignored);
                logger.log(Level.WARNING, String.format("Failed to inform processing unit %s instance about %s", this.opString.getName(), this.details.getAction()), ignored);
            }
            finally {
                FutureContext.clear();
            }
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                ((IFuture)entry.getValue()).get();
                this.instancesQuiesceState.addQuiesced((String)entry.getKey());
            }
            catch (InterruptedException e) {
                logger.log(Level.INFO, String.format("Processing unit %s was canceled because unquiesce was requested", this.opString.getName()), e);
                Thread.currentThread().interrupt();
                return this.details;
            }
            catch (ExecutionException e) {
                logger.log(Level.WARNING, String.format("Received exception while %s for processing unit %s", this.details.getAction(), this.opString.getName()), e);
                if (!(e.getCause() instanceof RemoteException)) continue;
                this.instancesQuiesceState.addFailure((String)entry.getKey(), (Throwable)e);
            }
        }
        this.details.setInstancesState(this.instancesQuiesceState);
        this.updateQuiesceDetails(this.operationalStringManager, this.details);
        return this.details;
    }

    private void updateQuiesceDetails(OperationalStringManager operationalStringManager, InternalQuiesceDetails details) {
        try {
            operationalStringManager.setQuiesceDetails(details);
        }
        catch (RemoteException e) {
            logger.log(Level.WARNING, String.format("Failed to update on %s [%s] for processing unit %s", details.getAction(), details.getDescription(), this.opString.getName()), e);
        }
    }

    public boolean shouldEnterQuiesce() {
        return this.enterQuiesce;
    }

    private Integer getMissingInstancesForQuiesce() {
        ServiceElement[] services;
        Integer planned = 0;
        for (ServiceElement sElem : services = this.opString.getServices()) {
            planned = planned + sElem.getPlanned();
        }
        return Math.abs(planned - this.serviceBeanInstances.size());
    }

    private List<ServiceBeanInstance> getServiceBeanInstancesForQuiesce() {
        ServiceElement[] services;
        ArrayList<ServiceBeanInstance> serviceBeanInstances = new ArrayList<ServiceBeanInstance>();
        for (ServiceElement sElem : services = this.opString.getServices()) {
            try {
                ServiceBeanInstance[] instances = this.operationalStringManager.getServiceBeanInstances(sElem);
                serviceBeanInstances.addAll(Arrays.asList(instances));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, String.format("Failed to get processing unit %s instances for %s [%s]", this.opString.getName(), this.details.getAction(), this.details.getDescription()), e);
            }
        }
        return serviceBeanInstances;
    }
}

