/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.management;

import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.management.SystemComponent;
import com.gigaspaces.management.system.cpu.CPU;
import com.gigaspaces.management.system.disk.DiskSpace;
import com.gigaspaces.management.system.memory.Memory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.jini.rio.jmx.MBeanServerFactory;
import org.jini.rio.qos.capability.PlatformCapability;
import org.jini.rio.qos.measurable.MeasurableCapability;

public class SystemCapabilities
extends org.jini.rio.qos.SystemCapabilities {
    public static final String COMPONENT = "com.gigaspaces.management";
    public static final String GS_SUPPORT = "com.gigaspaces.management.GigaSpacesSupport";
    static final Logger logger = Logger.getLogger("com.gigaspaces.management");

    @Override
    public MeasurableCapability[] getMeasurableCapabilities(Configuration config) {
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        ArrayList<MeasurableCapability> measurables = new ArrayList<MeasurableCapability>();
        try {
            MeasurableCapability memory = (MeasurableCapability)config.getEntry(COMPONENT, "memory", MeasurableCapability.class, (Object)new Memory(config), (Object)config);
            measurables.add(memory);
        }
        catch (ConfigurationException e) {
            logger.log(Level.WARNING, "Loading Memory MeasurableCapability", e);
        }
        try {
            MeasurableCapability cpu = (MeasurableCapability)config.getEntry(COMPONENT, "cpu", MeasurableCapability.class, (Object)new CPU(config), (Object)config);
            measurables.add(cpu);
        }
        catch (ConfigurationException e) {
            logger.log(Level.WARNING, "Loading CPU MeasurableCapability", e);
        }
        try {
            boolean diskEnabled = DiskSpace.isEnabled(config);
            if (diskEnabled) {
                MeasurableCapability diskSpace = (MeasurableCapability)config.getEntry(COMPONENT, "disk", MeasurableCapability.class, (Object)new DiskSpace(config), (Object)config);
                measurables.add(diskSpace);
            }
        }
        catch (ConfigurationException e) {
            logger.log(Level.WARNING, "Loading DiskSpace MeasurableCapability", e);
        }
        try {
            MeasurableCapability[] mCaps = (MeasurableCapability[])config.getEntry(COMPONENT, "measurableCapabilities", MeasurableCapability[].class, null);
            if (mCaps != null) {
                for (int i = 0; i < mCaps.length; ++i) {
                    measurables.add(mCaps[i]);
                }
            }
        }
        catch (ConfigurationException e) {
            logger.log(Level.WARNING, "Loading MeasurableCapability array", e);
        }
        return measurables.toArray(new MeasurableCapability[measurables.size()]);
    }

    @Override
    public PlatformCapability[] getPlatformCapabilities(Configuration config) {
        PlatformCapability[] pCaps;
        block8: {
            pCaps = super.getPlatformCapabilities(config);
            try {
                ArrayList<PlatformCapability> list = new ArrayList<PlatformCapability>();
                for (int i = 0; i < pCaps.length; ++i) {
                    list.add(pCaps[i]);
                }
                PlatformCapability gsSupport = this.getPlatformCapability(GS_SUPPORT);
                gsSupport.define("Version", PlatformVersion.getOfficialVersion());
                String path = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        CodeSource cs = SystemCapabilities.class.getProtectionDomain().getCodeSource();
                        String path = null;
                        if (cs != null) {
                            path = cs.getLocation().toString();
                        }
                        return path;
                    }
                });
                if (path != null) {
                    if (path.startsWith("file:")) {
                        path = path.substring(5, path.length());
                    }
                    gsSupport.setPath(path);
                }
                list.add(gsSupport);
                pCaps = list.toArray(new PlatformCapability[list.size()]);
                if (gsSupport == null) break block8;
                try {
                    MBeanServer mbs = MBeanServerFactory.getMBeanServer();
                    Class<?> mbsClass = mbs.getClass();
                    Method register = mbsClass.getMethod("registerMBean", Object.class, ObjectName.class);
                    register.invoke((Object)mbs, new SystemComponent(gsSupport), new ObjectName("com.gigaspaces:type=" + gsSupport.getDescription()));
                }
                catch (Throwable t) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Unable to add the PlatformCapability [" + gsSupport.getDescription() + "] as an MBean", t);
                        break block8;
                    }
                    logger.log(Level.WARNING, "Unable to add the PlatformCapability [" + gsSupport.getDescription() + "] as an MBean");
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Getting PlatformCapability objects", t);
            }
        }
        return pCaps;
    }
}

