/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.management;

import com.gigaspaces.management.SystemComponentMBean;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jini.rio.qos.capability.PlatformCapability;

public class SystemComponent
implements SystemComponentMBean {
    private PlatformCapability pCap;

    public SystemComponent(PlatformCapability pCap) {
        if (pCap == null) {
            throw new NullPointerException("pCap is null");
        }
        this.pCap = pCap;
    }

    @Override
    public Map getCapabilities() throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Object[] keys = this.pCap.getPlatformKeys();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], this.pCap.getValue(keys[i]));
        }
        return map;
    }

    @Override
    public String getDescription() throws IOException {
        return this.pCap.getDescription();
    }

    @Override
    public String getManufacturer() throws IOException {
        String manufacturer = (String)this.pCap.getValue("Manufacturer");
        return manufacturer == null ? "" : manufacturer;
    }

    @Override
    public String getPath() throws IOException {
        String path = this.pCap.getPath();
        return path == null ? "" : path;
    }

    @Override
    public String getVersion() throws IOException {
        String version = (String)this.pCap.getValue("Version");
        return version == null ? "" : version;
    }
}

