/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.management.system.cpu;

import com.gigaspaces.internal.oshi.OshiChecker;
import com.gigaspaces.internal.sigar.SigarChecker;
import com.gigaspaces.management.system.OperatingSystemType;
import com.gigaspaces.management.system.cpu.WindowsCPUHandler;
import com.sun.jini.config.Config;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import org.jini.rio.core.ResourceCostModel;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.core.ZeroCostModel;
import org.jini.rio.qos.measurable.MeasurableCapability;
import org.jini.rio.qos.measurable.MeasurableMonitor;
import org.jini.rio.qos.measurable.cpu.CPUMeasurerImpl;
import org.jini.rio.qos.measurable.cpu.CalculableCPU;
import org.jini.rio.qos.measurable.cpu.GenericCPUMeasurer;
import org.jini.rio.qos.measurable.cpu.LinuxHandler;
import org.jini.rio.qos.measurable.cpu.MacTopOutputParser;
import org.jini.rio.qos.measurable.cpu.MpstatOutputParser;

public class CPU
extends MeasurableCapability {
    public static final String VIEW = "org.jini.rio.qos.measurable.cpu.CalculableCPUView";
    private int count;
    private double tempUtilization;
    double utilization;
    MeasurableMonitor monitor;
    static final String COMPONENT = "com.gigaspaces.management.system.cpu";
    static Logger logger = Logger.getLogger("com.gigaspaces.management.system.cpu");

    public CPU(Configuration config) {
        super("CPU", config);
        this.setView(VIEW);
        try {
            ThresholdValues tVals = (ThresholdValues)config.getEntry(COMPONENT, "thresholdValues", ThresholdValues.class, (Object)new ThresholdValues(0.0, 0.9999));
            this.setThresholdValues(tVals);
            ResourceCostModel rCostModel = (ResourceCostModel)config.getEntry(COMPONENT, "resourceCost", ResourceCostModel.class, (Object)new ZeroCostModel());
            this.setResourceCostModel(rCostModel);
            this.sampleSize = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)"sampleSize", (int)Integer.getInteger("com.gigaspaces.management.system.cpu.sampleSize", 2), (int)1, (int)10);
            this.setSampleSize(this.sampleSize);
            long reportRate = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"reportRate", (long)Long.getLong("com.gigaspaces.management.system.cpu.reportRate", 30000L), (long)5000L, (long)Integer.MAX_VALUE);
            this.setPeriod(reportRate);
            this.monitor = (MeasurableMonitor)config.getEntry(COMPONENT, "cpuMonitor", MeasurableMonitor.class, null);
            if (this.monitor == null) {
                if (SigarChecker.isAvailable() || OshiChecker.isAvailable()) {
                    this.monitor = new CPUMeasurerImpl();
                }
                if (this.monitor == null) {
                    if (OperatingSystemType.isLinux()) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Create LinuxHandler");
                        }
                        this.monitor = new LinuxHandler();
                    } else if (OperatingSystemType.isSolaris()) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Create MpstatOutputParser");
                        }
                        this.monitor = new MpstatOutputParser();
                    } else if (OperatingSystemType.isMac()) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Create MacTopOutputParser");
                        }
                        this.monitor = new MacTopOutputParser();
                    } else if (OperatingSystemType.isWindows() && !OperatingSystemType.is64bit()) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Create WindowsCPUHandler");
                        }
                        this.monitor = new WindowsCPUHandler();
                    } else {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Create GenericCPUMeasurer");
                        }
                        this.monitor = new GenericCPUMeasurer();
                    }
                }
            }
        }
        catch (ConfigurationException e) {
            logger.log(Level.WARNING, "Getting CPU Configuration", e);
        }
    }

    @Override
    public double getUtilization() {
        return this.utilization;
    }

    @Override
    public void checkValue() {
        ++this.count;
        if (this.monitor == null) {
            return;
        }
        double util = this.monitor.getValue();
        this.tempUtilization += util;
        if (this.count == this.sampleSize) {
            this.utilization = this.tempUtilization / (double)this.sampleSize;
            this.count = 0;
            this.tempUtilization = 0.0;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("CPU: utilization=" + this.utilization);
        }
        long now = System.currentTimeMillis();
        this.addWatchRecord(new CalculableCPU(this.getId(), this.utilization, now));
    }

    public static void main(String[] argv) {
        try {
            Configuration config = ConfigurationProvider.getInstance((String[])new String[]{"-"});
            CPU cpu = new CPU(config);
            System.out.println("\nJVM Version      : " + System.getProperty("java.vm.version"));
            System.out.println("Hardware Arch    : " + System.getProperty("os.arch"));
            System.out.println("Operating System : " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
            System.out.println("==================================================");
            cpu.setPeriod(5000L);
            cpu.start();
            while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                System.out.println("CPU Utilization : [" + cpu.getUtilization() + "]");
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }
}

