/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.management.system.cpu;

import com.gigaspaces.internal.utils.NativeLibraryLoader;
import java.util.logging.Logger;
import org.jini.rio.qos.measurable.MeasurableMonitor;

public class WindowsCPUHandler
implements MeasurableMonitor {
    static final String COMPONENT = "com.gigaspaces.management.system.cpu";
    static Logger logger = Logger.getLogger("com.gigaspaces.management.system.cpu");

    public WindowsCPUHandler() {
        this.initialize();
    }

    private native void initialize();

    private native double getCPUUtilization();

    @Override
    public double getValue() {
        double val = 0.0;
        String osName = System.getProperty("os.name");
        if (osName != null && osName.startsWith("Windows")) {
            val = this.getCPUUtilization() / 100.0;
        }
        return val;
    }

    @Override
    public double[] getValues() {
        return new double[]{this.getValue()};
    }

    @Override
    public void terminate() {
    }

    static {
        NativeLibraryLoader.loadNativeLibrary((String)"WinMon");
    }
}

