/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.management.system.disk;

import com.gigaspaces.internal.utils.NativeLibraryLoader;
import java.util.logging.Logger;
import org.jini.rio.qos.measurable.MeasurableMonitor;

public class WindowsDiskHandler
implements MeasurableMonitor {
    static final String COMPONENT = "com.gigaspaces.management.system.disk";
    static Logger logger = Logger.getLogger("com.gigaspaces.management.system.disk");

    public WindowsDiskHandler() {
        this.initialize();
    }

    private native void initialize();

    private native double getFreeDiskSpace();

    private native double getPerFreeDiskSpace();

    private double getTotalDiskSpace(double percentFree, double freeSpace) {
        return freeSpace / percentFree;
    }

    private double getUsedDiskSpace(double freeSpace, double totalSpace) {
        return totalSpace - freeSpace;
    }

    @Override
    public double getValue() {
        double val = 0.0;
        String osName = System.getProperty("os.name");
        if (osName != null && osName.startsWith("Windows")) {
            val = this.getPerFreeDiskSpace() / 100.0;
        }
        return val;
    }

    @Override
    public double[] getValues() {
        double val = 0.0;
        String osName = System.getProperty("os.name");
        if (osName != null && osName.startsWith("Windows")) {
            double perCentFree = this.getPerFreeDiskSpace() / 100.0;
            return new double[]{perCentFree, 1.0 - perCentFree};
        }
        return new double[]{0.0, 0.0};
    }

    @Override
    public void terminate() {
    }

    static {
        NativeLibraryLoader.loadNativeLibrary((String)"WinMon");
    }
}

