/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.associations;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.core.Association;
import org.jini.rio.core.AssociationListener;

public class AssociationInjector
implements AssociationListener {
    private PropertyDescriptor[] pds;
    private Object target;
    static final String COMPONENT = "org.jini.rio.associations";
    private static final Logger logger = Logger.getLogger("org.jini.rio.associations");

    public AssociationInjector(Object target) throws IntrospectionException {
        this.target = target;
        Class<?> aClass = target.getClass();
        BeanInfo bi = Introspector.getBeanInfo(aClass);
        this.pds = bi.getPropertyDescriptors();
    }

    private void inject(Association association, Object service) {
        boolean propertyMatch = false;
        String propertyName = association.getAssociationDescriptor().getPropertyName();
        if (propertyName == null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finer("Association [" + association.toString() + "], does not have a declared propertyName, injection aborted");
            }
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Association [" + association.getName() + "], state change, notify target");
        }
        for (int i = 0; i < this.pds.length; ++i) {
            String propName = this.pds[i].getName();
            if (!propName.equals(propertyName)) continue;
            propertyMatch = true;
            Method write = this.pds[i].getWriteMethod();
            if (write != null) {
                try {
                    if (association.getState() == 10) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Association [" + association.getName() + "], is BROKEN, set dependency to be null");
                        }
                        write.invoke(this.target, new Object[]{null});
                        break;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        String type = "DISCOVERED";
                        if (association.getState() == 9) {
                            type = "CHANGED";
                        }
                        logger.fine("Association [" + association.getName() + "], is " + type + ", inject dependency");
                    }
                    write.invoke(this.target, service);
                }
                catch (Exception e) {
                    String svc = service == null ? "broken-association" : service.getClass().getName();
                    String nested = e.getCause() == null ? "" : "\nCAUSE:";
                    logger.log(Level.WARNING, "Injecting Association [" + association.getName() + "], Service [" + svc + "]" + nested, e.getCause() == null ? e : e.getCause());
                }
                break;
            }
            logger.log(Level.WARNING, "Association [" + association.getName() + "], with declared propertyName [" + propertyName + "] matched, no writeMethod found on target object [" + this.target.getClass().getName() + "]");
        }
        if (!propertyMatch) {
            logger.log(Level.WARNING, "Association [" + association.getName() + "], with declared propertyName [" + propertyName + "] not found on target object [" + this.target.getClass().getName() + "]");
        }
    }

    @Override
    public void discovered(Association association, Object service) {
        this.inject(association, service);
    }

    @Override
    public void changed(Association association, Object service) {
        this.inject(association, association.getService());
    }

    @Override
    public void broken(Association association, Object service) {
        this.inject(association, null);
    }
}

