/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.associations;

import com.j_spaces.core.jini.SharedDiscoveryManagement;
import com.sun.jini.admin.DestroyAdmin;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.EmptyConfiguration;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.jini.rio.associations.AssociationInjector;
import org.jini.rio.core.Association;
import org.jini.rio.core.AssociationDescriptor;
import org.jini.rio.core.AssociationListener;
import org.jini.rio.core.AssociationManagement;
import org.jini.rio.core.FaultDetectionHandler;
import org.jini.rio.core.FaultDetectionListener;
import org.jini.rio.core.ServiceBeanControl;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.cybernode.ServiceBeanContainer;
import org.jini.rio.cybernode.ServiceBeanContainerListener;
import org.jini.rio.resources.client.FaultDetectionHandlerFactory;
import org.jini.rio.resources.client.JiniClient;
import org.jini.rio.resources.client.LookupCachePool;
import org.jini.rio.resources.client.ServiceDiscoveryAdapter;

public class AssociationMgmt
implements AssociationManagement {
    private String serviceName;
    private ArrayList listeners = new ArrayList();
    private ArrayList associationHandlers = new ArrayList();
    private ServiceBeanControl control;
    private boolean unadvertiseOnBroken = true;
    private int numRequires;
    private boolean advertised = false;
    private boolean advertisePending = false;
    private ServiceBeanContext context;
    private Listener listener;
    private ClassLoader callerCL;
    private ServiceBeanContainer container;
    private static final Logger logger = Logger.getLogger("org.jini.rio.associations");
    private static final String CONFIG_COMPONENT = "service.association";

    public AssociationMgmt() {
        this(null);
    }

    public AssociationMgmt(ClassLoader cl) {
        if (cl == null) {
            final Thread currentThread = Thread.currentThread();
            this.callerCL = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return currentThread.getContextClassLoader();
                }
            });
        } else {
            this.callerCL = cl;
        }
        this.listener = new Listener();
    }

    @Override
    public void setUnadvertiseOnBroken(boolean unadvertiseOnBroken) {
        this.unadvertiseOnBroken = unadvertiseOnBroken;
    }

    @Override
    public void setServiceBeanControl(ServiceBeanControl control) {
        if (control == null) {
            throw new NullPointerException("control is null");
        }
        this.control = control;
        if (this.advertisePending) {
            this.advertise();
        }
    }

    @Override
    public void setServiceBeanContainer(ServiceBeanContainer container) {
        if (container == null) {
            throw new NullPointerException("control is null");
        }
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(AssociationListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
        Association[] associations = this.getAssociations();
        for (int i = 0; i < associations.length; ++i) {
            if (associations[i].getState() == 7 || associations[i].getState() == 10) continue;
            listener.discovered(associations[i], associations[i].getService());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(AssociationListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        ArrayList arrayList = this.associationHandlers;
        synchronized (arrayList) {
            for (AssociationHandler ah : this.associationHandlers) {
                ah.terminate();
            }
            this.associationHandlers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Association[] getAssociations(String opStringName) {
        ArrayList<Association> associations = new ArrayList<Association>();
        ArrayList arrayList = this.associationHandlers;
        synchronized (arrayList) {
            for (AssociationHandler ah : this.associationHandlers) {
                if (!ah.getAssociation().getOperationalStringName().equals(opStringName)) continue;
                associations.add(ah.getAssociation());
            }
        }
        return associations.toArray(new Association[associations.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Association[] getAssociations(String serviceName, String opStringName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        ArrayList<Association> associations = new ArrayList<Association>();
        ArrayList arrayList = this.associationHandlers;
        synchronized (arrayList) {
            for (AssociationHandler ah : this.associationHandlers) {
                if (opStringName == null) {
                    if (!ah.getAssociation().getName().equals(serviceName)) continue;
                    associations.add(ah.getAssociation());
                    continue;
                }
                if (!ah.getAssociation().getName().equals(serviceName) || !ah.getAssociation().getOperationalStringName().equals(opStringName)) continue;
                associations.add(ah.getAssociation());
            }
        }
        return associations.toArray(new Association[associations.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Association[] getAssociations() {
        int i = 0;
        Association[] associations = null;
        ArrayList arrayList = this.associationHandlers;
        synchronized (arrayList) {
            associations = new Association[this.associationHandlers.size()];
            for (AssociationHandler ah : this.associationHandlers) {
                associations[i++] = ah.getAssociation();
            }
        }
        return associations;
    }

    @Override
    public Object[] getAssociatedServices(Class serviceType) {
        Association[] associations = this.getAssociations();
        ArrayList<Object> list = new ArrayList<Object>();
        if (serviceType != null) {
            for (int i = 0; i < associations.length; ++i) {
                Object service = associations[i].getService();
                if (!this.isAssignableFrom(serviceType, service.getClass())) continue;
                Object[] services = associations[i].getServices();
                for (int j = 0; j < services.length; ++j) {
                    list.add(services[j]);
                }
            }
        } else {
            for (int i = 0; i < associations.length; ++i) {
                Object[] services = associations[i].getServices();
                for (int j = 0; j < services.length; ++j) {
                    list.add(services[j]);
                }
            }
        }
        return list.toArray();
    }

    public void setBackend(Object backend) {
        try {
            AssociationInjector aInjector = new AssociationInjector(backend);
            this.register(aInjector);
        }
        catch (IntrospectionException e) {
            logger.log(Level.WARNING, "Creating AssociationInjector", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServiceBeanContext(ServiceBeanContext context) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        boolean update = false;
        if (this.context != null) {
            update = true;
        }
        this.context = context;
        this.serviceName = context.getServiceElement().getName();
        AssociationDescriptor[] newDesc = context.getServiceElement().getAssociationDescriptors();
        if (newDesc != null) {
            if (!update) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("AssociationManagement, name=" + this.serviceName + ", descriptors=" + newDesc.length);
                }
                if (logger.isLoggable(Level.FINEST)) {
                    for (int i = 0; i < newDesc.length; ++i) {
                        logger.finest(newDesc[i].toString());
                    }
                }
                this.addAssociationDescriptor(newDesc);
                if (this.numRequires == 0) {
                    this.advertised = true;
                }
            } else {
                AssociationDescriptor[] current = this.getAssociationDescriptors();
                AssociationDescriptor[] addDesc = this.getDifference(newDesc, current);
                this.addAssociationDescriptor(addDesc);
                AssociationDescriptor[] remDesc = this.getDifference(current, newDesc);
                AssociationHandler[] handlers = this.getAssociationHandlers();
                block4: for (int i = 0; i < remDesc.length; ++i) {
                    for (int j = 0; j < handlers.length; ++j) {
                        if (!handlers[j].aDesc.equals(remDesc[i])) continue;
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("During update: terminate AssociationHandler for " + handlers[j].aDesc.toString());
                        }
                        handlers[j].terminate();
                        if (handlers[j].aDesc.getAssociationType().getType() == 2) {
                            --this.numRequires;
                            this.listener.requiredAssociations.remove(handlers[j].association);
                        }
                        ArrayList arrayList = this.associationHandlers;
                        synchronized (arrayList) {
                            this.associationHandlers.remove(handlers[j]);
                            continue block4;
                        }
                    }
                }
                this.listener.checkAdvertise();
            }
        }
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    private AssociationDescriptor[] getDifference(AssociationDescriptor[] desc1, AssociationDescriptor[] desc2) {
        ArrayList<AssociationDescriptor> diffList = new ArrayList<AssociationDescriptor>();
        block0: for (int i = 0; i < desc1.length; ++i) {
            boolean matched = false;
            for (int j = 0; j < desc2.length; ++j) {
                if (desc1[i].equals(desc2[j])) {
                    matched = true;
                    continue block0;
                }
                if (matched) continue;
                diffList.add(desc1[i]);
            }
        }
        return diffList.toArray(new AssociationDescriptor[diffList.size()]);
    }

    private AssociationHandler getAssociationHandler(Association association) {
        AssociationHandler handler = null;
        AssociationHandler[] handlers = this.getAssociationHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (!handlers[i].getAssociation().equals(association)) continue;
            handler = handlers[i];
            break;
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssociationHandler[] getAssociationHandlers() {
        ArrayList<AssociationHandler> list = new ArrayList<AssociationHandler>();
        ArrayList arrayList = this.associationHandlers;
        synchronized (arrayList) {
            for (AssociationHandler ah : this.associationHandlers) {
                list.add(ah);
            }
        }
        return list.toArray(new AssociationHandler[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssociationDescriptor[] getAssociationDescriptors() {
        ArrayList<AssociationDescriptor> list = new ArrayList<AssociationDescriptor>();
        ArrayList arrayList = this.associationHandlers;
        synchronized (arrayList) {
            for (AssociationHandler ah : this.associationHandlers) {
                list.add(ah.aDesc);
            }
        }
        return list.toArray(new AssociationDescriptor[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AssociationListener[] getAssociationListeners() {
        AssociationListener[] aListeners = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            aListeners = this.listeners.toArray(new AssociationListener[this.listeners.size()]);
        }
        return aListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAssociationDescriptor(AssociationDescriptor aDesc) {
        if (aDesc == null) {
            throw new NullPointerException("aDesc is null");
        }
        if (this.hasAssociationDescriptor(aDesc)) {
            return;
        }
        if (aDesc.getAssociationType().getType() == 2) {
            ++this.numRequires;
        }
        ArrayList arrayList = this.associationHandlers;
        synchronized (arrayList) {
            AssociationHandler handler = this.createAssociationHandler(aDesc);
            this.associationHandlers.add(handler);
            handler.exec();
        }
    }

    protected AssociationHandler createAssociationHandler(AssociationDescriptor aDesc) {
        if (aDesc == null) {
            throw new NullPointerException("aDesc is null");
        }
        return new AssociationHandler(aDesc);
    }

    private void addAssociationDescriptor(AssociationDescriptor[] aDescs) {
        if (aDescs == null) {
            throw new NullPointerException("aDescs is null");
        }
        for (int i = 0; i < aDescs.length; ++i) {
            this.addAssociationDescriptor(aDescs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAssociationDescriptor(AssociationDescriptor aDesc) {
        boolean hasOne = false;
        ArrayList arrayList = this.associationHandlers;
        synchronized (arrayList) {
            for (AssociationHandler ah : this.associationHandlers) {
                if (!ah.aDesc.equals(aDesc)) continue;
                hasOne = true;
                break;
            }
        }
        return hasOne;
    }

    private void advertise() {
        try {
            if (this.control != null) {
                this.control.advertise();
                this.advertised = true;
                this.advertisePending = false;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("AssociationMgmt: Advertise ServiceBean : " + this.serviceName);
                }
            } else {
                this.advertisePending = true;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("AssociationMgmt: ServiceBean [" + this.serviceName + "] advertisement pending, ServiceBeanControl is null");
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Advertising ServiceBean", e);
        }
    }

    private void unadvertise() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[" + this.serviceName + "] unadvertiseOnBroken : " + this.unadvertiseOnBroken);
        }
        if (this.unadvertiseOnBroken) {
            try {
                if (this.control != null) {
                    this.control.unadvertise();
                    this.advertised = false;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("AssociationMgmt: Unadvertise ServiceBean : " + this.serviceName);
                    }
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine("AssociationMgmt: Cannot unadvertise ServiceBean [" + this.serviceName + "], ServiceBeanControl is null");
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Unadvertising ServiceBean", e);
                }
                logger.warning("Exception [" + e.getLocalizedMessage() + "] unadvertising ServiceBean while processing Broken Association");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyOnDiscovery(Association association, Object service) {
        AssociationListener[] listeners = this.getAssociationListeners();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[" + this.serviceName + "] DISCOVERED [" + association.getName() + "], Notify [" + listeners.length + "] listeners");
        }
        try {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].discovered(association, service);
            }
        }
        finally {
            this.listener.discovered(association, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyOnChange(Association association, Object service) {
        AssociationListener[] listeners = this.getAssociationListeners();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[" + this.serviceName + "] CHANGED [" + association.getName() + "], Notify [" + listeners.length + "] listeners");
        }
        try {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].changed(association, service);
            }
        }
        finally {
            this.listener.changed(association, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyOnBroken(Association association, Object service) {
        AssociationListener[] listeners = this.getAssociationListeners();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[" + this.serviceName + "] BROKEN [" + association.getName() + "], Notify [" + listeners.length + "] listeners");
        }
        try {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].broken(association, service);
            }
        }
        finally {
            this.listener.broken(association, service);
        }
        AssociationHandler handler = this.getAssociationHandler(association);
        boolean colocatedDestroy = true;
        try {
            colocatedDestroy = (Boolean)handler.getAssociationConfig().getEntry(CONFIG_COMPONENT, "colocatedDestroy", Boolean.TYPE, (Object)true);
        }
        catch (ConfigurationException e) {
            logger.log(Level.WARNING, "Getting service.association.colocatedDestroy property from association configuration", e);
        }
        catch (NullPointerException npe) {
            logger.log(Level.SEVERE, "GS-1533: Error while notifying of a broken association.\n association: " + association + "\n Handler: " + handler + "\n associationConfig: " + (handler == null ? "n/a" : handler.getAssociationConfig()) + "\n association handlers: " + Arrays.toString(this.getAssociationHandlers()), npe);
            throw npe;
        }
        if (association.getAssociationType().getType() == 3 && colocatedDestroy) {
            try {
                Object proxy = this.context.getServiceBeanManager().getServiceBeanInstance().getService();
                if (proxy instanceof Administrable) {
                    Object admin = ((Administrable)proxy).getAdmin();
                    if (admin instanceof DestroyAdmin) {
                        ((DestroyAdmin)admin).destroy();
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.fine(this.context.getServiceElement().getName() + " admin object does not implement " + DestroyAdmin.class.getName() + " access, unable to terminate");
                    }
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this.context.getServiceElement().getName() + " does not provide an " + Administrable.class.getName() + " access, unable to terminate");
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, this.context.getServiceElement().getName() + " Destroying from broken collocated association", e);
            }
        }
    }

    private boolean isAssignableFrom(Class c1, Class c2) {
        if (c1.isAssignableFrom(c2)) {
            return true;
        }
        String n1 = c1.getName();
        for (Class sup = c2; sup != null; sup = sup.getSuperclass()) {
            if (!n1.equals(sup.getName())) continue;
            return true;
        }
        return false;
    }

    class ColocatedListener
    implements FaultDetectionHandler,
    ServiceBeanContainerListener {
        Uuid uuid;
        ServiceID serviceID;
        Object service;
        FaultDetectionListener listener;

        ColocatedListener() {
            AssociationMgmt.this.container.addListener(this);
        }

        @Override
        public void serviceInstantiated(ServiceRecord record) {
        }

        @Override
        public void serviceDiscarded(ServiceRecord record) {
            if (this.uuid.equals((Object)record.getServiceID())) {
                this.listener.serviceFailure(this.service, this.serviceID);
            }
        }

        @Override
        public void setConfiguration(String[] configArgs) {
        }

        @Override
        public void register(FaultDetectionListener listener) {
            this.listener = listener;
        }

        @Override
        public void unregister(FaultDetectionListener listener) {
        }

        @Override
        public void monitor(Object service, Object id, LookupCache lCache) throws Exception {
            this.serviceID = (ServiceID)id;
            this.uuid = UuidFactory.create((long)this.serviceID.getMostSignificantBits(), (long)this.serviceID.getLeastSignificantBits());
            this.service = service;
        }

        @Override
        public void terminate() {
            AssociationMgmt.this.container.removeListener(this);
        }
    }

    static class LookupServiceHandler
    implements DiscoveryListener {
        DiscoveryManagement dm;
        AssociationHandler handler;
        Hashtable registrarTable = new Hashtable();
        Configuration config;
        ProxyPreparer proxyPreparer;

        LookupServiceHandler(AssociationDescriptor aDesc, AssociationHandler handler, Configuration config) {
            this.handler = handler;
            try {
                this.dm = SharedDiscoveryManagement.getLookupDiscoveryManager((String[])aDesc.getGroups(), (LookupLocator[])aDesc.getLocators(), (DiscoveryListener)this);
                this.config = config;
                this.proxyPreparer = (ProxyPreparer)config.getEntry(AssociationMgmt.CONFIG_COMPONENT, "proxyPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Association [" + aDesc.getName() + "] ProxyPreparer : " + this.proxyPreparer.getClass().getName());
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Creating LookupServiceHandler", e);
            }
        }

        void terminate() {
            this.dm.removeDiscoveryListener((DiscoveryListener)this);
        }

        public void discovered(DiscoveryEvent dEvent) {
            ServiceRegistrar[] registrars = dEvent.getRegistrars();
            for (int i = 0; i < registrars.length; ++i) {
                try {
                    ServiceRegistrar sr = (ServiceRegistrar)this.proxyPreparer.prepareProxy((Object)registrars[i]);
                    this.registrarDiscovered(sr);
                    continue;
                }
                catch (RemoteException e) {
                    logger.log(Level.SEVERE, "Preparing ServiceRegistrar Proxy", e);
                }
            }
        }

        private void registrarDiscovered(ServiceRegistrar registrar) {
            try {
                ServiceID serviceID = registrar.getServiceID();
                ServiceTemplate template = new ServiceTemplate(serviceID, null, null);
                ServiceMatches matches = registrar.lookup(template, 1);
                if (matches.items.length > 0) {
                    this.registrarTable.put(registrar, serviceID);
                    this.handler.serviceDiscovered(matches.items[0]);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Adding Registrar", e);
            }
        }

        public void discarded(DiscoveryEvent dEvent) {
            ServiceRegistrar[] registrars = dEvent.getRegistrars();
            for (int i = 0; i < registrars.length; ++i) {
                ServiceID serviceID = (ServiceID)this.registrarTable.remove(registrars[i]);
                this.handler.serviceFailure(registrars[i], serviceID);
            }
        }
    }

    public class AssociationHandler
    extends ServiceDiscoveryAdapter
    implements FaultDetectionListener {
        AssociationDescriptor aDesc;
        int instances;
        Hashtable fdhTable = new Hashtable();
        Association association;
        LookupCache lCache;
        LookupServiceHandler lookupServiceHandler;
        Configuration assocConfig;
        ProxyPreparer proxyPreparer;

        public AssociationHandler(AssociationDescriptor assocDesc) {
            this.aDesc = assocDesc;
            this.association = new Association(this.aDesc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void exec() {
            block14: {
                try {
                    String[] configArgs;
                    boolean lookupService = false;
                    String[] iFaces = this.aDesc.getInterfaceNames();
                    for (int i = 0; i < iFaces.length; ++i) {
                        if (!iFaces[i].equals("net.jini.core.lookup.ServiceRegistrar")) continue;
                        lookupService = true;
                        break;
                    }
                    this.assocConfig = (configArgs = this.aDesc.getConfigArgs()) == null ? EmptyConfiguration.INSTANCE : ConfigurationProvider.getInstance((String[])configArgs);
                    Comparator comparator = (Comparator)this.assocConfig.getEntry(AssociationMgmt.CONFIG_COMPONENT, "comparator", Comparator.class, null);
                    if (comparator != null) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("AssociationManagement for [" + AssociationMgmt.this.context.getServiceElement().getName() + "], set comparator=[" + comparator.getClass().getName() + "]");
                        }
                        this.association.setServiceComparator(comparator);
                    }
                    if (this.association.getAssociationType().getType() == 3) {
                        ServiceBeanInstance[] instances = AssociationMgmt.this.container.getServiceBeanInstances(null);
                        String[] iNames = this.aDesc.getInterfaceNames();
                        Class[] interfaces = new Class[iNames.length];
                        for (int i = 0; i < interfaces.length; ++i) {
                            interfaces[i] = Class.forName(iNames[i], false, AssociationMgmt.this.callerCL);
                        }
                        final Thread currentThread = Thread.currentThread();
                        ClassLoader cCL = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return currentThread.getContextClassLoader();
                            }
                        });
                        try {
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    currentThread.setContextClassLoader(AssociationMgmt.this.callerCL);
                                    return null;
                                }
                            });
                            for (int i = 0; i < instances.length; ++i) {
                                Object service;
                                ServiceBeanInstance serviceBeanInstance = instances[i];
                                if (this.aDesc.matchOnName() && !this.aDesc.getName().equals(serviceBeanInstance.getServiceBeanConfig().getName()) || !AssociationMgmt.this.isAssignableFrom(interfaces[0], (service = serviceBeanInstance.getService()).getClass())) continue;
                                ServiceItem item = this.makeServiceItem(serviceBeanInstance);
                                this.serviceDiscovered(item);
                            }
                        }
                        catch (Throwable throwable) {
                            AccessController.doPrivileged(new PrivilegedAction(currentThread, cCL){
                                final /* synthetic */ Thread val$currentThread;
                                final /* synthetic */ ClassLoader val$cCL;
                                {
                                    this.val$currentThread = thread;
                                    this.val$cCL = classLoader;
                                }

                                public Object run() {
                                    this.val$currentThread.setContextClassLoader(this.val$cCL);
                                    return null;
                                }
                            });
                            throw throwable;
                        }
                        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                        break block14;
                    }
                    if (!lookupService) {
                        this.proxyPreparer = (ProxyPreparer)this.assocConfig.getEntry(AssociationMgmt.CONFIG_COMPONENT, "proxyPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Association [" + this.aDesc.getName() + "] ProxyPreparer : " + this.proxyPreparer.getClass().getName());
                        }
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("AssociationManagement for [" + AssociationMgmt.this.context.getServiceElement().getName() + "], get LookupCache for [" + this.aDesc.getName() + "]");
                        }
                        ServiceTemplate template = JiniClient.getServiceTemplate(this.aDesc, AssociationMgmt.this.callerCL);
                        LookupCachePool lcPool = LookupCachePool.getInstance();
                        String sharedName = this.aDesc.getOperationalStringName();
                        this.lCache = lcPool.getLookupCache(sharedName, this.aDesc.getGroups(), this.aDesc.getLocators(), template);
                        this.lCache.addListener((ServiceDiscoveryListener)this);
                    } else {
                        this.lookupServiceHandler = new LookupServiceHandler(this.aDesc, this, this.assocConfig);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Creating an AssociationHandler", e);
                }
            }
        }

        Configuration getAssociationConfig() {
            return this.assocConfig;
        }

        void terminate() {
            if (this.lCache != null) {
                try {
                    this.lCache.removeListener((ServiceDiscoveryListener)this);
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Exception {0} removing Listener from LookupCache", new Object[]{t.getClass().getName()});
                }
            }
            Set keySet = this.fdhTable.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                FaultDetectionHandler fdh = (FaultDetectionHandler)this.fdhTable.get(it.next());
                if (fdh == null) continue;
                fdh.terminate();
            }
            if (this.lookupServiceHandler != null) {
                this.lookupServiceHandler.terminate();
            }
        }

        private ServiceItem makeServiceItem(ServiceBeanInstance instance) throws IOException, ClassNotFoundException {
            Uuid uuid = instance.getServiceBeanID();
            ServiceID serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
            Entry[] attrs = null;
            Object service = instance.getService();
            if (service instanceof Administrable) {
                try {
                    Object admin = ((Administrable)service).getAdmin();
                    if (admin instanceof JoinAdmin) {
                        attrs = ((JoinAdmin)admin).getLookupAttributes();
                    }
                }
                catch (RemoteException e) {
                    logger.log(Level.WARNING, "Getting attributes from [" + this.getAssociation().getName() + "]", e);
                }
            }
            return new ServiceItem(serviceID, service, attrs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceAdded(ServiceDiscoveryEvent sdEvent) {
            ServiceItem item = sdEvent.getPostEventServiceItem();
            final Thread currentThread = Thread.currentThread();
            ClassLoader cCL = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return currentThread.getContextClassLoader();
                }
            });
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        currentThread.setContextClassLoader(AssociationMgmt.this.callerCL);
                        return null;
                    }
                });
                item = new MarshalledObject<ServiceItem>(item).get();
                item.service = this.proxyPreparer.prepareProxy(item.service);
                this.serviceDiscovered(item);
            }
            catch (Exception e) {
                try {
                    logger.log(Level.WARNING, "(Un)Marshalling ServiceItem", e);
                }
                catch (Throwable throwable) {
                    AccessController.doPrivileged(new PrivilegedAction(currentThread, cCL){
                        final /* synthetic */ Thread val$currentThread;
                        final /* synthetic */ ClassLoader val$cCL;
                        {
                            this.val$currentThread = thread;
                            this.val$cCL = classLoader;
                        }

                        public Object run() {
                            this.val$currentThread.setContextClassLoader(this.val$cCL);
                            return null;
                        }
                    });
                    throw throwable;
                }
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }

        protected void serviceDiscovered(ServiceItem item) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "[" + AssociationMgmt.this.serviceName + "] Service Discovered {0}", new Object[]{item.service.getClass().getName()});
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "[" + AssociationMgmt.this.serviceName + "] Service Discovered {0} {1} ", new Object[]{item.service.getClass().getName(), item.service.getClass().getClassLoader().toString()});
            }
            if (this.association.addService(item)) {
                int state = this.association.getState();
                if (state == 7 || 10 == state) {
                    this.association.setState(8);
                }
                this.increment();
                this.setFaultDetectionHandler(item.service, item.serviceID);
                AssociationMgmt.this.notifyOnDiscovery(this.association, item.service);
            }
        }

        @Override
        public void serviceFailure(Object proxy, ServiceID serviceID) {
            this.decrement();
            ServiceItem item = this.association.removeService(serviceID);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("[" + AssociationMgmt.this.serviceName + "] Service FAILURE : " + item.service.getClass().getName());
            }
            if (item == null) {
                return;
            }
            this.notifyOnFailure(item);
            this.fdhTable.remove(serviceID);
        }

        protected void notifyOnFailure(ServiceItem item) {
            if (this.instances > 0) {
                this.association.setState(9);
                AssociationMgmt.this.notifyOnChange(this.association, item.service);
            } else {
                this.association.setState(10);
                AssociationMgmt.this.notifyOnBroken(this.association, item.service);
            }
        }

        protected int instances() {
            return this.instances;
        }

        protected void increment() {
            ++this.instances;
        }

        protected void decrement() {
            --this.instances;
        }

        public Association getAssociation() {
            return this.association;
        }

        protected void setFaultDetectionHandler(Object service, ServiceID serviceID) {
            try {
                FaultDetectionHandler fdh = null;
                if (this.getAssociation().getAssociationType().getType() == 3) {
                    fdh = new ColocatedListener();
                } else {
                    ClassLoader cl = service.getClass().getClassLoader();
                    fdh = FaultDetectionHandlerFactory.getFaultDetectionHandler(this.aDesc, cl);
                }
                this.registerFaultDetectionHandler(service, serviceID, fdh);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Setting FaultDetectionHandler", e);
            }
        }

        protected void registerFaultDetectionHandler(Object service, ServiceID serviceID, FaultDetectionHandler fdh) throws Exception {
            fdh.register(this);
            fdh.monitor(service, serviceID, this.lCache);
            this.fdhTable.put(serviceID, fdh);
        }
    }

    class Listener
    implements AssociationListener {
        List requiredAssociations = Collections.synchronizedList(new ArrayList());

        Listener() {
        }

        @Override
        public void discovered(Association association, Object service) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[" + AssociationMgmt.this.serviceName + "] num discovered=" + AssociationMgmt.this.numRequires + ", association type=" + (association.getAssociationType().getType() == 2 ? "REQUIRES" : "USES"));
            }
            if (AssociationMgmt.this.numRequires == 0 || association.getAssociationType().getType() != 2 || this.requiredAssociations.contains(association)) {
                return;
            }
            this.requiredAssociations.add(association);
            this.checkAdvertise();
        }

        void checkAdvertise() {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Check advertise for [" + AssociationMgmt.this.serviceName + "] advertised=" + AssociationMgmt.this.advertised + ", numRequires=" + AssociationMgmt.this.numRequires + ", requiredAssociations.size()=" + this.requiredAssociations.size());
            }
            if (this.requiredAssociations.size() >= AssociationMgmt.this.numRequires && !AssociationMgmt.this.advertised) {
                AssociationMgmt.this.advertise();
            } else if (this.requiredAssociations.size() < AssociationMgmt.this.numRequires && AssociationMgmt.this.advertised) {
                AssociationMgmt.this.unadvertise();
            }
        }

        void checkUnadvertise() {
            if (this.requiredAssociations.size() < AssociationMgmt.this.numRequires && AssociationMgmt.this.advertised) {
                AssociationMgmt.this.unadvertise();
            }
        }

        @Override
        public void changed(Association association, Object service) {
        }

        @Override
        public void broken(Association association, Object service) {
            if (association.getAssociationType().getType() == 2) {
                this.requiredAssociations.remove(association);
                AssociationMgmt.this.unadvertise();
            }
        }
    }
}

