/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.boot;

import com.gigaspaces.time.SystemTime;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import net.jini.discovery.Constants;

public class MulticastStatus {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkMulticast(int timeout) throws IOException {
        if (!Constants.isMulticastEnabled()) {
            return;
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Invalid timeout = " + timeout);
        }
        InetAddress group = Constants.getRequestAddress();
        int port = Constants.getDiscoveryPort() + 1;
        final long endMillis = SystemTime.timeMillis() + (long)timeout;
        final MulticastSocket msocket = new MulticastSocket(port);
        msocket.setTimeToLive(1);
        msocket.joinGroup(group);
        msocket.setSoTimeout(timeout);
        String message = MulticastStatus.class.getName() + ".ping(" + SystemTime.timeMillis() + ")";
        byte[] messageBytes = message.getBytes();
        DatagramPacket packet = new DatagramPacket(messageBytes, messageBytes.length, group, port);
        final Object lock = new Object();
        final Boolean[] received = new Boolean[]{Boolean.FALSE};
        Thread receiveThread = new Thread("MulticastStatus"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] buf = new byte[1024];
                DatagramPacket recv = new DatagramPacket(buf, buf.length);
                while (true) {
                    try {
                        msocket.receive(recv);
                        Object object = lock;
                        synchronized (object) {
                            received[0] = Boolean.TRUE;
                        }
                        return;
                    }
                    catch (InterruptedIOException e) {
                        return;
                    }
                    catch (Throwable e) {
                        long remainingMillis = endMillis - SystemTime.timeMillis();
                        if (remainingMillis <= 0L) {
                            return;
                        }
                        try {
                            msocket.setSoTimeout((int)remainingMillis);
                        }
                        catch (SocketException e2) {
                            return;
                        }
                    }
                }
            }
        };
        receiveThread.start();
        do {
            msocket.send(packet);
            Object object = lock;
            synchronized (object) {
                if (received[0].booleanValue()) {
                    msocket.leaveGroup(group);
                    msocket.close();
                    return;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (SystemTime.timeMillis() < endMillis);
        msocket.leaveGroup(group);
        msocket.close();
        throw new IOException("Multicast packets were not received in the allocated time");
    }

    public static void main(String[] args) {
        try {
            MulticastStatus.checkMulticast(5000);
            System.out.println("Multicast check successful");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

