/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.core.AssociationDescriptor;
import org.jini.rio.core.AssociationType;

public class Association
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final int PENDING = 7;
    public static final int DISCOVERED = 8;
    public static final int CHANGED = 9;
    public static final int BROKEN = 10;
    private int state = 7;
    private AssociationDescriptor aDesc;
    private transient LinkedList serviceList = new LinkedList();
    private transient Comparator serviceComparator;

    public Association(AssociationDescriptor aDesc) {
        if (aDesc == null) {
            throw new NullPointerException("aDesc is null");
        }
        this.aDesc = aDesc;
    }

    public AssociationType getAssociationType() {
        return this.aDesc.getAssociationType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int state) {
        if (state < 7 || state > 10) {
            throw new IllegalStateException("invalid state : " + state);
        }
        Association association = this;
        synchronized (association) {
            this.state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        int currentState;
        Association association = this;
        synchronized (association) {
            currentState = this.state;
        }
        return currentState;
    }

    public String getName() {
        return this.aDesc.getName();
    }

    public String getOperationalStringName() {
        return this.aDesc.getOperationalStringName();
    }

    public AssociationDescriptor getAssociationDescriptor() {
        return this.aDesc;
    }

    public Object getService() throws NoSuchElementException {
        Object service = null;
        ServiceItem item = this.getServiceItem();
        if (item != null) {
            service = item.service;
        }
        return service;
    }

    public Object[] getServices() {
        ServiceItem[] items = this.getServiceItems();
        Object[] objects = new Object[items.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = items[i].service;
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceItem getServiceItem() {
        this.sortServices();
        ServiceItem item = null;
        try {
            LinkedList linkedList = this.serviceList;
            synchronized (linkedList) {
                item = (ServiceItem)this.serviceList.getFirst();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return item;
    }

    public ServiceItem getServiceItem(Object service) {
        ServiceItem item = null;
        ServiceItem[] items = this.getServiceItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].service.equals(service)) continue;
            item = items[i];
            break;
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceItem[] getServiceItems() {
        this.sortServices();
        ServiceItem[] items = null;
        LinkedList linkedList = this.serviceList;
        synchronized (linkedList) {
            items = this.serviceList.toArray(new ServiceItem[this.serviceList.size()]);
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addService(ServiceItem item) {
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        ServiceItem[] items = this.getServiceItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].serviceID.equals((Object)item.serviceID)) continue;
            return false;
        }
        LinkedList linkedList = this.serviceList;
        synchronized (linkedList) {
            this.serviceList.add(item);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceItem removeService(ServiceID serviceID) {
        if (serviceID == null) {
            throw new NullPointerException("serviceID is null");
        }
        ServiceItem item = null;
        ServiceItem[] items = this.getServiceItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].serviceID.equals((Object)serviceID)) continue;
            LinkedList linkedList = this.serviceList;
            synchronized (linkedList) {
                this.serviceList.remove(items[i]);
                item = items[i];
                break;
            }
        }
        return item;
    }

    public void setServiceComparator(Comparator serviceComparator) {
        if (serviceComparator == null) {
            throw new NullPointerException("serviceComparator is null");
        }
        this.serviceComparator = serviceComparator;
    }

    private void sortServices() {
        if (this.serviceComparator != null && this.serviceList.size() > 1) {
            Collections.sort(this.serviceList, this.serviceComparator);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.serviceList = new LinkedList();
    }
}

