/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import java.io.Serializable;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.LookupGroups;
import org.jini.rio.core.AssociationType;
import org.jini.rio.core.ClassBundle;

public class AssociationDescriptor
implements Serializable {
    static final long serialVersionUID = 1L;
    private AssociationType type;
    private String[] interfaceNames;
    private String name;
    private String operationalStringName;
    private ClassBundle fdhBundle;
    private String[] groups;
    private LookupLocator[] lookupLocators;
    private boolean matchOnName = false;
    private String propertyName;
    private String[] configArgs;

    public AssociationDescriptor(AssociationType type, String name, String operationalStringName) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.type = type;
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
        this.operationalStringName = operationalStringName;
    }

    public AssociationDescriptor(AssociationType type, String name, String operationalStringName, String propertyName) {
        this(type, name, operationalStringName);
        this.propertyName = propertyName;
    }

    public AssociationDescriptor(AssociationType type, String name, String operationalStringName, String propertyName, String[] confArgs) {
        this(type, name, operationalStringName);
        this.propertyName = propertyName;
        if (confArgs != null) {
            this.configArgs = new String[confArgs.length];
            System.arraycopy(confArgs, 0, this.configArgs, 0, this.configArgs.length);
        }
    }

    public AssociationDescriptor(AssociationType type, String name, String[] interfaces, String operationalStringName) {
        this(type, name, operationalStringName);
        this.setInterfaceNames(interfaces);
    }

    public AssociationType getAssociationType() {
        return this.type;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getName() {
        return this.name;
    }

    public String[] getConfigArgs() {
        return this.configArgs;
    }

    public void setMatchOnName(boolean matchOnName) {
        this.matchOnName = matchOnName;
    }

    public boolean matchOnName() {
        return this.matchOnName;
    }

    public void setInterfaceNames(String[] interfaces) {
        if (interfaces == null) {
            return;
        }
        this.interfaceNames = new String[interfaces.length];
        System.arraycopy(interfaces, 0, this.interfaceNames, 0, this.interfaceNames.length);
    }

    public String[] getInterfaceNames() {
        if (this.interfaceNames == null) {
            return new String[0];
        }
        String[] iNames = new String[this.interfaceNames.length];
        System.arraycopy(this.interfaceNames, 0, iNames, 0, this.interfaceNames.length);
        return iNames;
    }

    public String getOperationalStringName() {
        return this.operationalStringName;
    }

    public void setOperationalStringName(String operationalStringName) {
        this.operationalStringName = operationalStringName;
    }

    public void setFaultDetectionHandlerBundle(ClassBundle fdhBundle) {
        this.fdhBundle = fdhBundle;
    }

    public ClassBundle getFaultDetectionHandlerBundle() {
        return this.fdhBundle;
    }

    public void setGroups(String[] groups) {
        if (groups == LookupGroups.all()) {
            groups = new String[]{"all"};
        } else {
            for (int i = 0; i < groups.length; ++i) {
                if (!groups[i].equals("")) continue;
                groups[i] = "public";
            }
        }
        this.groups = groups;
    }

    public void setLocators(LookupLocator[] lookupLocators) {
        this.lookupLocators = lookupLocators;
    }

    public String[] getGroups() {
        String[] adjustedGroups = this.groups;
        if (this.groups == null || this.groups.length == 0) {
            adjustedGroups = LookupGroups.none();
        }
        if (adjustedGroups != null && adjustedGroups.length > 0) {
            if (adjustedGroups.length == 1 && adjustedGroups[0].equals("all")) {
                adjustedGroups = LookupGroups.all();
            } else {
                for (int i = 0; i < adjustedGroups.length; ++i) {
                    if (!adjustedGroups[i].equals("public")) continue;
                    adjustedGroups[i] = "";
                }
            }
        }
        return adjustedGroups;
    }

    public LookupLocator[] getLocators() {
        if (this.lookupLocators == null) {
            return new LookupLocator[0];
        }
        LookupLocator[] locators = new LookupLocator[this.lookupLocators.length];
        System.arraycopy(this.lookupLocators, 0, locators, 0, this.lookupLocators.length);
        return locators;
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + this.type.hashCode();
        hc = 37 * hc + this.name.hashCode();
        if (this.operationalStringName != null) {
            hc = 37 * hc + this.operationalStringName.hashCode();
        }
        if (this.propertyName != null) {
            hc = 37 * hc + this.propertyName.hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AssociationDescriptor)) {
            return false;
        }
        AssociationDescriptor that = (AssociationDescriptor)obj;
        if (this.type.equals(that.type) && this.name.equals(that.name)) {
            boolean matched = false;
            if (this.operationalStringName != null && that.operationalStringName != null && this.operationalStringName.equals(that.operationalStringName)) {
                matched = true;
            }
            if (this.operationalStringName == null && that.operationalStringName == null) {
                matched = true;
            }
            if (!matched) {
                return matched;
            }
            if (this.propertyName != null && that.propertyName != null && this.propertyName.equals(that.propertyName)) {
                return true;
            }
            if (this.propertyName == null && that.propertyName == null) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.interfaceNames != null) {
            for (int i = 0; i < this.interfaceNames.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.interfaceNames[i]);
            }
        } else {
            buffer.append("<null>");
        }
        String iFaces = buffer.toString();
        buffer.delete(0, buffer.length());
        if (this.groups == null) {
            buffer.append("<null>");
        } else {
            for (int i = 0; i < this.groups.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.groups[i]);
            }
        }
        String gps = buffer.toString();
        String fdh = "<null>";
        if (this.fdhBundle != null) {
            fdh = this.fdhBundle.getClassName();
        }
        String ops = "<null>";
        if (this.operationalStringName != null) {
            ops = this.operationalStringName;
        }
        if (this.propertyName != null) {
            return "Association Type=" + this.type.toString() + ", Name=" + this.name + ", Interfaces=" + iFaces + ", Groups=" + gps + ", MatchOnName=" + this.matchOnName + ", OperationalString=" + ops + ", Property=" + this.propertyName + ", FaultDetectionHandler=" + fdh;
        }
        return "Association Type=" + this.type.toString() + ", Name=" + this.name + ", Interfaces=" + iFaces + ", Groups=" + gps + ", MatchOnName=" + this.matchOnName + ", OperationalString=" + ops + ", FaultDetectionHandler=" + fdh;
    }
}

