/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.url.httpmd.HttpmdUtil;
import org.jini.rio.resources.util.PropertyHelper;

public class ClassBundle
implements Serializable {
    static final long serialVersionUID = 1L;
    private final String className;
    private String codebase;
    private List jarNames = Collections.synchronizedList(new ArrayList());
    private final List jarResources = Collections.synchronizedList(new ArrayList());
    private final Map sharedComponents = Collections.synchronizedMap(new HashMap());
    private final Map methodClassTable = Collections.synchronizedMap(new HashMap());
    private final Map methodObjectTable = Collections.synchronizedMap(new HashMap());
    private boolean computeHttpMD = false;
    private String algorithm = "sha";
    private final Map httpmdResourceMap = Collections.synchronizedMap(new HashMap());
    private static final Logger logger = Logger.getLogger("org.jini.rio.core");

    public ClassBundle(String className) {
        if (className == null) {
            throw new NullPointerException("className is null");
        }
        this.className = className;
    }

    public ClassBundle(String className, String[] jarNames) {
        this(className, jarNames, null, null, null, null);
    }

    public ClassBundle(String className, String[] jarNames, String codebase) {
        this(className, jarNames, null, null, null, codebase);
    }

    public ClassBundle(String className, String[] jarNames, String[] methodNames, Object[] methodArgs) {
        this(className, jarNames, null, null, null, null);
        if (methodNames.length != methodArgs.length) {
            throw new IllegalArgumentException("methodNames and methodArgs must be the same length");
        }
        for (int i = 0; i < methodNames.length; ++i) {
            this.addMethod(methodNames[i], (Object[])methodArgs[i]);
        }
    }

    public ClassBundle(String className, String[] jarNames, String[] methodNames, Object[] methodArgs, String codebase) {
        this(className, jarNames, null, null, null, codebase);
        if (methodNames.length != methodArgs.length) {
            throw new IllegalArgumentException("methodNames and methodArgs must be the same length");
        }
        for (int i = 0; i < methodNames.length; ++i) {
            this.addMethod(methodNames[i], (Object[])methodArgs[i]);
        }
    }

    public ClassBundle(String className, String[] jarNames, Map shComponents) {
        this(className, jarNames, shComponents, null, null, null);
    }

    public ClassBundle(String className, String[] jarNames, Map shComponents, String codebase) {
        this(className, jarNames, shComponents, null, null, codebase);
    }

    public ClassBundle(String className, String[] jarNames, Map shComponents, String algorithm, Map httpmdLocations, String codebase) {
        if (className == null) {
            throw new NullPointerException("className cannot be null");
        }
        this.className = className;
        if (jarNames != null) {
            this.addJARs(jarNames);
        }
        if (shComponents != null) {
            this.addSharedComponents(shComponents);
        }
        if (algorithm != null) {
            this.algorithm = algorithm;
        }
        if (httpmdLocations != null) {
            this.addJARHttpmdLocations(httpmdLocations);
        }
        this.codebase = codebase;
    }

    public void setCodebase(String codebase) {
        if (codebase != null) {
            this.codebase = codebase;
            if (!this.codebase.endsWith("/")) {
                this.codebase = this.codebase + "/";
            }
        }
    }

    public String getCodebase() {
        return this.translateCodebase();
    }

    public void setAlgorithm(String algorithm) {
        if (algorithm != null) {
            this.algorithm = algorithm;
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean getComputeHttpMD() {
        return this.computeHttpMD;
    }

    public void setComputeHttpMD(boolean computeHttpmd) {
        this.computeHttpMD = computeHttpmd;
    }

    public String getClassName() {
        return this.className;
    }

    public void addJARHttpmdLocation(String resource, String location) {
        if (resource == null) {
            throw new NullPointerException("resource is null");
        }
        if (location == null) {
            throw new NullPointerException("location is null");
        }
        this.httpmdResourceMap.put(resource, location);
    }

    public void addJARHttpmdLocations(Map m) {
        if (m == null) {
            return;
        }
        this.httpmdResourceMap.putAll(m);
    }

    public void addJARs(String[] jars) {
        if (jars == null) {
            throw new NullPointerException("jars cannot be null");
        }
        for (int i = 0; i < jars.length; ++i) {
            this.jarNames.add(jars[i]);
        }
    }

    public void addJAR(String jar) {
        if (jar == null) {
            throw new NullPointerException("jar cannot be null");
        }
        this.jarNames.add(jar);
    }

    public void addSharedComponents(Map m) {
        if (m == null) {
            return;
        }
        this.sharedComponents.putAll(m);
    }

    public void addSharedComponent(String name, String[] jarNames) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (jarNames == null) {
            throw new NullPointerException("jarNames cannot be null");
        }
        this.sharedComponents.put(name, jarNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass() throws ClassNotFoundException, MalformedURLException {
        Class theClass = null;
        final Thread currentThread = Thread.currentThread();
        ClassLoader cCL = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return currentThread.getContextClassLoader();
            }
        });
        try {
            theClass = this.loadClass(cCL);
        }
        catch (Throwable throwable) {
            AccessController.doPrivileged(new PrivilegedAction(currentThread, cCL){
                final /* synthetic */ Thread val$currentThread;
                final /* synthetic */ ClassLoader val$cCL;
                {
                    this.val$currentThread = thread;
                    this.val$cCL = classLoader;
                }

                public Object run() {
                    this.val$currentThread.setContextClassLoader(this.val$cCL);
                    return null;
                }
            });
            throw throwable;
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        return theClass;
    }

    public Class loadClass(ClassLoader parent) throws ClassNotFoundException, MalformedURLException {
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        ClassLoader loader = parent;
        URL[] urls = this.getJARs();
        if (urls != null && urls.length > 0) {
            loader = new URLClassLoader(urls, parent);
        }
        return loader.loadClass(this.className);
    }

    private URI[] toURIs(URL[] urls) {
        URI[] uris = new URI[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            try {
                URI uri;
                uris[i] = uri = new URI(url.toString());
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uris;
    }

    public String[] getJARNames() {
        return this.jarNames.toArray(new String[this.jarNames.size()]);
    }

    public URL[] getJARs() throws MalformedURLException {
        return this.urlsFromJARs(this.getJARNames());
    }

    public Map getSharedComponents() throws MalformedURLException {
        HashMap<String, URL[]> map = new HashMap<String, URL[]>();
        Set keySet = this.sharedComponents.keySet();
        for (String className : keySet) {
            URL[] urls = null;
            Object shComp = this.sharedComponents.get(className);
            if (shComp instanceof String[]) {
                String[] jarNames = (String[])this.sharedComponents.get(className);
                urls = this.urlsFromJARs(jarNames);
            }
            map.put(className, urls);
        }
        return map;
    }

    public void addMethod(String methodName, Object[] parameters) {
        if (methodName == null) {
            throw new NullPointerException("methodname is null");
        }
        if (parameters == null) {
            this.methodClassTable.put(methodName, null);
            this.methodObjectTable.put(methodName, null);
            return;
        }
        Class[] classes = new Class[parameters.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = parameters[i].getClass();
        }
        this.methodClassTable.put(methodName, classes);
        this.methodObjectTable.put(methodName, parameters);
    }

    public boolean hasMethod(String methodName) {
        if (methodName == null) {
            throw new NullPointerException("methodname is null");
        }
        return this.methodClassTable.containsKey(methodName);
    }

    public String[] getMethodNames() {
        Set keys = this.methodClassTable.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public Class[] getMethodClasses(String methodName) {
        if (methodName == null) {
            throw new NullPointerException("methodName is null");
        }
        return (Class[])this.methodClassTable.get(methodName);
    }

    public Object[] getMethodObjects(String methodName) {
        if (methodName == null) {
            throw new NullPointerException("methodName is null");
        }
        return (Object[])this.methodObjectTable.get(methodName);
    }

    public void runKnownMethods(Object object) throws Exception {
        String[] methods = this.getMethodNames();
        for (int i = 0; i < methods.length; ++i) {
            Method m = object.getClass().getMethod(methods[i], this.getMethodClasses(methods[i]));
            m.invoke(object, this.getMethodObjects(methods[i]));
        }
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + this.className.hashCode();
        hc = 37 * hc + this.getJARList().hashCode();
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassBundle)) {
            return false;
        }
        ClassBundle that = (ClassBundle)obj;
        return this.className.equals(that.className) && this.getJARList().equals(that.getJARList());
    }

    private URL[] urlsFromJARs(String[] jarNames) throws MalformedURLException {
        URL[] urls = new URL[jarNames.length];
        for (int i = 0; i < urls.length; ++i) {
            if (this.computeHttpMD) {
                try {
                    urls[i] = this.computeHttpMD(jarNames[i]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.log(Level.WARNING, "Computing Message Digest for " + jarNames[i], e);
                    urls[i] = new URL(this.translateCodebase() + jarNames[i]);
                }
                continue;
            }
            urls[i] = new URL(this.translateCodebase() + jarNames[i]);
        }
        return urls;
    }

    private ArrayList getJARList() {
        ArrayList<String> list = new ArrayList<String>();
        String[] jars = this.getJARNames();
        for (int i = 0; i < jars.length; ++i) {
            list.add(jars[i]);
        }
        return list;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ClassName=" + this.className + "\n");
        buffer.append("Codebase=" + this.codebase + "\n");
        String[] jars = this.getJARNames();
        if (jars.length > 0) {
            buffer.append("Searchpath={");
            for (int i = 0; i < jars.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(jars[i]);
            }
            buffer.append("}");
        }
        return buffer.toString();
    }

    private URL computeHttpMD(String jar) throws IOException, NoSuchAlgorithmException {
        URL jarURL = null;
        String location = (String)this.httpmdResourceMap.get(jar);
        String httpmdCodebase = "httpmd://" + this.translateCodebase().substring(7);
        if (location != null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Compute MessageDigest for JAR=" + jar + ", usingAlgorithm=" + this.algorithm + ", from Location=" + location);
            }
            File jarDirectory = new File(location);
            String httpmdUrl = HttpmdUtil.computeDigestCodebase((String)jarDirectory.getAbsolutePath(), (String)(httpmdCodebase + jar + ";" + this.algorithm + "=0"));
            jarURL = new URL(httpmdUrl);
        } else {
            URL tempURL = new URL(this.translateCodebase() + jar);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Compute MessageDigest for JAR=" + jar + ", usingAlgorithm=" + this.algorithm + ", using URL=" + tempURL.toExternalForm());
            }
            try {
                String digest = HttpmdUtil.computeDigest((URL)tempURL, (String)this.algorithm);
                jarURL = new URL(httpmdCodebase + jar + ";" + this.algorithm + "=" + digest);
            }
            catch (ConnectException e) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.WARNING, "Unable to compute message digest for JAR=" + jar + ", will use " + tempURL.toExternalForm() + " as the JAR", e);
                }
                jarURL = tempURL;
            }
        }
        return jarURL;
    }

    private synchronized void writeObject(ObjectOutputStream oStream) throws IOException {
        oStream.defaultWriteObject();
        if (this.jarResources.size() == 0) {
            URL[] urls = this.urlsFromJARs(this.getJARNames());
            for (int i = 0; i < urls.length; ++i) {
                this.jarResources.add(urls[i]);
            }
        }
    }

    private void readObject(ObjectInputStream oStream) throws IOException, ClassNotFoundException {
        URL[] urls;
        oStream.defaultReadObject();
        if (this.jarNames == null) {
            this.jarNames = new ArrayList();
        }
        if (this.jarNames.size() == 0 && (urls = this.jarResources.toArray(new URL[this.jarResources.size()])).length > 0) {
            int index;
            String exportCodebase = urls[0].toExternalForm();
            if (exportCodebase.indexOf(".jar") != -1 && (index = exportCodebase.lastIndexOf(47)) != -1) {
                exportCodebase = exportCodebase.substring(0, index + 1);
                this.setCodebase(exportCodebase);
            }
            for (int i = 0; i < urls.length; ++i) {
                String jar = this.getJarPart(urls[i]);
                this.jarNames.add(jar);
            }
        }
    }

    private String getJarPart(URL url) {
        String s = url.toExternalForm();
        int ndx = s.lastIndexOf("/");
        if (ndx == -1) {
            return "";
        }
        return s.substring(ndx + 1);
    }

    private String translateCodebase() {
        if (this.codebase == null) {
            return this.codebase;
        }
        String translated = PropertyHelper.expandProperties(this.codebase, PropertyHelper.RUNTIME);
        if (System.getProperty("os.name").startsWith("Win") && translated.startsWith("file://")) {
            translated = "file:/" + translated.substring(7);
        }
        return translated;
    }
}

