/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.jini.rio.core.ResourceCostModel;

public class GenericCostModel
implements ResourceCostModel {
    static final long serialVersionUID = 1L;
    private static final String DEFAULT_DESCRIPTION = "Generic Cost Model";
    private double costPerUnit;
    private String description = "Generic Cost Model";
    private Set timeBoundaries = new TreeSet(new Comparator(){

        public int compare(Object o1, Object o2) {
            ResourceCostModel.TimeBoundary t1 = (ResourceCostModel.TimeBoundary)o1;
            ResourceCostModel.TimeBoundary t2 = (ResourceCostModel.TimeBoundary)o2;
            return t1.compareTo(t2);
        }
    });

    public GenericCostModel(double value) {
        this(value, null, DEFAULT_DESCRIPTION);
    }

    public GenericCostModel(double value, ResourceCostModel.TimeBoundary[] timeBoundaries) {
        this(value, timeBoundaries, DEFAULT_DESCRIPTION);
    }

    public GenericCostModel(double value, ResourceCostModel.TimeBoundary[] timeBoundaries, String description) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("value cannot be NaN");
        }
        if (value < 0.0) {
            throw new IllegalArgumentException("value must be non-negative");
        }
        this.costPerUnit = value;
        if (timeBoundaries != null) {
            for (int i = 0; i < timeBoundaries.length; ++i) {
                this.addTimeBoundary(timeBoundaries[i]);
            }
        }
        if (description != null) {
            this.description = description;
        }
    }

    @Override
    public double getCostPerUnit(long duration) {
        ResourceCostModel.TimeBoundary[] tBoundaries = this.getTimeBoundaries();
        for (int i = tBoundaries.length - 1; i >= 0; --i) {
            if (duration < tBoundaries[i].getBoundary()) continue;
            return this.costPerUnit * tBoundaries[i].getMultiplier();
        }
        return this.costPerUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimeBoundary(ResourceCostModel.TimeBoundary timeBoundary) {
        Set set = this.timeBoundaries;
        synchronized (set) {
            this.timeBoundaries.add(timeBoundary);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceCostModel.TimeBoundary[] getTimeBoundaries() {
        ResourceCostModel.TimeBoundary[] boundaries;
        Set set = this.timeBoundaries;
        synchronized (set) {
            boundaries = this.timeBoundaries.toArray(new ResourceCostModel.TimeBoundary[this.timeBoundaries.size()]);
        }
        return boundaries;
    }

    public static void main(String[] args) {
        GenericCostModel gcm = new GenericCostModel(0.01);
        gcm.addTimeBoundary(new ResourceCostModel.TimeBoundary(5L, 10.0, 1000));
        gcm.addTimeBoundary(new ResourceCostModel.TimeBoundary(5L, 100.0, 60000));
        gcm.addTimeBoundary(new ResourceCostModel.TimeBoundary(5L, 1000.0, 3600000));
        gcm.addTimeBoundary(new ResourceCostModel.TimeBoundary(5L, 10000.0, 86400000));
        System.out.println("Testing " + gcm.getClass().getName() + "\n");
        System.out.println(gcm.getDescription());
        long twoSeconds = 2000L;
        long sixMinutes = 360000L;
        long twoHours = 0x6DDD00L;
        long sixHours = 21600000L;
        long twoDays = 172800000L;
        long tenDays = 864000000L;
        System.out.println("Cost per unit for 2 seconds : " + gcm.getCostPerUnit(twoSeconds));
        System.out.println("Cost per unit for 6 minutes : " + gcm.getCostPerUnit(sixMinutes));
        System.out.println("Cost per unit for 2 hours   : " + gcm.getCostPerUnit(twoHours));
        System.out.println("Cost per unit for 6 hours   : " + gcm.getCostPerUnit(sixHours));
        System.out.println("Cost per unit for 2 days    : " + gcm.getCostPerUnit(twoDays));
        System.out.println("Cost per unit for 10 days   : " + gcm.getCostPerUnit(tenDays));
    }
}

