/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import java.io.Serializable;
import org.jini.rio.core.ThresholdValues;

public class MeasuredResource
implements Serializable {
    static final long serialVersionUID = 1L;
    private String identifier;
    private double value;
    private ThresholdValues tValues;

    public MeasuredResource(String identifier, double value, ThresholdValues tVals) {
        if (identifier == null) {
            throw new NullPointerException("identifier is null");
        }
        if (tVals == null) {
            throw new NullPointerException("tVals is null");
        }
        this.identifier = identifier;
        this.value = value;
        this.tValues = tVals;
    }

    public double getValue() {
        return this.value;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ThresholdValues getThresholdValues() {
        return this.tValues;
    }

    public boolean thresholdCrossed() {
        return this.value < this.tValues.getLowThreshold() || this.value > this.tValues.getHighThreshold();
    }

    public boolean evaluate(ThresholdValues thresholdValue) {
        double low = thresholdValue.getLowThreshold();
        double high = thresholdValue.getHighThreshold();
        return this.value >= low && this.value <= high;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MeasuredResource) {
            if (this.getIdentifier() == null && ((MeasuredResource)obj).getIdentifier() == null) {
                return true;
            }
            if (this.getIdentifier() == null || ((MeasuredResource)obj).getIdentifier() == null) {
                return false;
            }
            return this.getIdentifier().equals(((MeasuredResource)obj).getIdentifier());
        }
        return false;
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + (this.identifier != null ? this.identifier.hashCode() : 0);
        return hc;
    }
}

