/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.StringUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.jini.rio.core.RequiredDependency;

public class RequiredDependencies
implements Externalizable {
    private static final long serialVersionUID = -1L;
    private LinkedList<RequiredDependency> requiredDependencies = new LinkedList();

    public void addRequiredDependencies(RequiredDependencies other) {
        for (String name : other.getRequiredDependenciesNames()) {
            this.addRequiredDependency(other.getRequiredDependencyByName(name));
        }
    }

    public void addRequiredDependency(RequiredDependency requiredDependency) {
        RequiredDependency existingRequiredDependency = this.getRequiredDependencyByName(requiredDependency.getRequiredProcessingUnitName());
        if (existingRequiredDependency != null) {
            existingRequiredDependency.merge(requiredDependency);
        } else {
            this.requiredDependencies.add(requiredDependency);
        }
    }

    public RequiredDependency getRequiredDependencyByName(String name) {
        RequiredDependency dependency = null;
        for (RequiredDependency requiredDependency : this.requiredDependencies) {
            if (!requiredDependency.getRequiredProcessingUnitName().equals(name)) continue;
            dependency = requiredDependency;
            break;
        }
        return dependency;
    }

    public String[] getRequiredDependenciesNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (RequiredDependency dependency : this.requiredDependencies) {
            names.add(dependency.getRequiredProcessingUnitName());
        }
        return names.toArray(new String[names.size()]);
    }

    public boolean isEmpty() {
        boolean empty = true;
        for (RequiredDependency requiredDependency : this.requiredDependencies) {
            if (requiredDependency.isEmpty()) continue;
            empty = false;
            break;
        }
        return empty;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject((ObjectOutput)out, (Object)this.requiredDependencies.toArray(new RequiredDependency[this.requiredDependencies.size()]));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.requiredDependencies = new LinkedList<Object>(Arrays.asList((Object[])IOUtils.readObject((ObjectInput)in)));
    }

    public String toString() {
        ArrayList<String> requiredDependenciesStrings = new ArrayList<String>();
        for (RequiredDependency requiredDependency : this.requiredDependencies) {
            requiredDependenciesStrings.add(requiredDependency.toString());
        }
        return StringUtils.collectionToCommaDelimitedString(requiredDependenciesStrings);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.requiredDependencies == null ? 0 : this.requiredDependencies.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequiredDependencies other = (RequiredDependencies)obj;
        return !(this.requiredDependencies == null ? other.requiredDependencies != null : !this.requiredDependencies.equals(other.requiredDependencies));
    }
}

