/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RequiredDependency
implements Externalizable {
    private static final long serialVersionUID = -1L;
    private static final String DEPENDENCY_REQUIRED_PU_NAME_KEY = "name";
    private static final String MINIMUM_NUMBER_OF_DEPLOYED_INSTANCES_KEY = "minimumNumberOfDeployedInstances";
    private static final int MINIMUM_NUMBER_OF_DEPLOYED_INSTANCES_DEFAULT = 0;
    private static final String MINIMUM_NUMBER_OF_DEPLOYED_INSTANCES_PER_PARTITION_KEY = "minimumNumberOfDeployedInstancesPerPartition";
    private static final int MINIMUM_NUMBER_OF_DEPLOYED_INSTANCES_PER_PARTITION_DEFAULT = 0;
    private static final String DEPENDENCY_WAITFOR_DEPLOYED_KEY = "waitForDeploymentToComplete";
    private static final boolean DEPENDENCY_WAITFOR_DEPLOYED_DEFAULT = false;
    private static final String DEPENDENCY_WAITFOR_STARTED_KEY = "waitForStartToComplete";
    private static final Boolean DEPENDENCY_WAITFOR_STARTED_DEFAULT = false;
    private static final String MINIMUM_NUMBER_OF_STARTED_INSTANCES_KEY = "minimumNumberOfStartedInstances";
    private static final Integer MINIMUM_NUMBER_OF_STARTED_INSTANCES_DEFAULT = 0;
    Map<String, String> properties;

    public RequiredDependency() {
    }

    public RequiredDependency(Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
        this.validate();
    }

    public RequiredDependency(String name) {
        this.properties = new HashMap<String, String>();
        this.setRequiredProcessingUnitName(name);
        this.validate();
    }

    public RequiredDependency(RequiredDependency requiredDependency) {
        this(requiredDependency.getProperties());
    }

    private void validate() {
        if (this.getRequiredProcessingUnitName() == null) {
            throw new IllegalArgumentException("name is missing");
        }
    }

    public boolean getWaitForDeploymentToComplete() {
        String value = this.properties.get(DEPENDENCY_WAITFOR_DEPLOYED_KEY);
        return value != null ? Boolean.valueOf(value) : false;
    }

    public void setWaitForDeploymentToComplete(boolean waitForDeploymentToComplete) {
        this.properties.put(DEPENDENCY_WAITFOR_DEPLOYED_KEY, String.valueOf(waitForDeploymentToComplete));
    }

    public void setMinimumNumberOfDeployedInstances(int numberOfInstances) {
        this.properties.put(MINIMUM_NUMBER_OF_DEPLOYED_INSTANCES_KEY, String.valueOf(numberOfInstances));
    }

    public int getMinimumNumberOfDeployedInstances() {
        String value = this.properties.get(MINIMUM_NUMBER_OF_DEPLOYED_INSTANCES_KEY);
        return value != null ? Integer.valueOf(value) : 0;
    }

    public void setMinimumNumberOfDeployedInstancesPerPartition(int numberOfInstancesPerPartition) {
        this.properties.put(MINIMUM_NUMBER_OF_DEPLOYED_INSTANCES_PER_PARTITION_KEY, String.valueOf(numberOfInstancesPerPartition));
    }

    public int getMinimumNumberOfDeployedInstancesPerPartition() {
        String value = this.properties.get(MINIMUM_NUMBER_OF_DEPLOYED_INSTANCES_PER_PARTITION_KEY);
        return value != null ? Integer.valueOf(value) : 0;
    }

    public String getRequiredProcessingUnitName() {
        return this.properties.get(DEPENDENCY_REQUIRED_PU_NAME_KEY);
    }

    public void setRequiredProcessingUnitName(String name) {
        this.properties.put(DEPENDENCY_REQUIRED_PU_NAME_KEY, name);
    }

    public boolean getWaitForStartToComplete() {
        String value = this.properties.get(DEPENDENCY_WAITFOR_STARTED_KEY);
        return value != null ? Boolean.valueOf(value) : DEPENDENCY_WAITFOR_STARTED_DEFAULT;
    }

    public int getMinimumNumberOfStartedInstances() {
        String value = this.properties.get(MINIMUM_NUMBER_OF_STARTED_INSTANCES_KEY);
        return value != null ? Integer.valueOf(value) : MINIMUM_NUMBER_OF_STARTED_INSTANCES_DEFAULT;
    }

    public void setWaitForStartToComplete(boolean waitForStartToComplete) {
        this.properties.put(DEPENDENCY_WAITFOR_STARTED_KEY, String.valueOf(waitForStartToComplete));
    }

    public void setMinimumNumberOfStartedInstances(int minimumNumberOfStartedInstances) {
        this.properties.put(MINIMUM_NUMBER_OF_STARTED_INSTANCES_KEY, String.valueOf(minimumNumberOfStartedInstances));
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject((ObjectOutput)out, this.properties);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.properties = (Map)IOUtils.readObject((ObjectInput)in);
        this.validate();
    }

    public String toString() {
        return this.properties.toString();
    }

    public void merge(RequiredDependency otherRequiredDependency) {
        if (otherRequiredDependency.getWaitForDeploymentToComplete() && !this.getWaitForDeploymentToComplete()) {
            this.setWaitForDeploymentToComplete(true);
        }
        if (otherRequiredDependency.getMinimumNumberOfDeployedInstances() > this.getMinimumNumberOfDeployedInstances()) {
            this.setMinimumNumberOfDeployedInstances(otherRequiredDependency.getMinimumNumberOfDeployedInstances());
        }
        if (otherRequiredDependency.getMinimumNumberOfDeployedInstancesPerPartition() > this.getMinimumNumberOfDeployedInstancesPerPartition()) {
            this.setMinimumNumberOfDeployedInstancesPerPartition(otherRequiredDependency.getMinimumNumberOfDeployedInstancesPerPartition());
        }
        if (otherRequiredDependency.getWaitForStartToComplete() && !this.getWaitForStartToComplete()) {
            this.setWaitForStartToComplete(true);
        }
        if (otherRequiredDependency.getMinimumNumberOfStartedInstances() > this.getMinimumNumberOfStartedInstances()) {
            this.setMinimumNumberOfStartedInstances(otherRequiredDependency.getMinimumNumberOfStartedInstances());
        }
    }

    public boolean isEmpty() {
        return !this.getWaitForDeploymentToComplete() && this.getMinimumNumberOfDeployedInstances() == 0 && this.getMinimumNumberOfDeployedInstancesPerPartition() == 0 && !this.getWaitForStartToComplete() && this.getMinimumNumberOfStartedInstances() == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequiredDependency other = (RequiredDependency)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }
}

