/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import java.io.Serializable;

public interface ResourceCostModel
extends Serializable {
    public double getCostPerUnit(long var1);

    public String getDescription();

    public void addTimeBoundary(TimeBoundary var1);

    public static class TimeBoundary
    implements Comparable<TimeBoundary>,
    Serializable {
        static final long serialVersionUID = 1L;
        public static final int MILLIS = 1;
        public static final int SECONDS = 1000;
        public static final int MINUTES = 60000;
        public static final int HOURS = 3600000;
        public static final int DAYS = 86400000;
        private long boundary;
        private int type;
        private double multiplier;

        public TimeBoundary(long boundary, double multiplier) {
            this(boundary, multiplier, 1);
        }

        public TimeBoundary(long boundary, double multiplier, int type) {
            if (type != 1 && type != 1000 && type != 60000 && type != 3600000 && type != 86400000) {
                throw new IllegalArgumentException("bad type [" + type + "]");
            }
            this.boundary = boundary * (long)type;
            this.multiplier = multiplier;
            this.type = type;
        }

        public long getBoundary() {
            return this.boundary;
        }

        public double getMultiplier() {
            return this.multiplier;
        }

        public int getType() {
            return this.type;
        }

        @Override
        public int compareTo(TimeBoundary that) {
            if (this.getBoundary() == that.getBoundary()) {
                return 0;
            }
            if (this.getBoundary() < that.getBoundary()) {
                return -1;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TimeBoundary)) {
                return false;
            }
            TimeBoundary that = (TimeBoundary)o;
            return this.getBoundary() == that.getBoundary() && this.getMultiplier() == that.getMultiplier();
        }

        public int hashCode() {
            return (int)this.getBoundary();
        }
    }
}

