/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import java.io.Serializable;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.watch.WatchDescriptor;

public class SLA
extends ThresholdValues
implements Serializable {
    static final long serialVersionUID = 1L;
    private String[] configArgs;
    private String identifier;
    private WatchDescriptor[] watchDescriptors;

    public SLA(String identifier, double[] range) {
        super(range);
        if (identifier == null) {
            throw new NullPointerException("identifier is null");
        }
        this.identifier = identifier;
    }

    public SLA(String identifier, double[] range, String[] configArray) {
        this(identifier, range, configArray, null);
    }

    public SLA(String identifier, double[] range, String[] configArray, WatchDescriptor[] watchDescs) {
        super(range);
        if (identifier == null) {
            throw new NullPointerException("identifier is null");
        }
        this.identifier = identifier;
        if (configArray != null) {
            this.configArgs = new String[configArray.length];
            System.arraycopy(configArray, 0, this.configArgs, 0, configArray.length);
        }
        if (watchDescs != null) {
            this.watchDescriptors = new WatchDescriptor[watchDescs.length];
            System.arraycopy(watchDescs, 0, this.watchDescriptors, 0, watchDescs.length);
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String[] getConfigArgs() {
        if (this.configArgs == null) {
            return new String[0];
        }
        String[] args = new String[this.configArgs.length];
        System.arraycopy(this.configArgs, 0, args, 0, this.configArgs.length);
        return args;
    }

    public WatchDescriptor[] getWatchDescriptors() {
        if (this.watchDescriptors == null) {
            return new WatchDescriptor[0];
        }
        WatchDescriptor[] wds = new WatchDescriptor[this.watchDescriptors.length];
        System.arraycopy(this.watchDescriptors, 0, wds, 0, this.watchDescriptors.length);
        return wds;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("ID=" + this.getIdentifier() + ", ");
        b.append("Low: " + this.getLowThreshold() + ", ");
        b.append("High: " + this.getHighThreshold() + "\n");
        b.append("Configuration:\n");
        for (int i = 0; i < this.configArgs.length; ++i) {
            if (i > 0) {
                b.append("\n");
            }
            b.append(this.configArgs[i]);
        }
        return b.toString();
    }
}

