/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class Schedule
implements Serializable {
    static final long serialVersionUID = 2L;
    private int month;
    private int day;
    private int hour;
    private int minute;
    public static final long INDEFINITE = -1L;
    public static final long MINIMUM_REPEAT_INTERVAL = 5000L;
    private long duration = -1L;
    private long repeatCount;
    private long repeatInterval;
    private boolean useDayOfMonth = false;
    private boolean useToday = false;
    private boolean useCurrentHour = false;

    public Schedule() {
    }

    public Schedule(long duration, long repeatCount, long repeatInterval) {
        this.useCurrentHour = true;
        this.init(0, 0, 0, duration, repeatCount, repeatInterval);
    }

    public Schedule(int minute, long duration, long repeatCount, long repeatInterval) {
        this.useToday = true;
        this.useCurrentHour = true;
        this.init(0, 0, minute, duration, repeatCount, repeatInterval);
    }

    public Schedule(int hour, int minute, long duration, long repeatCount, long repeatInterval) {
        this.useToday = true;
        this.init(0, hour, minute, duration, repeatCount, repeatInterval);
    }

    public Schedule(int dayOfWeek, int hour, int minute, long duration, long repeatCount, long repeatInterval) {
        GregorianCalendar cal = new GregorianCalendar();
        int min = ((Calendar)cal).getMinimum(7);
        int max = ((Calendar)cal).getMaximum(7);
        if (dayOfWeek < min || dayOfWeek > max) {
            throw new IllegalArgumentException("Bad dayOfWeek : " + dayOfWeek);
        }
        this.month = cal.get(2);
        this.init(dayOfWeek, hour, minute, duration, repeatCount, repeatInterval);
    }

    public Schedule(int month, int dayOfMonth, int hour, int minute, long duration, long repeatCount, long repeatInterval) {
        GregorianCalendar cal = new GregorianCalendar();
        int monthMin = ((Calendar)cal).getMinimum(2);
        int monthMax = ((Calendar)cal).getMaximum(2);
        if (month < monthMin || month > monthMax) {
            throw new IllegalArgumentException("bad month : " + month);
        }
        this.month = month;
        int currentMonth = cal.get(2);
        if (month < currentMonth) {
            ((Calendar)cal).roll(1, true);
        }
        cal.setLenient(false);
        try {
            cal.set(2, month);
            cal.set(5, dayOfMonth);
            cal.getTime();
        }
        catch (IllegalArgumentException e) {
            cal.setLenient(true);
            throw new IllegalArgumentException("Invalid Date " + (month + 1) + "/" + dayOfMonth + "/" + cal.get(1));
        }
        this.useDayOfMonth = true;
        this.init(dayOfMonth, hour, minute, duration, repeatCount, repeatInterval);
    }

    public Date getStartDate() {
        GregorianCalendar cal = new GregorianCalendar();
        if (this.day == 0 && this.hour == 0 && this.minute == 0 && !this.useToday) {
            return cal.getTime();
        }
        boolean rollYear = false;
        boolean rollMonth = false;
        int calculatedDay = this.useToday ? cal.get(7) : this.day;
        int calculatedMonth = this.useToday ? cal.get(2) : this.month;
        int calculatedHour = this.useCurrentHour ? cal.get(11) : this.hour;
        int currentMonth = cal.get(2);
        if (calculatedMonth < currentMonth) {
            rollYear = true;
        }
        int dayOfMonth = cal.get(5);
        if (!this.useDayOfMonth) {
            int currentDOW = cal.get(7);
            if (this.day == 0) {
                calculatedDay = currentDOW;
            }
            if (currentDOW != calculatedDay) {
                dayOfMonth = currentDOW < calculatedDay ? (dayOfMonth += calculatedDay - currentDOW) : 7 - (currentDOW - calculatedDay) + dayOfMonth;
            }
        } else {
            if (calculatedDay < dayOfMonth) {
                rollMonth = true;
            }
            dayOfMonth = calculatedDay;
        }
        GregorianCalendar gCal = new GregorianCalendar(cal.get(1), calculatedMonth, dayOfMonth, calculatedHour, this.minute);
        if (rollYear) {
            gCal.roll(1, true);
        } else if (rollMonth) {
            gCal.roll(2, true);
        } else {
            long time = gCal.getTimeInMillis();
            if (time < System.currentTimeMillis()) {
                gCal.set(7, cal.get(7));
                gCal.roll(5, true);
            }
        }
        return gCal.getTime();
    }

    public long getDuration() {
        return this.duration;
    }

    public long getRepeatCount() {
        return this.repeatCount;
    }

    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + this.month;
        hc = 37 * hc + this.day;
        hc = 37 * hc + this.hour;
        hc = 37 * hc + this.minute;
        hc = 37 * hc + (int)(this.duration ^ this.duration >>> 32);
        hc = 37 * hc + (int)(this.repeatCount ^ this.repeatCount >>> 32);
        hc = 37 * hc + (int)(this.repeatInterval ^ this.repeatInterval >>> 32);
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule that = (Schedule)obj;
        return this.month == that.month && this.day == that.day && this.hour == that.hour && this.minute == that.minute && this.duration == that.duration && this.repeatCount == that.repeatCount && this.repeatInterval == that.repeatInterval;
    }

    public String toString() {
        return "month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + ", minute=" + this.minute + ", duration=" + this.duration + ", repeatCount=" + this.repeatCount + ", repeatInterval=" + this.repeatInterval;
    }

    private void init(int day, int hour, int minute, long duration, long repeatCount, long repeatInterval) {
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("bad hour [" + hour + "]");
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("bad minute [" + minute + "]");
        }
        this.duration = duration;
        this.repeatCount = repeatCount;
        if (repeatCount > 0L && duration == -1L) {
            throw new IllegalArgumentException("cannot repeat a duration set to INDEFINITE");
        }
        if (repeatInterval < 5000L) {
            throw new IllegalArgumentException("bad repeatInterval, must be greater then 5000");
        }
        this.repeatInterval = repeatInterval;
    }

    public static void main(String[] args) {
        GregorianCalendar cal = new GregorianCalendar();
        System.out.println("Today : " + cal.getTime());
        System.out.println("-----------");
        Schedule s = new Schedule(0, 1, 0, 0, 10000L, 2L, 3000L);
        System.out.println(s.toString());
        System.out.println("Computed Time : " + s.getStartDate());
        System.out.println("-----------");
        s = new Schedule(2, 10, 10, 10000L, 2L, 3000L);
        System.out.println(s.toString());
        System.out.println("Computed Time : " + s.getStartDate());
        System.out.println("-----------");
        s = new Schedule(20, 0, 10000L, 2L, 3000L);
        System.out.println(s.toString());
        System.out.println("Computed Time : " + s.getStartDate());
        System.out.println("-----------");
        s = new Schedule(0, 10000L, 2L, 3000L);
        System.out.println(s.toString());
        System.out.println("Computed Time : " + s.getStartDate());
        System.out.println("-----------");
        s = new Schedule();
        System.out.println(s.toString());
        System.out.println("Computed Time : " + s.getStartDate());
    }
}

