/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.LookupGroups;
import org.jini.rio.core.RequiredDependencies;

public class ServiceBeanConfig
implements Serializable {
    static final long serialVersionUID = 1L;
    private Map initParameters = new HashMap();
    private Map configParms = new HashMap();
    private String[] configArgs;
    public static final String COMPONENT = "configComponent";
    public static final String NAME = "serviceName";
    public static final String JMX_NAME = "jmxName";
    public static final String ORGANIZATION = "organization";
    public static final String COMMENT = "serviceComment";
    public static final String OPSTRING = "opStringName";
    public static final String GROUPS = "lookupGroups";
    public static final String LOCATORS = "lookupLocators";
    public static final String LOGGER = "loggerConfig";
    public static final String LOG_DIRECTORY = "logDirectory";
    public static final String HOST_HISTORY = "hostList";
    public static final String INSTANCE_ID = "instanceID";
    public static final String SERVICE_PROVISION_CONFIG = "provisionConfig";
    public static final String ADAPTIVE_CODEBASE = "adaptiveCodebase";
    public static final String CONFIGURED_CODEBASE = "configuredCodebase";
    public static final String INITIAL_PLANNED_SERVICES = "initial.planned";
    public static final String WATCHES = "watches";
    public static final String ELASTIC_PROPERTIES = "elasticProperties";
    public static final String INSTANCE_DEPLOYMENT_REQUIRED_DEPENDENCIES = "instanceDeploymentDependencies";
    private static final String INSTANCE_START_REQUIRED_DEPENDENCIES = "instanceStartDependencies";
    private static final String APPLICATION_NAME = "applicationName";

    public ServiceBeanConfig(Map configMap, String[] configArgs) {
        if (configMap == null) {
            throw new NullPointerException("configParms is null");
        }
        if (configArgs == null) {
            throw new NullPointerException("configArgs is null");
        }
        this.configParms.putAll(configMap);
        if (this.configParms.get(HOST_HISTORY) == null) {
            this.configParms.put(HOST_HISTORY, new ArrayList());
        }
        if (this.configParms.get(INSTANCE_ID) == null) {
            this.configParms.put(INSTANCE_ID, new Long(0L));
        }
        if (this.getElasticProperties() == null) {
            this.setElasticProperties(new HashMap<String, String>());
        }
        if (this.getInstanceDeploymentDependencies() == null) {
            this.setInstanceDeploymentDependencies(new RequiredDependencies());
        }
        if (this.getInstanceStartDependencies() == null) {
            this.setInstanceStartDependencies(new RequiredDependencies());
        }
        this.configArgs = new String[configArgs.length];
        System.arraycopy(configArgs, 0, this.configArgs, 0, this.configArgs.length);
    }

    public void setName(String name) {
        if (name != null) {
            this.configParms.put(NAME, name);
        }
    }

    public String getName() {
        String name = (String)this.configParms.get(NAME);
        return name == null ? "" : name;
    }

    public String getOperationalStringName() {
        String name = (String)this.configParms.get(OPSTRING);
        return name == null ? "" : name;
    }

    public void setOperationalStringName(String name) {
        if (name != null) {
            this.configParms.put(OPSTRING, name);
        }
    }

    public String getComment() {
        return (String)this.configParms.get(COMMENT);
    }

    public String getOrganization() {
        return (String)this.configParms.get(ORGANIZATION);
    }

    public void setGroups(String[] groups) {
        if (groups == LookupGroups.all()) {
            groups = new String[]{"all"};
        } else {
            for (int i = 0; i < groups.length; ++i) {
                if (!groups[i].equals("")) continue;
                groups[i] = "public";
            }
        }
        this.configParms.put(GROUPS, groups);
    }

    public void setElasticProperties(Map<String, String> elasticProperties) {
        this.configParms.put(ELASTIC_PROPERTIES, elasticProperties);
    }

    public Map<String, String> getElasticProperties() {
        return (Map)this.configParms.get(ELASTIC_PROPERTIES);
    }

    public RequiredDependencies getInstanceDeploymentDependencies() {
        return (RequiredDependencies)this.configParms.get(INSTANCE_DEPLOYMENT_REQUIRED_DEPENDENCIES);
    }

    public void setInstanceDeploymentDependencies(RequiredDependencies dependencies) {
        this.configParms.put(INSTANCE_DEPLOYMENT_REQUIRED_DEPENDENCIES, dependencies);
    }

    public String getApplicationName() {
        return (String)this.configParms.get(APPLICATION_NAME);
    }

    public void setApplicationName(String applicationName) {
        this.configParms.put(APPLICATION_NAME, applicationName);
    }

    public RequiredDependencies getInstanceStartDependencies() {
        return (RequiredDependencies)this.configParms.get(INSTANCE_START_REQUIRED_DEPENDENCIES);
    }

    public void setInstanceStartDependencies(RequiredDependencies startRequiredDependencies) {
        this.configParms.put(INSTANCE_START_REQUIRED_DEPENDENCIES, startRequiredDependencies);
    }

    public String[] getGroups() {
        String[] groups = (String[])this.configParms.get(GROUPS);
        if (groups == null || groups.length == 0) {
            groups = LookupGroups.none();
        }
        if (groups != null && groups.length > 0) {
            if (groups.length == 1 && groups[0].equals("all")) {
                groups = LookupGroups.all();
            } else {
                for (int i = 0; i < groups.length; ++i) {
                    if (!groups[i].equals("public")) continue;
                    groups[i] = "";
                }
            }
        }
        return groups;
    }

    public void setLocators(LookupLocator[] lookupLocators) {
        this.configParms.put(LOCATORS, lookupLocators);
    }

    public LookupLocator[] getLocators() {
        return (LookupLocator[])this.configParms.get(LOCATORS);
    }

    public void addInitParameter(Object name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.initParameters.put(name, value);
    }

    public void removeInitParameter(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.initParameters.remove(name);
    }

    public Map getInitParameters() {
        return this.initParameters;
    }

    public Map getConfigurationParamaters() {
        HashMap map = new HashMap();
        map.putAll(this.configParms);
        return map;
    }

    public String getLogDir() {
        return (String)this.configParms.get(LOG_DIRECTORY);
    }

    public Long getInstanceID() {
        return (Long)this.configParms.get(INSTANCE_ID);
    }

    public void setInstanceID(Long instanceID) {
        this.configParms.put(INSTANCE_ID, instanceID);
    }

    public String[] getConfigArgs() {
        if (this.configArgs == null) {
            return new String[0];
        }
        String[] args = new String[this.configArgs.length];
        System.arraycopy(this.configArgs, 0, args, 0, this.configArgs.length);
        return args;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("configComponent=" + this.configParms.get(COMPONENT) + "\n");
        buffer.append("serviceName=" + this.configParms.get(NAME) + "\n");
        buffer.append("organization=" + this.configParms.get(ORGANIZATION) + "\n");
        buffer.append("serviceComment=" + this.configParms.get(COMMENT) + "\n");
        buffer.append("opStringName=" + this.configParms.get(OPSTRING) + "\n");
        String[] groups = (String[])this.configParms.get(GROUPS);
        buffer.append("lookupGroups={");
        for (int i2 = 0; i2 < groups.length; ++i2) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            buffer.append(groups[i2]);
        }
        buffer.append("}\n");
        LookupLocator[] locators = (LookupLocator[])this.configParms.get(LOCATORS);
        buffer.append("lookupLocators={");
        if (locators != null) {
            for (int i3 = 0; i3 < locators.length; ++i3) {
                if (i3 > 0) {
                    buffer.append(", ");
                }
                buffer.append("\t" + locators[i3].toString() + "\n");
            }
        } else {
            buffer.append("n/a");
        }
        buffer.append("}\n");
        Object[] lConfigs = (Object[])this.configParms.get(LOGGER);
        if (lConfigs != null) {
            buffer.append("loggerConfig=\n");
            for (i = 0; i < lConfigs.length; ++i) {
                buffer.append(lConfigs[i].toString());
            }
        } else {
            buffer.append("loggerConfig={n/a}\n");
        }
        buffer.append("logDirectory=" + this.configParms.get(LOG_DIRECTORY) + "\n");
        buffer.append("instanceID=" + this.getInstanceID() + "\n");
        buffer.append("Initialization Parameters=\n");
        buffer.append(this.initParameters.toString() + "\n");
        buffer.append("Configuration Properties=\n");
        for (i = 0; i < this.configArgs.length; ++i) {
            if (i > 0) {
                buffer.append("\n");
            }
            buffer.append(this.configArgs[i]);
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

