/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import com.sun.jini.proxy.MarshalledWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.jini.id.Uuid;
import net.jini.io.MarshalledInstance;
import org.jini.rio.core.ServiceBeanConfig;

public class ServiceBeanInstance
implements Serializable {
    static final long serialVersionUID = 1L;
    private final Uuid sbID;
    private final MarshalledInstance mi;
    private transient Object service;
    private ServiceBeanConfig sbConfig;
    private final String hostAddress;
    private final String hostName;
    private transient boolean verifyCodebaseIntegrity;

    public ServiceBeanInstance(Uuid identifier, MarshalledInstance mi, ServiceBeanConfig sbConfig) {
        this(identifier, mi, sbConfig, null, null);
    }

    public ServiceBeanInstance(Uuid identifier, MarshalledInstance mi, ServiceBeanConfig sbConfig, String hostAddress, String hostName) {
        if (identifier == null) {
            throw new NullPointerException("identifier is null");
        }
        if (mi == null) {
            throw new NullPointerException("mi is null");
        }
        this.sbID = identifier;
        this.mi = mi;
        this.setServiceBeanConfig(sbConfig);
        this.hostAddress = hostAddress;
        this.hostName = hostName;
    }

    public Uuid getServiceBeanID() {
        return this.sbID;
    }

    public MarshalledInstance getMarshalledInstance() {
        return this.mi;
    }

    public Object getService() throws IOException, ClassNotFoundException {
        if (this.service == null) {
            this.service = this.mi.get(this.verifyCodebaseIntegrity);
        }
        return this.service;
    }

    public void setServiceBeanConfig(ServiceBeanConfig sbConfig) {
        if (sbConfig == null) {
            throw new NullPointerException("sbConfig is null");
        }
        this.sbConfig = sbConfig;
    }

    public ServiceBeanConfig getServiceBeanConfig() {
        return this.sbConfig;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int hashCode() {
        return this.sbID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServiceBeanInstance)) {
            return false;
        }
        ServiceBeanInstance other = (ServiceBeanInstance)obj;
        return this.sbID.equals((Object)other.sbID);
    }

    public String toString() {
        String serviceClassName = "";
        try {
            this.getService();
            serviceClassName = this.service.getClass().getName();
        }
        catch (Exception e) {
            serviceClassName = "unknown : system error";
        }
        String serviceName = "<null>";
        String instanceID = "<null>";
        if (this.sbConfig != null) {
            serviceName = this.sbConfig.getName();
            Long id = this.sbConfig.getInstanceID();
            if (id != null) {
                instanceID = id.toString();
            }
        }
        return "Name=[" + serviceName + "] Instance=[" + instanceID + "] Proxy=[" + serviceClassName + "] ID=[" + this.sbID.toString() + "] HostAddress=[" + (this.hostAddress == null ? "null" : this.hostAddress) + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.verifyCodebaseIntegrity = MarshalledWrapper.integrityEnforced((ObjectInputStream)in);
    }

    public String getPresentationName() {
        return this.getServiceBeanConfig().getName() + " [" + this.getServiceBeanConfig().getInstanceID() + "]";
    }

    public Long getInstanceId() {
        return this.getServiceBeanConfig().getInstanceID();
    }
}

