/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jini.rio.core.AssociationDescriptor;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.RequiredDependencies;
import org.jini.rio.core.ServiceBeanConfig;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.jsb.ServiceElementUtil;

public class ServiceElement
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final int EXTERNAL = 0;
    public static final int DYNAMIC = 1;
    public static final int FIXED = 2;
    public static final int DEFAULT_PROVISION_TYPE = 1;
    private int provisionType = 1;
    private ServiceBeanConfig sbConfig;
    private AssociationDescriptor[] associations;
    private ClassBundle componentBundle;
    private final ClassBundle[] exportBundles;
    private final Collection provisionableCapabilities = new ArrayList();
    private final ServiceLevelAgreements slAgreements;
    private boolean matchOnName = false;
    private boolean autoAdvertise = true;
    private boolean discoPool = true;
    private int planned;
    private int relocateInstanceCount;
    private int maxPerMachine = -1;
    private int maxPerPhysicalMachine = -1;
    private boolean requiresIsolation;
    private int totalNumberOfServices = 1;
    private int actual;
    private String[] machineCluster;
    private String[] requiredZones;
    private Map<String, Integer> maxPerZone = new HashMap<String, Integer>();
    private final ClassBundle fdhBundle;
    private boolean probPrimary;

    public String toString() {
        return ServiceElementUtil.getNameWithId(this);
    }

    public String toFullString() {
        return "ServiceElement{\n\t actual=" + this.actual + "\n\t provisionType=" + this.provisionType + "\n\t sbConfig=" + this.sbConfig + "\n\t associations=" + (this.associations == null ? null : Arrays.asList(this.associations)) + "\n\t componentBundle=" + this.componentBundle + "\n\t exportBundles=" + (this.exportBundles == null ? null : Arrays.asList(this.exportBundles)) + "\n\t provisionableCapabilities=" + this.provisionableCapabilities + "\n\t slAgreements=" + this.slAgreements + "\n\t matchOnName=" + this.matchOnName + "\n\t autoAdvertise=" + this.autoAdvertise + "\n\t discoPool=" + this.discoPool + "\n\t planned=" + this.planned + "\n\t maxPerMachine=" + this.maxPerMachine + "\n\t requiresIsolation=" + this.requiresIsolation + "\n\t maxPerPhysicalMachine=" + this.maxPerPhysicalMachine + "\n\t totalNumberOfServices=" + this.totalNumberOfServices + "\n\t machineCluster=" + (this.machineCluster == null ? null : Arrays.asList(this.machineCluster)) + "\n\t fdhBundle=" + this.fdhBundle + '}';
    }

    public ServiceElement(int provisionType, ServiceBeanConfig sbConfig, ServiceLevelAgreements slAgreements, ClassBundle[] exports, ClassBundle fdhBundle) {
        this(provisionType, sbConfig, slAgreements, exports, fdhBundle, null);
    }

    public ServiceElement(int provisionType, ServiceBeanConfig sbConfig, ServiceLevelAgreements slAgreements, ClassBundle[] exports, ClassBundle fdhBundle, ClassBundle componentBundle) {
        if (provisionType < 0 && provisionType > 2) {
            throw new IllegalArgumentException("unknown provisionType : " + provisionType);
        }
        if (sbConfig == null) {
            throw new NullPointerException("sbConfig is null");
        }
        if (slAgreements == null) {
            throw new NullPointerException("slAgreements is null");
        }
        if (exports == null) {
            throw new NullPointerException("exports is null");
        }
        if (fdhBundle == null) {
            throw new NullPointerException("fdhBundle is null");
        }
        this.fdhBundle = fdhBundle;
        this.provisionType = provisionType;
        this.exportBundles = new ClassBundle[exports.length];
        System.arraycopy(exports, 0, this.exportBundles, 0, exports.length);
        this.componentBundle = componentBundle;
        this.setServiceBeanConfig(sbConfig);
        this.slAgreements = slAgreements;
    }

    public int getProvisionType() {
        return this.provisionType;
    }

    public String getName() {
        return this.sbConfig.getName();
    }

    public Long getInstanceId() {
        return this.sbConfig.getInstanceID();
    }

    public void setPlanned(int planned) {
        if (planned < 0) {
            throw new IllegalArgumentException("planned cannot be less then 0");
        }
        this.planned = planned;
    }

    public void incrementPlanned() {
        ++this.planned;
    }

    public void decrementPlanned() {
        if (this.planned > 0) {
            --this.planned;
        }
    }

    public int getPlanned() {
        return this.planned;
    }

    public void incrementRelocateInstanceCount() {
        ++this.relocateInstanceCount;
    }

    public void decrementRelocateInstanceCount() {
        if (this.relocateInstanceCount > 0) {
            --this.relocateInstanceCount;
        }
    }

    public void setRelocateInstanceCount(int relocateInstanceCount) {
        this.relocateInstanceCount = relocateInstanceCount;
    }

    public int getRelocateInstanceCount() {
        return this.relocateInstanceCount;
    }

    public void setActual(int actual) {
        this.actual = actual;
    }

    public int getActual() {
        return this.actual;
    }

    public boolean isRequiresIsolation() {
        return this.requiresIsolation;
    }

    public void setRequiresIsolation(boolean requiresIsolation) {
        this.requiresIsolation = requiresIsolation;
    }

    public void setMaxPerMachine(int maxPerMachine) {
        if (maxPerMachine < -1) {
            throw new IllegalArgumentException("maxPerMachine cannot be less then -1");
        }
        this.maxPerMachine = maxPerMachine;
    }

    public int getMaxPerMachine() {
        return this.maxPerMachine;
    }

    public void setMaxPerPhysicalMachine(int maxPerPhysicalMachine) {
        if (maxPerPhysicalMachine < -1) {
            throw new IllegalArgumentException("maxPerPhysicalMachine cannot be less then -1");
        }
        this.maxPerPhysicalMachine = maxPerPhysicalMachine;
    }

    public int getMaxPerPhysicalMachine() {
        return this.maxPerPhysicalMachine;
    }

    public void setTotalNumberOfServices(int totalNumberOfServices) {
        if (totalNumberOfServices < 0) {
            throw new IllegalArgumentException("totalNumberOfServices can't be less than zero");
        }
        this.totalNumberOfServices = totalNumberOfServices;
    }

    public int getTotalNumberOfServices() {
        return this.totalNumberOfServices;
    }

    public String[] getRequiredZones() {
        return this.requiredZones;
    }

    public void addRequiredZone(String zone) {
        if (this.requiredZones == null) {
            this.requiredZones = new String[]{zone};
        } else {
            ArrayList<String> zones = new ArrayList<String>();
            for (String zone1 : this.requiredZones) {
                zones.add(zone1);
            }
            zones.add(zone);
            this.requiredZones = zones.toArray(new String[zones.size()]);
        }
    }

    public void setRequiredZones(String[] requiredZones) {
        this.requiredZones = requiredZones;
    }

    public Map<String, Integer> getMaxPerZone() {
        return this.maxPerZone;
    }

    public void setMaxPerZone(Map<String, Integer> maxPerZone) {
        this.maxPerZone = maxPerZone;
    }

    public void addMaxPerZone(String zone, int count) {
        this.maxPerZone.put(zone, count);
    }

    public void setCluster(String[] machineCluster) {
        this.machineCluster = machineCluster;
    }

    public String[] getCluster() {
        if (this.machineCluster == null) {
            return new String[0];
        }
        String[] cluster = new String[this.machineCluster.length];
        System.arraycopy(this.machineCluster, 0, cluster, 0, this.machineCluster.length);
        return cluster;
    }

    public ClassBundle getFaultDetectionHandlerBundle() {
        return this.fdhBundle;
    }

    public void setServiceBeanConfig(ServiceBeanConfig sbConfig) {
        if (sbConfig == null) {
            throw new NullPointerException("sbConfig is null");
        }
        this.sbConfig = sbConfig;
    }

    public ServiceBeanConfig getServiceBeanConfig() {
        return this.sbConfig;
    }

    public String getOperationalStringName() {
        return this.sbConfig.getOperationalStringName();
    }

    public void setAutoAdvertise(boolean autoAdvertise) {
        this.autoAdvertise = autoAdvertise;
    }

    public boolean getAutoAdvertise() {
        return this.autoAdvertise;
    }

    public void setDiscoveryManagementPooling(boolean discoPool) {
        this.discoPool = discoPool;
    }

    public boolean getDiscoveryManagementPooling() {
        return this.discoPool;
    }

    public void setMatchOnName(boolean matchOnName) {
        this.matchOnName = matchOnName;
    }

    public boolean getMatchOnName() {
        return this.matchOnName;
    }

    public void setComponentBundle(ClassBundle componentBundle) {
        this.componentBundle = componentBundle;
    }

    public ClassBundle getComponentBundle() {
        return this.componentBundle;
    }

    public ClassBundle[] getExportBundles() {
        ClassBundle[] bundle = new ClassBundle[this.exportBundles.length];
        System.arraycopy(this.exportBundles, 0, bundle, 0, this.exportBundles.length);
        return bundle;
    }

    public URL[] getExportURLs() throws MalformedURLException {
        ArrayList<URL> list = new ArrayList<URL>();
        for (int i = 0; i < this.exportBundles.length; ++i) {
            URL[] urls = this.exportBundles[i].getJARs();
            for (int j = 0; j < urls.length; ++j) {
                list.add(urls[j]);
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    public ServiceLevelAgreements getServiceLevelAgreements() {
        return this.slAgreements;
    }

    public void setAssociationDescriptors(AssociationDescriptor[] assocDescs) {
        if (assocDescs != null) {
            this.associations = new AssociationDescriptor[assocDescs.length];
            System.arraycopy(assocDescs, 0, this.associations, 0, this.associations.length);
        }
    }

    public AssociationDescriptor[] getAssociationDescriptors() {
        if (this.associations == null) {
            return new AssociationDescriptor[0];
        }
        AssociationDescriptor[] aDescs = new AssociationDescriptor[this.associations.length];
        System.arraycopy(this.associations, 0, aDescs, 0, this.associations.length);
        return aDescs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProvisionablePlatformCapabilities(Collection downloadableCapabilities) {
        Collection collection = this.provisionableCapabilities;
        synchronized (collection) {
            this.provisionableCapabilities.clear();
            this.provisionableCapabilities.addAll(downloadableCapabilities);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getProvisionablePlatformCapabilities() {
        ArrayList collection = new ArrayList();
        Collection collection2 = this.provisionableCapabilities;
        synchronized (collection2) {
            collection.addAll(this.provisionableCapabilities);
        }
        return collection;
    }

    @Deprecated
    public void recomputeMessageDigests() throws Exception {
    }

    public boolean isSameOperationalString(ServiceElement serviceElement) {
        return this.getOperationalStringName().equals(serviceElement.getOperationalStringName());
    }

    public boolean isSameServiceName(ServiceElement serviceElement) {
        return this.getServiceBeanConfig().getName().equals(serviceElement.getServiceBeanConfig().getName());
    }

    public void setProbPrimary(boolean probPrimary) {
        this.probPrimary = probPrimary;
    }

    public boolean isProbPrimary() {
        return this.probPrimary;
    }

    public String getProcessingUnitType() {
        return (String)this.getServiceBeanConfig().getInitParameters().get("pu.type");
    }

    public Map<String, String> getElasticProperties() {
        return this.sbConfig.getElasticProperties();
    }

    public void setElasticProperties(Map<String, String> elasticProperties) {
        this.sbConfig.setElasticProperties(elasticProperties);
    }

    public RequiredDependencies getInstanceDeploymentDependencies() {
        return this.sbConfig.getInstanceDeploymentDependencies();
    }

    public RequiredDependencies getInstanceStartDependencies() {
        return this.sbConfig.getInstanceStartDependencies();
    }

    public String getApplicationName() {
        return this.sbConfig.getApplicationName();
    }

    public void setInstanceDeploymentDependencies(RequiredDependencies deploymentRequiredDependencies) {
        this.sbConfig.setInstanceDeploymentDependencies(deploymentRequiredDependencies);
    }

    public void setInstanceStartDependencies(RequiredDependencies startRequiredDependencies) {
        this.sbConfig.setInstanceStartDependencies(startRequiredDependencies);
    }

    public void setApplicationName(String applicationName) {
        this.sbConfig.setApplicationName(applicationName);
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + this.getName().hashCode();
        hc = 37 * hc + this.getOperationalStringName().hashCode();
        for (int i = 0; i < this.exportBundles.length; ++i) {
            hc = 37 * hc + this.exportBundles[i].hashCode();
        }
        hc = 37 * hc + (this.componentBundle == null ? 0 : this.componentBundle.hashCode());
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServiceElement)) {
            return false;
        }
        ServiceElement that = (ServiceElement)obj;
        if (this.getName().equals(that.getName()) && this.getOperationalStringName().equals(that.getOperationalStringName())) {
            if (this.exportBundles.length != that.exportBundles.length) {
                return false;
            }
            for (int i = 0; i < this.exportBundles.length; ++i) {
                boolean matched = false;
                for (int j = 0; j < that.exportBundles.length; ++j) {
                    if (!this.exportBundles[i].equals(that.exportBundles[j])) continue;
                    matched = true;
                }
                if (matched) continue;
                return false;
            }
            if (this.componentBundle == null && that.componentBundle == null) {
                return true;
            }
            if (this.componentBundle != null && that.componentBundle != null) {
                return this.componentBundle.equals(that.componentBundle);
            }
        }
        return false;
    }

    public String getDebugName() {
        String name = "";
        if (this.exportBundles.length > 0) {
            name = this.getExportBundles()[0].getClassName() + ": ";
        }
        name = name + this.getName() + " <" + this.getInstanceId() + ">";
        return name;
    }
}

