/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jini.rio.core.SLA;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.core.provision.SoftwareLoad;
import org.jini.rio.qos.capability.PlatformCapability;

public class ServiceLevelAgreements
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final String SYSTEM = "System";
    private List systemCapabilities = new ArrayList();
    private List systemRequirements = new ArrayList();
    private Map systemThresholds = new HashMap();
    private List serviceSLAs = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemThreshold(String identifier, ThresholdValues tVals) {
        if (identifier == null) {
            throw new NullPointerException("identifier is null");
        }
        if (tVals == null) {
            throw new NullPointerException("tVals is null");
        }
        Map map = this.systemThresholds;
        synchronized (map) {
            this.systemThresholds.put(identifier, tVals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSystemThresholdIDs() {
        String[] keys = null;
        Map map = this.systemThresholds;
        synchronized (map) {
            Set keySet = this.systemThresholds.keySet();
            keys = keySet.toArray(new String[keySet.size()]);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThresholdValues getSystemThresholdValue(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is null");
        }
        ThresholdValues tVals = null;
        Map map = this.systemThresholds;
        synchronized (map) {
            tVals = (ThresholdValues)this.systemThresholds.get(identifier);
        }
        return tVals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addSystemRequirement(PlatformCapability capability) throws IOException {
        if (capability == null) {
            throw new NullPointerException("capability is null");
        }
        List list = this.systemCapabilities;
        synchronized (list) {
            this.systemCapabilities.add(new MarshalledObject<PlatformCapability>(capability));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemRequirement(SystemRequirement requirement) {
        if (requirement == null) {
            throw new NullPointerException("requirement is null");
        }
        List list = this.systemRequirements;
        synchronized (list) {
            this.systemRequirements.add(requirement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemRequirement[] getSystemRequirements() {
        SystemRequirement[] sysReqs = null;
        List list = this.systemRequirements;
        synchronized (list) {
            sysReqs = this.systemRequirements.toArray(new SystemRequirement[this.systemRequirements.size()]);
        }
        return sysReqs;
    }

    public boolean hasProvisionableCapability() {
        SystemRequirement[] sReqs = this.getSystemRequirements();
        for (int i = 0; i < sReqs.length; ++i) {
            if (sReqs[i].getSoftwareLoad() == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceSLA(SLA sla) {
        if (sla == null) {
            throw new NullPointerException("sla is null");
        }
        List list = this.serviceSLAs;
        synchronized (list) {
            this.serviceSLAs.add(sla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLA[] getServiceSLAs() {
        SLA[] slas = null;
        List list = this.serviceSLAs;
        synchronized (list) {
            slas = this.serviceSLAs.toArray(new SLA[this.serviceSLAs.size()]);
        }
        return slas;
    }

    private void readObject(ObjectInputStream oStream) throws IOException, ClassNotFoundException {
        oStream.defaultReadObject();
        if (this.systemRequirements == null) {
            this.systemRequirements = new ArrayList();
        }
    }

    public static class SystemRequirement
    implements Serializable {
        static final long serialVersionUID = 1L;
        private String name;
        private String className;
        private Map attributes = new HashMap();
        private SoftwareLoad softwareLoad;
        private URL[] location;

        public SystemRequirement(String name, String className, Map attrs) {
            int ndx;
            if (name == null && className == null) {
                throw new NullPointerException("name and className are null");
            }
            this.className = className;
            this.name = name == null ? ((ndx = className.lastIndexOf(".")) > 0 ? className.substring(ndx + 1) : className) : name;
            if (attrs != null) {
                this.attributes.putAll(attrs);
            }
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public void setSoftwareLoad(SoftwareLoad swLoad) {
            this.softwareLoad = swLoad;
        }

        public SoftwareLoad getSoftwareLoad() {
            return this.softwareLoad;
        }

        public void setClasspath(URL[] urls) {
            if (urls != null) {
                this.location = new URL[urls.length];
                System.arraycopy(urls, 0, this.location, 0, this.location.length);
            }
        }

        public URL[] getClasspath() {
            if (this.location == null) {
                this.location = new URL[0];
            }
            return this.location;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("Name=" + (this.name == null ? "<null>" : this.name) + ", ");
            buff.append("ClassName=" + (this.className == null ? "<null>" : this.className) + ", ");
            buff.append("Attributes=" + this.attributes.toString());
            return buff.toString();
        }
    }
}

