/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core.jsb;

public class ServiceBeanState {
    public static final int INACTIVE = 0;
    public static final int INITIALIZED = 1;
    public static final int STOPPED = 2;
    public static final int STARTED = 3;
    public static final int UNADVERTISED = 4;
    public static final int ADVERTISED = 5;
    public static final int ERROR = 6;
    public static final int ABORTED = 7;
    private int state = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        int theState;
        ServiceBeanState serviceBeanState = this;
        synchronized (serviceBeanState) {
            theState = this.state;
        }
        return theState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int newState) {
        if (newState == this.getState()) {
            return;
        }
        if (newState < 0 || newState > 7) {
            throw new IllegalStateException("newState out of bounds [" + newState + "]");
        }
        ServiceBeanState serviceBeanState = this;
        synchronized (serviceBeanState) {
            this.verifyTransition(newState);
            this.state = newState;
        }
    }

    public void verifyTransition(int newState) {
        boolean validTransition = false;
        if (this.isAborted()) {
            throw new IllegalStateException("Current state is ABORTED, transition not allowed from");
        }
        if (ServiceBeanState.hasErrors(this.getState())) {
            return;
        }
        switch (newState) {
            case 1: {
                if (this.getState() >= 1) break;
                validTransition = true;
                break;
            }
            case 3: {
                if (this.getState() >= 3) break;
                validTransition = true;
                break;
            }
            case 2: {
                if (this.getState() != 3 && this.getState() != 4) break;
                validTransition = true;
                break;
            }
            case 4: {
                if (this.getState() != 5 && this.getState() != 2) break;
                validTransition = true;
                break;
            }
            case 5: {
                if (this.getState() != 3 && this.getState() != 4) break;
                validTransition = true;
                break;
            }
            case 6: {
                validTransition = true;
                break;
            }
            case 0: {
                if (this.getState() != 2) break;
                validTransition = true;
            }
        }
        if (!validTransition) {
            throw new IllegalStateException("New state [" + ServiceBeanState.toString(newState) + "] not allowed from [" + ServiceBeanState.toString(this.getState()) + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAborted() {
        boolean aborted = false;
        ServiceBeanState serviceBeanState = this;
        synchronized (serviceBeanState) {
            if (this.getState() == 7) {
                aborted = true;
            }
        }
        return aborted;
    }

    public static boolean isInProgress(int state) {
        return state == 1 || state == 3;
    }

    public static boolean hasErrors(int state) {
        return state == 6;
    }

    public static String toString(int state) {
        String desc = null;
        switch (state) {
            case 1: {
                desc = "INITIALIZED";
                break;
            }
            case 3: {
                desc = "STARTED";
                break;
            }
            case 2: {
                desc = "STOPPED";
                break;
            }
            case 4: {
                desc = "UNADVERTISED";
                break;
            }
            case 5: {
                desc = "ADVERTISED";
                break;
            }
            case 0: {
                desc = "INACTIVE";
                break;
            }
            case 7: {
                desc = "ABORTED";
            }
        }
        return desc;
    }

    public String toString() {
        return ServiceBeanState.toString(this.getState());
    }
}

