/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core.provision;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.jini.id.Uuid;
import org.jini.rio.core.ResourceCost;
import org.jini.rio.core.ServiceElement;

public class ServiceRecord
implements Comparable,
Serializable {
    static final long serialVersionUID = 1L;
    public static final int ACTIVE_SERVICE_RECORD = 1;
    public static final int INACTIVE_SERVICE_RECORD = 2;
    private Uuid uuid;
    private String hostName;
    private String hostAddress;
    private Date instantiated;
    private Date updated;
    private Date discarded;
    private ServiceElement sElem;
    private int type;
    private List resourceCosts = new ArrayList();

    public ServiceRecord(Uuid uuid, ServiceElement sElem, String hostName, String hostAddress) {
        this(uuid, sElem, hostName, hostAddress, 1, new Date());
    }

    public ServiceRecord(Uuid uuid, ServiceElement sElem, String hostName, String hostAddress, int type, Date instantiated) {
        if (uuid == null) {
            throw new NullPointerException("uuid is null");
        }
        if (sElem == null) {
            throw new NullPointerException("sElem is null");
        }
        if (hostName == null) {
            throw new NullPointerException("hostName is null");
        }
        if (hostAddress == null) {
            throw new NullPointerException("hostAddress is null");
        }
        this.setType(type);
        this.uuid = uuid;
        this.sElem = sElem;
        this.hostName = hostName;
        this.hostAddress = hostAddress;
        this.instantiated = new Date(instantiated.getTime());
    }

    public Uuid getServiceID() {
        return this.uuid;
    }

    public String getName() {
        return this.sElem.getName();
    }

    public String getPresentationName() {
        return this.getName() + " [" + this.sElem.getServiceBeanConfig().getInstanceID() + "]";
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setType(int type) {
        if (type == 0 || type != (type & 3)) {
            throw new IllegalArgumentException("bad type");
        }
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public Date getInstantiationDate() {
        Date d = null;
        if (this.instantiated != null) {
            d = new Date(this.instantiated.getTime());
        }
        return d;
    }

    public void setUpdated() {
        this.updated = new Date();
    }

    public Date getUpdated() {
        Date d = null;
        if (this.updated != null) {
            d = new Date(this.updated.getTime());
        }
        return d;
    }

    public void setDiscardedDate(Date discarded) {
        if (discarded != null) {
            this.discarded = new Date(discarded.getTime());
        }
    }

    public Date getDiscardedDate() {
        Date d = null;
        if (this.discarded != null) {
            d = new Date(this.discarded.getTime());
        }
        return d;
    }

    public ServiceElement getServiceElement() {
        return this.sElem;
    }

    public long computeElapsedTime() {
        long t0 = this.instantiated.getTime();
        long t1 = System.currentTimeMillis();
        if (this.discarded != null && (this.type & 2) != 0) {
            t1 = this.discarded.getTime();
        }
        return t1 - t0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceCost(ResourceCost resourceCost) {
        if (resourceCost == null) {
            throw new NullPointerException("resourceCost is null");
        }
        List list = this.resourceCosts;
        synchronized (list) {
            this.resourceCosts.add(resourceCost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceCost[] getResourceCosts() {
        ResourceCost[] rCosts = null;
        List list = this.resourceCosts;
        synchronized (list) {
            rCosts = this.resourceCosts.toArray(new ResourceCost[this.resourceCosts.size()]);
        }
        return rCosts;
    }

    public int compareTo(Object o) {
        ServiceRecord serviceRecord = (ServiceRecord)o;
        return this.instantiated.compareTo(serviceRecord.getInstantiationDate());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceRecord)) {
            return false;
        }
        ServiceRecord that = (ServiceRecord)o;
        return this.uuid.equals((Object)that.uuid) && this.instantiated.equals(that.instantiated);
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + this.uuid.hashCode();
        hc = 37 * hc + this.instantiated.hashCode();
        return hc;
    }
}

