/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core.provision;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.provision.ServiceRecord;

public class ServiceStatement
implements Serializable {
    static final long serialVersionUID = 1L;
    private ServiceElement sElem;
    private Map serviceRecords = new HashMap();

    public ServiceStatement(ServiceElement sElem) {
        if (sElem == null) {
            throw new NullPointerException("sElem is null");
        }
        this.sElem = sElem;
    }

    public ServiceElement getServiceElement() {
        return this.sElem;
    }

    public String getOrganization() {
        String organization = this.sElem.getServiceBeanConfig().getOrganization();
        organization = organization == null ? "" : organization;
        return organization;
    }

    public boolean hasActiveServiceRecords() {
        ServiceRecord[] records = this.getServiceRecords(1);
        return records.length != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putServiceRecord(Object key, ServiceRecord record) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (record == null) {
            throw new NullPointerException("record is null");
        }
        Map map = this.serviceRecords;
        synchronized (map) {
            List recordList = null;
            recordList = !this.serviceRecords.containsKey(key) ? new ArrayList() : (List)this.serviceRecords.get(key);
            int index = recordList.indexOf(record);
            if (index != -1) {
                recordList.set(index, record);
            } else {
                recordList.add(record);
            }
            this.serviceRecords.put(key, recordList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRecord[] getServiceRecords() {
        ArrayList collection = new ArrayList();
        Map map = this.serviceRecords;
        synchronized (map) {
            Collection values = this.serviceRecords.values();
            for (List list : values) {
                collection.addAll(list);
            }
        }
        return collection.toArray(new ServiceRecord[collection.size()]);
    }

    public ServiceRecord[] getServiceRecords(int type) {
        return this.filterServiceRecords(type, this.getServiceRecords());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRecord[] getServiceRecords(Object key, int type) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        ServiceRecord[] records = null;
        Map map = this.serviceRecords;
        synchronized (map) {
            List recordList = null;
            recordList = !this.serviceRecords.containsKey(key) ? new ArrayList() : (List)this.serviceRecords.get(key);
            records = recordList.toArray(new ServiceRecord[recordList.size()]);
        }
        return this.filterServiceRecords(type, records);
    }

    public ServiceRecord[] getServiceRecords(Object identifier) {
        return this.filterServiceRecords(identifier, this.getServiceRecords());
    }

    public ServiceRecord[] getServiceRecords(Object identifier, Object key) {
        return this.filterServiceRecords(identifier, this.getServiceRecords(key, 3));
    }

    private ServiceRecord[] filterServiceRecords(int type, ServiceRecord[] records) {
        if (type == 0 || type != (type & 3)) {
            throw new IllegalArgumentException("invalid recordType");
        }
        if ((type & 1) != 0 && (type & 2) != 0) {
            return records;
        }
        ArrayList<ServiceRecord> list = new ArrayList<ServiceRecord>();
        for (int i = 0; i < records.length; ++i) {
            if ((type & 1) != 0 && (records[i].getType() & 1) != 0) {
                list.add(records[i]);
            }
            if ((type & 2) == 0 || (records[i].getType() & 2) == 0) continue;
            list.add(records[i]);
        }
        return list.toArray(new ServiceRecord[list.size()]);
    }

    private ServiceRecord[] filterServiceRecords(Object identifier, ServiceRecord[] records) {
        ArrayList<ServiceRecord> list = new ArrayList<ServiceRecord>();
        for (int i = 0; i < records.length; ++i) {
            if (!records[i].getServiceID().equals(identifier)) continue;
            list.add(records[i]);
        }
        return list.toArray(new ServiceRecord[list.size()]);
    }
}

