/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core.provision;

import java.io.Serializable;
import java.net.URL;
import java.util.Date;

public class SoftwareDownloadRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private URL location;
    private String path;
    private String name;
    private boolean unarchived;
    private Date downloadDate;
    private int downloadedSize;
    private int extractedSize;
    private long downloadTime;
    private long unarchiveTime;

    public SoftwareDownloadRecord(URL location, String path, String name, Date downloadDate, int downloadedSize, int extractedSize, boolean unarchived, long downloadTime, long unarchiveTime) {
        if (location == null) {
            throw new NullPointerException("location is null");
        }
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.location = location;
        this.path = path;
        this.name = name;
        if (downloadDate != null) {
            this.downloadDate = new Date(downloadDate.getTime());
        }
        this.downloadedSize = downloadedSize;
        this.extractedSize = extractedSize;
        this.unarchived = unarchived;
        this.downloadTime = downloadTime;
        this.unarchiveTime = unarchiveTime;
    }

    public URL getLocation() {
        return this.location;
    }

    public int getDownloadedSize() {
        return this.downloadedSize;
    }

    public int getExtractedSize() {
        return this.extractedSize;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public boolean unarchived() {
        return this.unarchived;
    }

    public Date getDate() {
        Date d = null;
        if (this.downloadDate != null) {
            d = new Date(this.downloadDate.getTime());
        }
        return d;
    }

    public long getDownloadTime() {
        return this.downloadTime;
    }

    public long getUnarchiveTime() {
        return this.unarchiveTime;
    }

    public String toString() {
        return "Downloaded From : " + this.getLocation().toExternalForm() + "\nDownloaded To   : " + this.getPath() + "\nDownloaded File : " + this.getName() + "\nDownloaded Size : " + this.getDownloadedSize() + "\nExtracted  Size : " + this.getExtractedSize() + "\nDownload   Time : " + this.getDownloadTime() + "\nUnarchive  Time : " + this.getUnarchiveTime() + "\nDate downloaded : " + this.getDate();
    }
}

