/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core.provision;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;

public class SoftwareLoad
implements Serializable {
    static final long serialVersionUID = 1L;
    private boolean removeOnDestroy = true;
    private SoftwareDownloadAttributes softwareDownload;
    private PostInstallAttributes postInstall;

    public SoftwareLoad() {
    }

    public SoftwareLoad(SoftwareDownloadAttributes softwareDownload) {
        this.setSoftwareDownloadAttributes(softwareDownload);
    }

    public SoftwareLoad(boolean removeOnDestroy) {
        this.removeOnDestroy = removeOnDestroy;
    }

    public SoftwareLoad(SoftwareDownloadAttributes softwareDownload, boolean removeOnDestroy) {
        this(softwareDownload);
        this.removeOnDestroy = removeOnDestroy;
    }

    public boolean removeOnDestroy() {
        return this.removeOnDestroy;
    }

    public void setSoftwareDownloadAttributes(SoftwareDownloadAttributes softwareDownload) {
        if (softwareDownload == null) {
            throw new NullPointerException("softwareDownload is null");
        }
        this.softwareDownload = softwareDownload;
    }

    public SoftwareDownloadAttributes getSoftwareDownloadAttributes() {
        return this.softwareDownload;
    }

    public void setPostInstallAttributes(PostInstallAttributes postInstall) {
        if (postInstall == null) {
            throw new NullPointerException("postInstall is null");
        }
        this.postInstall = postInstall;
    }

    public PostInstallAttributes getPostInstallAttributes() {
        return this.postInstall;
    }

    public static class SoftwareDownloadAttributes
    implements Serializable {
        static final long serialVersionUID = -6064568477619251345L;
        private URL location;
        private String installRoot;
        private boolean unarchive;

        public SoftwareDownloadAttributes(URL location, String installRoot, boolean unarchive) {
            if (location == null) {
                throw new NullPointerException("location is null");
            }
            if (installRoot == null) {
                throw new NullPointerException("installRoot is null");
            }
            this.location = location;
            this.installRoot = installRoot;
            this.unarchive = unarchive;
        }

        public int getDownloadSize() throws IOException {
            return this.location.openConnection().getContentLength();
        }

        public URL getLocation() {
            return this.location;
        }

        public String getInstallRoot() {
            return this.installRoot;
        }

        public boolean unarchive() {
            return this.unarchive;
        }
    }

    public static class PostInstallAttributes
    implements Serializable {
        static final long serialVersionUID = 1L;
        private SoftwareDownloadAttributes postInstallDownload;
        private String executionTarget;
        private boolean removeOnCompletion = true;

        public PostInstallAttributes(String executionTarget, SoftwareDownloadAttributes postInstallDownload, boolean removeOnCompletion) {
            if (executionTarget == null) {
                throw new NullPointerException("executionTarget is null");
            }
            this.executionTarget = executionTarget;
            this.postInstallDownload = postInstallDownload;
            this.removeOnCompletion = removeOnCompletion;
        }

        public String getExecutionTarget() {
            return this.executionTarget;
        }

        public SoftwareDownloadAttributes getSoftwareDownloadAttributes() {
            return this.postInstallDownload;
        }

        public boolean removeOnCompletion() {
            return this.removeOnCompletion;
        }
    }
}

