/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import net.jini.export.Exporter;
import net.jini.id.UuidFactory;
import org.jini.rio.core.MeasuredResource;
import org.jini.rio.core.SLA;
import org.jini.rio.cybernode.CybernodeAdmin;
import org.jini.rio.cybernode.CybernodeAdminProxy;
import org.jini.rio.cybernode.CybernodeImpl;
import org.jini.rio.qos.capability.PlatformCapability;
import org.jini.rio.resources.persistence.SnapshotHandler;
import org.jini.rio.resources.servicecore.ServiceAdmin;
import org.jini.rio.resources.servicecore.ServiceAdminImpl;

public class CybernodeAdminImpl
extends ServiceAdminImpl
implements CybernodeAdmin {
    CybernodeImpl backend;

    public CybernodeAdminImpl(CybernodeImpl service, Exporter exporter) {
        this(service, exporter, null);
    }

    public CybernodeAdminImpl(CybernodeImpl service, Exporter exporter, SnapshotHandler snapshotHandler) {
        super(service, exporter, snapshotHandler);
        this.backend = service;
    }

    @Override
    public ServiceAdmin getServiceAdmin() throws RemoteException {
        if (this.adminProxy == null) {
            CybernodeAdmin remoteRef = (CybernodeAdmin)this.exporter.export((Remote)this);
            this.adminProxy = CybernodeAdminProxy.getInstance(remoteRef, this, UuidFactory.generate());
        }
        return this.adminProxy;
    }

    @Override
    public Integer getServiceLimit() throws RemoteException {
        return this.backend.getServiceLimit();
    }

    @Override
    public void setServiceLimit(Integer count) throws RemoteException {
        this.backend.setServiceLimit(count);
    }

    @Override
    public Integer getServiceCount() throws RemoteException {
        return this.backend.getServiceCount();
    }

    @Override
    public boolean getPersistentProvisioning() throws RemoteException {
        return this.backend.getPersistentProvisioning();
    }

    @Override
    public void setPersistentProvisioning(boolean support) throws IOException, RemoteException {
        this.backend.setPersistentProvisioning(support);
    }

    @Override
    public boolean setSLA(SLA serviceLevelAgreement) throws RemoteException {
        return this.backend.setSLA(serviceLevelAgreement);
    }

    @Override
    public SLA[] getSLAs() throws RemoteException {
        return this.backend.getSLAs();
    }

    @Override
    public PlatformCapability[] getPlatformCapabilties() throws RemoteException {
        return this.backend.getPlatformCapabilties();
    }

    @Override
    public MeasuredResource[] getMeasuredResources() throws RemoteException {
        return this.backend.getMeasuredResources();
    }

    @Override
    public double getUtilization() throws RemoteException {
        return this.backend.getUtilization();
    }
}

