/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode;

import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;
import org.jini.rio.core.MeasuredResource;
import org.jini.rio.core.SLA;
import org.jini.rio.cybernode.CybernodeAdmin;
import org.jini.rio.qos.capability.PlatformCapability;
import org.jini.rio.resources.servicecore.ServiceAdminProxy;

public class CybernodeAdminProxy
extends ServiceAdminProxy
implements CybernodeAdmin,
Serializable {
    private static final long serialVersionUID = 2L;

    static CybernodeAdminProxy getInstance(CybernodeAdmin serviceAdmin, CybernodeAdmin localAdmin, Uuid id) {
        if (serviceAdmin instanceof RemoteMethodControl) {
            return new ConstrainableCybernodeAdminProxy(serviceAdmin, localAdmin, id, null);
        }
        return new CybernodeAdminProxy(serviceAdmin, localAdmin, id);
    }

    private CybernodeAdminProxy(CybernodeAdmin serviceAdmin, CybernodeAdmin localAdmin, Uuid uuid) {
        super(serviceAdmin, localAdmin, uuid);
    }

    @Override
    public Integer getServiceLimit() throws RemoteException {
        return ((CybernodeAdmin)this.getProxy()).getServiceLimit();
    }

    @Override
    public void setServiceLimit(Integer count) throws RemoteException {
        ((CybernodeAdmin)this.getProxy()).setServiceLimit(count);
    }

    @Override
    public Integer getServiceCount() throws RemoteException {
        return ((CybernodeAdmin)this.getProxy()).getServiceCount();
    }

    @Override
    public boolean getPersistentProvisioning() throws RemoteException {
        return ((CybernodeAdmin)this.getProxy()).getPersistentProvisioning();
    }

    @Override
    public void setPersistentProvisioning(boolean support) throws IOException, RemoteException {
        ((CybernodeAdmin)this.getProxy()).setPersistentProvisioning(support);
    }

    @Override
    public boolean setSLA(SLA serviceLevelAgreement) throws RemoteException {
        return ((CybernodeAdmin)this.getProxy()).setSLA(serviceLevelAgreement);
    }

    @Override
    public SLA[] getSLAs() throws RemoteException {
        return ((CybernodeAdmin)this.getProxy()).getSLAs();
    }

    @Override
    public PlatformCapability[] getPlatformCapabilties() throws RemoteException {
        return ((CybernodeAdmin)this.getProxy()).getPlatformCapabilties();
    }

    @Override
    public MeasuredResource[] getMeasuredResources() throws RemoteException {
        return ((CybernodeAdmin)this.getProxy()).getMeasuredResources();
    }

    @Override
    public double getUtilization() throws RemoteException {
        return ((CybernodeAdmin)this.getProxy()).getUtilization();
    }

    static final class ConstrainableCybernodeAdminProxy
    extends CybernodeAdminProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 2L;
        private final MethodConstraints constraints;

        private ConstrainableCybernodeAdminProxy(CybernodeAdmin serviceAdmin, CybernodeAdmin localAdmin, Uuid id, MethodConstraints constraints) {
            super(ConstrainableCybernodeAdminProxy.constrainServer(serviceAdmin, constraints), ConstrainableCybernodeAdminProxy.constrainServer(localAdmin, constraints), id);
            this.constraints = constraints;
        }

        private static CybernodeAdmin constrainServer(CybernodeAdmin serviceAdmin, MethodConstraints constraints) {
            if (serviceAdmin == null) {
                return null;
            }
            Method[] methods = CybernodeAdmin.class.getMethods();
            Method[] methodMapping = new Method[methods.length * 2];
            for (int i = 0; i < methodMapping.length; ++i) {
                methodMapping[i] = methods[i / 2];
            }
            return (CybernodeAdmin)((RemoteMethodControl)serviceAdmin).setConstraints(ConstrainableProxyUtil.translateConstraints((MethodConstraints)constraints, (Method[])methodMapping));
        }

        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableCybernodeAdminProxy((CybernodeAdmin)this.serviceAdmin, (CybernodeAdmin)this.localAdmin, this.uuid, constraints);
        }

        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)this.serviceAdmin).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.serviceAdmin);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (!(this.serviceAdmin instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("ConstrainableCybernodeAdminProxy.readObject failure : serviceAdmin does not implement constrainable functionality");
            }
        }
    }
}

