/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode;

import com.sun.jini.config.Config;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.start.LifeCycle;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.jini.config.Configuration;
import net.jini.core.entry.Entry;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lookup.ServiceID;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.io.MarshalledInstance;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.lookup.entry.StatusType;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.JSBInstantiationException;
import org.jini.rio.core.MeasuredResource;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.SLA;
import org.jini.rio.core.Schedule;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.core.jsb.DiscardManager;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.core.jsb.ServiceBeanManager;
import org.jini.rio.core.provision.ServiceBeanInstantiator;
import org.jini.rio.core.provision.ServiceProvisionEvent;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.core.provision.ServiceStatement;
import org.jini.rio.core.provision.ServiceStatementManager;
import org.jini.rio.core.util.ExceptionUtils;
import org.jini.rio.cybernode.Cybernode;
import org.jini.rio.cybernode.CybernodeAdminImpl;
import org.jini.rio.cybernode.CybernodeImplMBean;
import org.jini.rio.cybernode.CybernodeProxy;
import org.jini.rio.cybernode.Environment;
import org.jini.rio.cybernode.JSBContainer;
import org.jini.rio.cybernode.JSBDelegate;
import org.jini.rio.cybernode.ServiceBeanContainer;
import org.jini.rio.cybernode.ServiceBeanContainerListener;
import org.jini.rio.cybernode.ServiceConsumer;
import org.jini.rio.entry.BasicStatus;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventHandler;
import org.jini.rio.jmx.JMXUtil;
import org.jini.rio.jmx.MBeanServerFactory;
import org.jini.rio.jsb.ServiceBeanActivation;
import org.jini.rio.jsb.ServiceBeanAdapter;
import org.jini.rio.jsb.ServiceElementUtil;
import org.jini.rio.qos.ComputeResource;
import org.jini.rio.qos.SLAThresholdEvent;
import org.jini.rio.qos.capability.PlatformCapability;
import org.jini.rio.qos.measurable.MeasurableCapability;
import org.jini.rio.resources.persistence.PersistentStore;
import org.jini.rio.resources.persistence.SnapshotHandler;
import org.jini.rio.resources.resource.PoolableThread;
import org.jini.rio.resources.resource.ThreadPool;
import org.jini.rio.resources.servicecore.ServiceAdmin;
import org.jini.rio.resources.util.RioManifest;
import org.jini.rio.resources.util.TimeUtil;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.ThresholdListener;
import org.jini.rio.watch.ThresholdManager;

public class CybernodeImpl
extends ServiceBeanAdapter
implements Cybernode,
ServiceBeanContainerListener,
CybernodeImplMBean {
    static final String RIO_CONFIG_COMPONENT = "org.jini.rio";
    static final String CONFIG_COMPONENT = "org.jini.rio.cybernode";
    static final String DEFAULT_EXPORTER = "defaultExporter";
    static final Logger logger = Logger.getLogger("com.gigaspaces.grid.gsc");
    static String configComponent = "org.jini.rio.cybernode";
    ServiceBeanContainer container;
    boolean serviceTerminationOnUnregister = true;
    int serviceLimit = 500;
    ServiceConsumer svcConsumer = null;
    boolean shutdownSequence = false;
    List<ServiceProvisionEvent> inProcess = Collections.synchronizedList(new ArrayList());
    static final int LOG_VERSION = 1;
    CybernodeLogHandler logHandler;
    ThreadPool thresholdTaskPool;
    boolean provisionEnabled = false;
    String provisionRoot;
    ServiceStatementManager serviceStatementManager;
    private Timer taskTimer;
    private Configuration config;
    ProxyPreparer operationalStringManagerPreparer;
    private LifeCycle lifeCycle;
    private boolean enlisted = false;
    private Schedule availabilitySchedule;
    private final List<TimerTask> schedulingTaskList = Collections.synchronizedList(new ArrayList());
    public static final String CYBERNODE_NAME_PROP = "org.jini.rio.cybernode.name";
    private static final String CYBERNODE_NAME_VAL = System.getProperty("org.jini.rio.cybernode.name");

    public CybernodeImpl() throws Exception {
    }

    public CybernodeImpl(String[] configArgs, LifeCycle lifeCycle) throws Exception {
        this.lifeCycle = lifeCycle;
        this.bootstrap(configArgs);
    }

    public CybernodeImpl(ActivationID activationID, MarshalledObject data) throws Exception {
        this.activationID = activationID;
        this.bootstrap((String[])data.get());
    }

    @Override
    public void destroy(boolean force) {
        if (this.shutdownSequence) {
            return;
        }
        this.shutdownSequence = true;
        if (this.svcConsumer != null) {
            this.svcConsumer.destroy();
        }
        this.svcConsumer = null;
        if (this.container != null) {
            this.container.terminate();
        }
        this.container = null;
        if (this.snapshotter != null) {
            this.snapshotter.interrupt();
        }
        if (this.store != null) {
            try {
                this.store.destroy();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "While destroying persistent store", e);
            }
        }
        if (this.taskTimer != null) {
            this.taskTimer.cancel();
        }
        this.unadvertise();
        this.stop(force);
        if (this.serviceStatementManager != null) {
            this.serviceStatementManager.terminate();
        }
        this.watchRegistry.closeAll();
        PlatformCapability[] pCaps = this.computeResource.getPlatformCapabilities();
        for (int i = 0; i < pCaps.length; ++i) {
            try {
                ObjectName objectName = this.getObjectName(pCaps[i]);
                MBeanServerFactory.getMBeanServer().unregisterMBean(objectName);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unregistering PlatformCapability [" + pCaps[i].getName() + "]:" + e.toString(), e);
            }
        }
        ServiceBeanManager serviceBeanManager = this.context.getServiceBeanManager();
        if (serviceBeanManager != null) {
            DiscardManager discardMgr = serviceBeanManager.getDiscardManager();
            if (discardMgr != null) {
                discardMgr.discard();
            }
        } else if (this.lifeCycle != null) {
            this.lifeCycle.unregister((Object)this);
        }
    }

    @Override
    public ServiceStatement[] getServiceStatements() {
        return this.serviceStatementManager.get();
    }

    @Override
    public ServiceRecord[] getServiceRecords(int filter) {
        ArrayList<ServiceRecord> list = new ArrayList<ServiceRecord>();
        ServiceStatement[] statements = this.serviceStatementManager.get();
        for (int i = 0; i < statements.length; ++i) {
            ServiceRecord[] records = statements[i].getServiceRecords((Object)this.serviceID, filter);
            for (int j = 0; j < records.length; ++j) {
                list.add(records[j]);
            }
        }
        return list.toArray(new ServiceRecord[list.size()]);
    }

    @Override
    public ServiceBeanInstance[] getServiceBeanInstances(ServiceElement element) {
        ServiceBeanInstance[] sbi = this.container.getServiceBeanInstances(element);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("ServiceBeanInstance count for [" + (element == null ? "null" : element.getName()) + "] = " + sbi.length);
        }
        return sbi;
    }

    @Override
    public void update(ServiceElement[] sElements, OperationalStringManager opStringMgr) throws RemoteException {
        opStringMgr = (OperationalStringManager)this.operationalStringManagerPreparer.prepareProxy((Object)opStringMgr);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Prepared OperationalStringManager proxy: {0}", opStringMgr);
        }
        this.container.update(sElements, opStringMgr);
    }

    @Override
    public String getName() throws RemoteException {
        if (CYBERNODE_NAME_VAL == null) {
            return this.context.getServiceElement().getName();
        }
        return CYBERNODE_NAME_VAL;
    }

    @Override
    public Uuid getInstantiatorUuid() throws RemoteException {
        return this.getUuid();
    }

    @Override
    public void serviceInstantiated(ServiceRecord serviceRecord) {
        ServiceStatement statement = this.serviceStatementManager.get(serviceRecord.getServiceElement());
        if (statement == null) {
            statement = new ServiceStatement(serviceRecord.getServiceElement());
        }
        statement.putServiceRecord(this.serviceID, serviceRecord);
        this.serviceStatementManager.record(statement);
        this.setChanged(StatusType.NORMAL);
    }

    @Override
    public void serviceDiscarded(ServiceRecord serviceRecord) {
        if (this.shutdownSequence) {
            return;
        }
        if (serviceRecord == null) {
            logger.log(Level.WARNING, "ServiceRecord is null when discarding ServiceBean");
        } else {
            ServiceStatement statement = this.serviceStatementManager.get(serviceRecord.getServiceElement());
            if (statement != null) {
                statement.putServiceRecord(this.serviceID, serviceRecord);
                this.serviceStatementManager.record(statement);
            } else {
                logger.log(Level.WARNING, "ServiceStatement is null when discarding ServiceBean[" + serviceRecord.getServiceElement().getName() + "]");
            }
            this.setChanged(StatusType.NORMAL);
        }
    }

    protected void bootstrap(String[] configArgs) throws Exception {
        try {
            String fdh = "com.gigaspaces.grid.gsc.GSCFaultDetectionHandler";
            Object[] fdhConfigArgs = new Object[]{new String[]{"-", "com.gigaspaces.grid.gsc.GSCFaultDetectionHandler.invocationDelay=" + System.getProperty("com.gigaspaces.grid.gsc.GSCFaultDetectionHandler.invocationDelay", "10000"), "com.gigaspaces.grid.gsc.GSCFaultDetectionHandler.retryCount=" + System.getProperty("com.gigaspaces.grid.gsc.GSCFaultDetectionHandler.retryCount", "0")}};
            ClassBundle faultDetectionHandler = new ClassBundle(fdh, null, new String[]{"setConfiguration"}, new Object[]{fdhConfigArgs});
            this.context = ServiceBeanActivation.getServiceBeanContext(CybernodeImpl.getConfigComponent(), "GSC", "Service Grid Infrastructure", "com.gigaspaces.grid:type=GSC", faultDetectionHandler, configArgs, this.getClass().getClassLoader());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Getting ServiceElement", e);
            throw e;
        }
        try {
            this.start(this.context);
            ServiceBeanActivation.LifeCycleManager lMgr = (ServiceBeanActivation.LifeCycleManager)this.context.getServiceBeanManager().getDiscardManager();
            if (lMgr != null) {
                lMgr.register(this.getServiceProxy(), this.context);
            } else {
                logger.log(Level.WARNING, "LifeCycleManager is null, unable to register");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Register to LifeCycleManager", e);
            throw e;
        }
    }

    public static String getConfigComponent() {
        return configComponent;
    }

    protected void setConfigComponent(String comp) {
        if (comp != null) {
            configComponent = comp;
        }
    }

    @Override
    protected Object createProxy() {
        return CybernodeProxy.getInstance((Cybernode)((Object)this.getExportedProxy()), this.getUuid());
    }

    @Override
    public Object getAdmin() {
        ServiceAdmin adminProxy = null;
        try {
            if (this.admin == null) {
                Exporter adminExporter = this.getAdminExporter();
                this.admin = this.contextMgr != null ? new CybernodeAdminImpl(this, adminExporter, (SnapshotHandler)this.contextMgr.getContextAttributeLogHandler()) : new CybernodeAdminImpl(this, adminExporter);
            }
            this.admin.setServiceBeanContext(this.getServiceBeanContext());
            adminProxy = this.admin.getServiceAdmin();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Getting CybernodeAdminImpl", t);
        }
        return adminProxy;
    }

    @Override
    public void initialize(ServiceBeanContext context) throws Exception {
        this.logDirName = context.getServiceElement().getServiceBeanConfig().getLogDir();
        if (this.logDirName != null) {
            this.logHandler = new CybernodeLogHandler();
            this.store = new PersistentStore(this.logDirName, this.logHandler, this.logHandler);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Cybernode: using absolute logdir path [" + this.store.getStoreLocation() + "]");
            }
            this.store.snapshot();
            super.initialize(context, this.store);
        } else {
            super.initialize(context);
        }
        this.config = context.getConfiguration();
        try {
            Exporter defaultExporter = (Exporter)this.config.getEntry(RIO_CONFIG_COMPONENT, DEFAULT_EXPORTER, Exporter.class);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "{0} has been set as the defaultExporter", new Object[]{defaultExporter});
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "The org.jini.rio.defaultExporter attribute must be set");
            throw e;
        }
        try {
            this.serviceLimit = Config.getIntEntry((Configuration)this.config, (String)CybernodeImpl.getConfigComponent(), (String)"serviceLimit", (int)500, (int)0, (int)Integer.MAX_VALUE);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception getting serviceLimit, default to 500");
        }
        this.operationalStringManagerPreparer = (ProxyPreparer)this.config.getEntry(CybernodeImpl.getConfigComponent(), "operationalStringManagerPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        String serviceSecurityPolicy = (String)this.config.getEntry(CybernodeImpl.getConfigComponent(), "serviceSecurityPolicy", String.class, null);
        if (serviceSecurityPolicy != null) {
            System.setProperty("rio.service.security.policy", serviceSecurityPolicy);
        }
        Environment.setupDefaultEnvironment();
        this.provisionEnabled = (Boolean)this.config.getEntry(CybernodeImpl.getConfigComponent(), "provisionEnabled", Boolean.class, (Object)true);
        this.provisionRoot = Environment.setupProvisionRoot(this.provisionEnabled, this.config);
        if (this.provisionEnabled && logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Software provisioning has been enabled, using provision root [" + this.provisionRoot + "]");
        }
        this.computeResource.setPersistentProvisioningRoot(this.provisionRoot);
        String nativeLibDirectories = Environment.setupNativeLibraryDirectories(this.config);
        System.setProperty("org.jini.rio.qos.native", nativeLibDirectories);
        this.initializeComputeResource(this.computeResource);
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer sb = new StringBuffer();
            sb.append("Service Limit : " + this.serviceLimit + "\n");
            sb.append("System Capabilities\n");
            MeasurableCapability[] mCaps = this.computeResource.getMeasurableCapabilities();
            sb.append("MeasurableCapabilities : (" + mCaps.length + ")\n");
            for (int i = 0; i < mCaps.length; ++i) {
                sb.append("\t" + mCaps[i].getClass().getName() + "\n");
                ThresholdValues tValues = mCaps[i].getThresholdValues();
                sb.append("\t\tlow threshold  : " + tValues.getLowThreshold() + "\n");
                sb.append("\t\thigh threshold : " + tValues.getHighThreshold() + "\n");
                sb.append("\t\treport rate    : " + mCaps[i].getPeriod() + "\n");
                sb.append("\t\tsample size    : " + mCaps[i].getSampleSize() + "\n");
            }
            PlatformCapability[] pCaps = this.computeResource.getPlatformCapabilities();
            sb.append("PlatformCapabilities : (" + pCaps.length + ")\n");
            for (int i = 0; i < pCaps.length; ++i) {
                sb.append("\t" + pCaps[i].getClass().getName() + "\n");
                Object[] keys = pCaps[i].getPlatformKeys();
                for (int j = 0; j < keys.length; ++j) {
                    sb.append("\t\t" + keys[j] + " : " + pCaps[i].getValue(keys[j]) + "\n");
                }
                String path = pCaps[i].getPath();
                if (path == null) continue;
                sb.append("\t\tPath : " + path + "\n");
            }
            logger.finest(sb.toString());
        }
        this.serviceStatementManager = Environment.getServiceStatementManager(this.config);
        long serviceRecordUpdateTaskTimer = 60L;
        try {
            serviceRecordUpdateTaskTimer = Config.getLongEntry((Configuration)this.config, (String)CybernodeImpl.getConfigComponent(), (String)"serviceRecordUpdateTaskTimer", (long)serviceRecordUpdateTaskTimer, (long)1L, (long)Long.MAX_VALUE);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Exception getting slaThresholdTaskPoolMinimum", t);
        }
        this.taskTimer = new Timer(true);
        long period = 1000L * serviceRecordUpdateTaskTimer;
        long now = System.currentTimeMillis();
        this.taskTimer.scheduleAtFixedRate((TimerTask)new ServiceRecordUpdateTask(), new Date(now + period), period);
        int slaThresholdTaskPoolMinimum = 1;
        int slaThresholdTaskPoolMaximum = this.computeResource.getMeasurableCapabilities().length;
        if (slaThresholdTaskPoolMaximum > 1) {
            try {
                slaThresholdTaskPoolMinimum = Config.getIntEntry((Configuration)this.config, (String)CybernodeImpl.getConfigComponent(), (String)"slaThresholdTaskPoolMinimum", (int)slaThresholdTaskPoolMinimum, (int)1, (int)(slaThresholdTaskPoolMaximum - 1));
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception getting slaThresholdTaskPoolMinimum", t);
            }
            try {
                slaThresholdTaskPoolMinimum = Config.getIntEntry((Configuration)this.config, (String)CybernodeImpl.getConfigComponent(), (String)"slaThresholdTaskPoolMaximum", (int)slaThresholdTaskPoolMaximum, (int)(slaThresholdTaskPoolMinimum + 1), (int)10);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception getting slaThresholdTaskPoolMaximum", t);
            }
        }
        this.thresholdTaskPool = new ThreadPool("SLAThresholdTaskPool:" + System.currentTimeMillis(), slaThresholdTaskPoolMinimum, slaThresholdTaskPoolMaximum);
        EventDescriptor thresholdEventDesc = SLAThresholdEvent.getEventDescriptor();
        this.eventTable.put(thresholdEventDesc.eventID, this.getSLAEventHandler());
        this.addAttribute((Entry)thresholdEventDesc);
        this.addAttribute((Entry)this.getServiceInfo());
        this.addAttribute((Entry)new BasicStatus(StatusType.NORMAL));
        this.createContainer();
        this.svcConsumer = new ServiceConsumer((ServiceBeanInstantiator)this.getServiceProxy(), this.computeResource, this.serviceLimit, this.config);
        this.serviceTerminationOnUnregister = (Boolean)this.config.getEntry(CybernodeImpl.getConfigComponent(), "serviceTerminationOnUnregister", Boolean.class, (Object)Boolean.TRUE);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("serviceTerminationOnUnregister=" + this.serviceTerminationOnUnregister);
        }
        this.availabilitySchedule = (Schedule)this.config.getEntry(CybernodeImpl.getConfigComponent(), "availablitySchedule", Schedule.class, (Object)new Schedule());
        this.doEnlist(this.availabilitySchedule);
        new ComputeResourcePolicyHandler(this.computeResource, this.getSLAEventHandler());
        if (this.serviceID == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating new ServiceID from UUID=" + this.getUuid().toString());
            }
            this.serviceID = new ServiceID(this.getUuid().getMostSignificantBits(), this.getUuid().getLeastSignificantBits());
        }
        if (this.store != null) {
            this.store.snapshot();
        }
    }

    @Override
    public boolean isEnlisted() {
        return this.enlisted;
    }

    protected void setEnlisted(boolean value) {
        this.enlisted = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schedule getAvailabilitySchedule() {
        Schedule sched = null;
        CybernodeImpl cybernodeImpl = this;
        synchronized (cybernodeImpl) {
            sched = this.availabilitySchedule;
        }
        return sched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAvailabilitySchedule(Schedule sched) {
        CybernodeImpl cybernodeImpl = this;
        synchronized (cybernodeImpl) {
            this.availabilitySchedule = sched;
        }
    }

    protected TimerTask[] getRegistrationTasks() {
        return this.schedulingTaskList.toArray(new TimerTask[this.schedulingTaskList.size()]);
    }

    protected void addRegistrationTask(TimerTask task) {
        if (task != null && (task instanceof RegistrationTask || task instanceof UnRegistrationTask)) {
            this.schedulingTaskList.add(task);
        }
    }

    protected void removeRegistrationTask(TimerTask task) {
        if (task != null) {
            this.schedulingTaskList.remove(task);
        }
    }

    protected void doEnlist(Schedule schedule) {
        if (this.isEnlisted()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Already enlisted");
            }
            return;
        }
        if (schedule == null) {
            throw new NullPointerException("schedule is null");
        }
        Date startDate = schedule.getStartDate();
        long now = System.currentTimeMillis();
        long delay = startDate.getTime() - now;
        boolean scheduled = false;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Avalability schedule Start Date=[" + startDate.toString() + "], Available for=[" + TimeUtil.format(schedule.getDuration()) + "], Time not available=[" + TimeUtil.format(schedule.getRepeatInterval()) + "], Time till start [" + TimeUtil.format(delay) + "]");
        }
        if (delay > 0L || schedule.getDuration() > 0L) {
            RegistrationTask registrationTask = new RegistrationTask(schedule);
            this.addRegistrationTask(registrationTask);
            if (schedule.getDuration() > 0L) {
                this.taskTimer.scheduleAtFixedRate((TimerTask)registrationTask, startDate, schedule.getDuration() + schedule.getRepeatInterval());
            } else {
                this.taskTimer.schedule((TimerTask)registrationTask, startDate);
            }
            scheduled = true;
        }
        if (!scheduled) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Configured for constant availability");
            }
            try {
                this.svcConsumer.initializeProvisionDiscovery(this.context.getDiscoveryManagement());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Initializing Provision discovery", e);
            }
        }
        this.setEnlisted(true);
    }

    protected Timer getTaskTimer() {
        return this.taskTimer;
    }

    protected ServiceInfo getServiceInfo() {
        URL implUrl = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        String build = null;
        try {
            RioManifest rioManifest = new RioManifest(implUrl);
            build = rioManifest.getRioBuild();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Getting Rio Manifest", e);
        }
        if (build == null) {
            build = "0";
        }
        return new ServiceInfo(this.context.getServiceElement().getName(), "Sun Microsystems, Inc.", "", "v3.2 Build " + build, "", "");
    }

    @Override
    public synchronized void destroy(ServiceProvisionEvent event) throws UnknownEventException, RemoteException {
        JSBDelegate[] delegates;
        if (this.shutdownSequence) {
            return;
        }
        logger.log(Level.INFO, "Destroying " + ServiceElementUtil.getNameWithId(event.getServiceElement()));
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Destroying " + event.getServiceElement());
        }
        if (event.getID() != -5934673946890420068L) {
            throw new UnknownEventException("Unknown event type [" + event.getID() + "]");
        }
        ServiceElement sElem = event.getServiceElement();
        for (JSBDelegate delegate : delegates = this.container.getDelegates(sElem)) {
            if (!sElem.getInstanceId().equals(delegate.getServiceElement().getInstanceId())) continue;
            delegate.terminate();
            this.container.discarded(delegate.getIdentifier());
            this.container.remove(delegate.getIdentifier());
            break;
        }
        logger.log(Level.INFO, "Destroyed " + ServiceElementUtil.getNameWithId(event.getServiceElement()));
    }

    @Override
    public synchronized ServiceBeanInstance instantiate(ServiceProvisionEvent event) throws JSBInstantiationException, UnknownEventException, RemoteException {
        boolean success = true;
        long time = System.currentTimeMillis();
        logger.log(Level.INFO, "Instantiating " + ServiceElementUtil.getNameWithId(event.getServiceElement()));
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Instantiating " + event.getServiceElement());
        }
        ServiceBeanInstance jsbInstance = null;
        try {
            if (this.shutdownSequence) {
                throw new JSBInstantiationException("Resource unavailable");
            }
            if (event.getID() != -5934673946890420068L) {
                throw new UnknownEventException("Unknown event type [" + event.getID() + "]");
            }
            ServiceProvisionEvent[] events = this.inProcess.toArray(new ServiceProvisionEvent[this.inProcess.size()]);
            int inProcessServiceCount = 0;
            for (int i = 0; i < events.length; ++i) {
                if (!events[i].getServiceElement().equals(event.getServiceElement())) continue;
                ++inProcessServiceCount;
            }
            int instantiatedServiceCount = 0;
            ServiceRecord[] records = this.container.getServiceRecords();
            for (int i = 0; i < records.length; ++i) {
                if (records[i].getType() != 1 || !records[i].getServiceElement().equals(event.getServiceElement())) continue;
                ++instantiatedServiceCount;
            }
            int activeServiceCounter = inProcessServiceCount + instantiatedServiceCount;
            boolean requiresIsolation = event.getServiceElement().isRequiresIsolation();
            if (requiresIsolation && events.length + records.length != 0) {
                logger.warning("Abort allocation of [" + event.getServiceElement().getName() + "] requires-isolation=[" + requiresIsolation + "]");
                throw new JSBInstantiationException("Requires isolation [" + requiresIsolation + "] has been met when trying to instantiate: " + ServiceElementUtil.getNameWithId(event.getServiceElement()));
            }
            int maxPerMachine = event.getServiceElement().getMaxPerMachine();
            if (maxPerMachine != -1 && activeServiceCounter >= maxPerMachine) {
                logger.warning("Abort allocation of [" + event.getServiceElement().getName() + "] activeServiceCounter=[" + activeServiceCounter + "] inProcessServiceCount=[" + inProcessServiceCount + "] max-instances-per-vm=[" + maxPerMachine + "]");
                throw new JSBInstantiationException("Max instances per vm [" + maxPerMachine + "] has been reached when trying to instantiate: " + ServiceElementUtil.getNameWithId(event.getServiceElement()));
            }
            int numPlannedServices = event.getServiceElement().getPlanned();
            if (activeServiceCounter >= numPlannedServices) {
                logger.warning("Number of instances on the container already meets the plan [" + event.getServiceElement().getName() + "] activeServiceCounter=[" + activeServiceCounter + "] inProcessServiceCount=[" + inProcessServiceCount + "] instantiatedServiceCount=[" + instantiatedServiceCount + "] numPlannedServices=[" + numPlannedServices + "]");
            }
            this.inProcess.add(event);
            int inProcessCount = this.inProcess.size() - this.container.getActivationInProcessCount();
            int containerServiceCount = this.container.getServiceCounter();
            if (inProcessCount + containerServiceCount <= this.serviceLimit) {
                ServiceBeanInstance serviceBeanInstance = jsbInstance = this.container.activate(event.getServiceElement(), event.getOperationalStringManager(), this.getServiceProxy(), this.getSLAEventHandler());
                return serviceBeanInstance;
            }
            try {
                throw new JSBInstantiationException("Service Limit of [" + this.serviceLimit + "] has been reached");
            }
            catch (JSBInstantiationException e) {
                logger.log(Level.SEVERE, "Failed to instantiate " + ServiceElementUtil.getNameWithId(event.getServiceElement()), e);
                success = false;
                throw new JSBInstantiationException(ExceptionUtils.getRecursiveCause(e), null, e.isUninstantiable());
            }
        }
        finally {
            if (success) {
                double instTime = System.currentTimeMillis() - time;
                String suffix = "milliseconds";
                if (instTime > 60000.0) {
                    suffix = "minutes";
                    instTime /= 60000.0;
                } else if (instTime > 1000.0) {
                    suffix = "seconds";
                    instTime /= 1000.0;
                }
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(2);
                logger.log(Level.INFO, "Instantiated " + ServiceElementUtil.getNameWithId(event.getServiceElement()) + " in " + nf.format(instTime) + " " + suffix);
            }
            this.inProcess.remove(event);
        }
    }

    void createContainer() throws Exception {
        Configuration config = this.context.getConfiguration();
        JSBContainer defaultContainer = new JSBContainer(config);
        this.container = (ServiceBeanContainer)config.getEntry(CybernodeImpl.getConfigComponent(), "serviceBeanContainer", ServiceBeanContainer.class, (Object)defaultContainer, (Object)config);
        this.container.setComputeResource(this.computeResource);
        this.container.setParentServiceID(this.serviceID);
        this.container.addListener(this);
    }

    void setChanged(StatusType statusType) {
        this.joiner.modifyAttributes(new Entry[]{new BasicStatus()}, new Entry[]{new BasicStatus(statusType)});
    }

    ComputeResource getComputeResource() {
        return this.computeResource;
    }

    void initializeComputeResource(ComputeResource computeResource) {
        computeResource.setPersistentProvisioning(this.provisionEnabled);
        computeResource.boot();
        MeasurableCapability[] mCaps = computeResource.getMeasurableCapabilities();
        mCaps = computeResource.getMeasurableCapabilities();
        for (int i = 0; i < mCaps.length; ++i) {
            this.watchRegistry.register(mCaps[i]);
        }
        PlatformCapability[] pCaps = computeResource.getPlatformCapabilities();
        for (int i = 0; i < pCaps.length; ++i) {
            try {
                ObjectName objectName = this.getObjectName(pCaps[i]);
                MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
                mbeanServer.registerMBean(pCaps[i], objectName);
                continue;
            }
            catch (MalformedObjectNameException e) {
                logger.log(Level.WARNING, "PlatformCapability [" + pCaps[i].getName() + "]:" + e.toString(), e);
                continue;
            }
            catch (NotCompliantMBeanException e) {
                logger.log(Level.WARNING, "PlatformCapability [" + pCaps[i].getName() + "]:" + e.toString(), e);
                continue;
            }
            catch (MBeanRegistrationException e) {
                logger.log(Level.WARNING, "PlatformCapability [" + pCaps[i].getName() + "]:" + e.toString(), e);
                continue;
            }
            catch (InstanceAlreadyExistsException e) {
                logger.log(Level.WARNING, "PlatformCapability [" + pCaps[i].getName() + "]:" + e.toString(), e);
            }
        }
    }

    private ObjectName getObjectName(PlatformCapability pCap) throws MalformedObjectNameException {
        return JMXUtil.getObjectName(this.context, CONFIG_COMPONENT, "PlatformCapability", pCap.getName());
    }

    public ServiceBeanContainer getContainer() {
        return this.container;
    }

    @Override
    public Integer getServiceLimit() {
        return this.serviceLimit;
    }

    @Override
    public void setServiceLimit(Integer limit) {
        this.serviceLimit = limit;
        this.svcConsumer.updateMonitors(this.computeResource.getResourceCapability(), this.serviceLimit);
    }

    @Override
    public Integer getServiceCount() {
        int serviceCounter = this.container.getServiceCounter();
        return new Integer(serviceCounter);
    }

    @Override
    public boolean getPersistentProvisioning() {
        return this.provisionEnabled;
    }

    @Override
    public void setPersistentProvisioning(boolean provisionEnabled) throws IOException {
        if (this.provisionEnabled == provisionEnabled) {
            return;
        }
        this.provisionEnabled = provisionEnabled;
        if (this.provisionEnabled) {
            Environment.setupProvisionRoot(this.provisionEnabled, this.config);
        }
        this.computeResource.setPersistentProvisioning(this.provisionEnabled);
    }

    PlatformCapability[] getPlatformCapabilties() {
        return this.computeResource.getPlatformCapabilities();
    }

    SLA[] getSLAs() {
        MeasurableCapability[] mCaps = this.computeResource.getMeasurableCapabilities();
        SLA[] serviceLevelAgreement = new SLA[mCaps.length];
        for (int i = 0; i < mCaps.length; ++i) {
            serviceLevelAgreement[i] = mCaps[i].getSLA();
        }
        return serviceLevelAgreement;
    }

    boolean setSLA(SLA serviceLevelAgreement) {
        if (serviceLevelAgreement == null) {
            throw new NullPointerException("serviceLevelAgreement is null");
        }
        String identifier = serviceLevelAgreement.getIdentifier();
        if (identifier == null) {
            throw new NullPointerException("SLA.identifier is null");
        }
        MeasurableCapability mCap = this.getMeasurableCapability(identifier);
        if (mCap == null) {
            return false;
        }
        mCap.setSLA(serviceLevelAgreement);
        return true;
    }

    MeasuredResource[] getMeasuredResources() {
        return this.computeResource.getMeasuredResources();
    }

    @Override
    public double getUtilization() {
        return this.computeResource.getUtilization();
    }

    private MeasurableCapability getMeasurableCapability(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is null");
        }
        MeasurableCapability[] mCaps = this.computeResource.getMeasurableCapabilities();
        for (int i = 0; i < mCaps.length; ++i) {
            if (!mCaps[i].getId().equals(identifier)) continue;
            return mCaps[i];
        }
        return null;
    }

    class CybernodeLogHandler
    extends LogHandler
    implements SnapshotHandler {
        CybernodeLogHandler() {
        }

        public void snapshot(OutputStream out) throws IOException {
            ObjectOutputStream oostream = new ObjectOutputStream(out);
            oostream.writeUTF(CybernodeImpl.class.getName());
            oostream.writeInt(1);
            oostream.flush();
        }

        public void recover(InputStream in) throws Exception {
            ObjectInputStream oistream = new ObjectInputStream(in);
            if (!CybernodeImpl.class.getName().equals(oistream.readUTF())) {
                throw new IOException("Log from wrong implementation");
            }
            if (oistream.readInt() != 1) {
                throw new IOException("Wrong log format version");
            }
        }

        public void applyUpdate(Object update) throws Exception {
            throw new UnsupportedOperationException("CybernodeLogHandler : Recovering log update this should not happen");
        }

        @Override
        public void updatePerformed(int updateCount) {
        }

        @Override
        public void takeSnapshot() throws IOException {
            CybernodeImpl.this.store.snapshot();
        }
    }

    static class SLAThresholdEventTask
    implements Runnable {
        SLAThresholdEvent event;
        EventHandler thresholdEventHandler;

        SLAThresholdEventTask(SLAThresholdEvent event, EventHandler thresholdEventHandler) {
            this.event = event;
            this.thresholdEventHandler = thresholdEventHandler;
        }

        @Override
        public void run() {
            try {
                this.thresholdEventHandler.fire(this.event);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Fire SLAThresholdEvent", e);
            }
        }
    }

    class ComputeResourcePolicyHandler
    implements ThresholdListener {
        ComputeResource computeResource;
        EventHandler thresholdEventHandler;

        ComputeResourcePolicyHandler(ComputeResource computeResource, EventHandler thresholdEventHandler) {
            this.computeResource = computeResource;
            this.thresholdEventHandler = thresholdEventHandler;
            computeResource.addThresholdListener(this);
        }

        @Override
        public String getID() {
            return "org.jini.rio.cybernode.ComputeResource";
        }

        @Override
        public void setThresholdManager(ThresholdManager manager) {
        }

        @Override
        public void notify(Calculable calculable, ThresholdValues thresholdValues, int type) {
            String status;
            if (CybernodeImpl.this.shutdownSequence) {
                return;
            }
            String string = status = type == 0 ? "breached" : "cleared";
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Threshold={0}, Status={1}, Value={2}, Low={3}, High={4}", new Object[]{calculable.getId(), status, new Double(calculable.getValue()), new Double(thresholdValues.getLowThreshold()), new Double(thresholdValues.getHighThreshold())});
            }
            switch (type) {
                case 0: {
                    double tValue = calculable.getValue();
                    if (!(tValue > thresholdValues.getCurrentHighThreshold())) break;
                    CybernodeImpl.this.svcConsumer.updateMonitors(this.computeResource.getResourceCapability());
                    break;
                }
                case 1: {
                    CybernodeImpl.this.svcConsumer.updateMonitors(this.computeResource.getResourceCapability());
                }
            }
            try {
                double[] range = new double[]{thresholdValues.getCurrentLowThreshold(), thresholdValues.getCurrentHighThreshold()};
                SLA sla = new SLA(calculable.getId(), range);
                String hostAddress = this.computeResource.getAddress().getHostAddress();
                String hostName = this.computeResource.getAddress().getHostName();
                ServiceBeanInstance instance = new ServiceBeanInstance(CybernodeImpl.this.getUuid(), new MarshalledInstance(CybernodeImpl.this.getServiceProxy()), CybernodeImpl.this.context.getServiceElement().getServiceBeanConfig(), hostAddress, hostName);
                SLAThresholdEvent event = new SLAThresholdEvent(CybernodeImpl.this.proxy, CybernodeImpl.this.context.getServiceElement(), instance, calculable, sla, "Cybernode Resource Policy Handler", hostAddress, type);
                PoolableThread thread = (PoolableThread)CybernodeImpl.this.thresholdTaskPool.get();
                thread.execute((Runnable)new SLAThresholdEventTask(event, this.thresholdEventHandler));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "SLA Threshold Notification", e);
            }
        }
    }

    class UnRegistrationTask
    extends TimerTask {
        boolean isLast = false;

        UnRegistrationTask() {
            this(false);
        }

        UnRegistrationTask(boolean isLast) {
            this.isLast = isLast;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Create new UnRegistrationTask");
            }
        }

        @Override
        public void run() {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Unregister from ProvisionMonitor instances ");
            }
            CybernodeImpl.this.svcConsumer.destroy();
            if (CybernodeImpl.this.serviceTerminationOnUnregister) {
                CybernodeImpl.this.container.terminateServices();
            }
            if (this.isLast) {
                CybernodeImpl.this.setEnlisted(false);
            }
            this.cancel();
        }

        @Override
        public boolean cancel() {
            CybernodeImpl.this.removeRegistrationTask(this);
            return super.cancel();
        }
    }

    class RegistrationTask
    extends TimerTask {
        int repeats;
        Schedule schedule;

        RegistrationTask(Schedule schedule) {
            this.schedule = schedule;
        }

        @Override
        public void run() {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Register to Provision Monitor instances");
            }
            try {
                CybernodeImpl.this.svcConsumer.initializeProvisionDiscovery(CybernodeImpl.this.context.getDiscoveryManagement());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Initializing ServiceConsumer", e);
            }
            ++this.repeats;
            if (this.schedule.getRepeatCount() != -1L && (long)this.repeats > this.schedule.getRepeatCount()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Repeat count [" + this.schedule.getRepeatCount() + "] reached, cancel RegistrationTask");
                }
                this.cancel();
                UnRegistrationTask unRegisterTask = new UnRegistrationTask(true);
                CybernodeImpl.this.addRegistrationTask(unRegisterTask);
                long sheduledUnRegistration = this.schedule.getDuration() + System.currentTimeMillis();
                CybernodeImpl.this.taskTimer.schedule((TimerTask)unRegisterTask, new Date(sheduledUnRegistration));
            } else if (this.schedule.getDuration() != -1L) {
                UnRegistrationTask unRegisterTask = new UnRegistrationTask();
                CybernodeImpl.this.addRegistrationTask(unRegisterTask);
                long sheduledUnRegistration = this.schedule.getDuration() + System.currentTimeMillis();
                CybernodeImpl.this.taskTimer.schedule((TimerTask)unRegisterTask, new Date(sheduledUnRegistration));
            }
        }

        @Override
        public boolean cancel() {
            CybernodeImpl.this.removeRegistrationTask(this);
            return super.cancel();
        }
    }

    class ServiceRecordUpdateTask
    extends TimerTask {
        ServiceRecordUpdateTask() {
        }

        @Override
        public void run() {
            ServiceRecord[] records = CybernodeImpl.this.container.getServiceRecords();
            for (int i = 0; i < records.length; ++i) {
                ServiceStatement statement = CybernodeImpl.this.serviceStatementManager.get(records[i].getServiceElement());
                if (statement == null) continue;
                statement.putServiceRecord(CybernodeImpl.this.serviceID, records[i]);
                CybernodeImpl.this.serviceStatementManager.record(statement);
            }
        }
    }
}

