/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode;

import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.event.UnknownEventException;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;
import org.jini.rio.core.JSBInstantiationException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.provision.ServiceProvisionEvent;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.core.provision.ServiceStatement;
import org.jini.rio.cybernode.Cybernode;
import org.jini.rio.resources.servicecore.AbstractProxy;

class CybernodeProxy
extends AbstractProxy
implements Cybernode,
Serializable {
    private static final long serialVersionUID = 2L;
    private String name;

    static CybernodeProxy getInstance(Cybernode cybernode, Uuid id) {
        if (cybernode instanceof RemoteMethodControl) {
            return new ConstrainableCybernodeProxy(cybernode, id, null);
        }
        return new CybernodeProxy(cybernode, id);
    }

    private CybernodeProxy(Cybernode cybernode, Uuid id) {
        super((Remote)((Object)cybernode), id);
    }

    @Override
    public ServiceBeanInstance instantiate(ServiceProvisionEvent event) throws JSBInstantiationException, UnknownEventException, RemoteException {
        return ((Cybernode)((Object)this.server)).instantiate(event);
    }

    @Override
    public void destroy(ServiceProvisionEvent event) throws UnknownEventException, RemoteException {
        ((Cybernode)((Object)this.server)).destroy(event);
    }

    @Override
    public ServiceStatement[] getServiceStatements() throws RemoteException {
        return ((Cybernode)((Object)this.server)).getServiceStatements();
    }

    @Override
    public ServiceRecord[] getServiceRecords(int filter) throws RemoteException {
        return ((Cybernode)((Object)this.server)).getServiceRecords(filter);
    }

    @Override
    public ServiceBeanInstance[] getServiceBeanInstances(ServiceElement element) throws RemoteException {
        return ((Cybernode)((Object)this.server)).getServiceBeanInstances(element);
    }

    @Override
    public void update(ServiceElement[] sElements, OperationalStringManager opStringMgr) throws RemoteException {
        ((Cybernode)((Object)this.server)).update(sElements, opStringMgr);
    }

    @Override
    public String getName() throws RemoteException {
        if (this.name == null) {
            this.name = ((Cybernode)((Object)this.server)).getName();
        }
        return this.name;
    }

    @Override
    public Uuid getInstantiatorUuid() throws RemoteException {
        return this.getReferentUuid();
    }

    static final class ConstrainableCybernodeProxy
    extends CybernodeProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 1L;

        private ConstrainableCybernodeProxy(Cybernode cybernode, Uuid id, MethodConstraints methodConstraints) {
            super(ConstrainableCybernodeProxy.constrainServer(cybernode, methodConstraints), id);
        }

        private static Cybernode constrainServer(Cybernode cybernode, MethodConstraints methodConstraints) {
            Method[] methods = Cybernode.class.getMethods();
            Method[] methodMapping = new Method[methods.length * 2];
            for (int i = 0; i < methodMapping.length; ++i) {
                methodMapping[i] = methods[i / 2];
            }
            return (Cybernode)((RemoteMethodControl)cybernode).setConstraints(ConstrainableProxyUtil.translateConstraints((MethodConstraints)methodConstraints, (Method[])methodMapping));
        }

        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableCybernodeProxy((Cybernode)((Object)this.server), this.uuid, constraints);
        }

        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)this.server).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.server);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (!(this.server instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("ConstrainableCybernodeProxy.readObject failure - server does not implement constrainable functionality");
            }
        }
    }
}

