/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode;

import com.gigaspaces.start.Locator;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import org.jini.rio.core.provision.ServiceStatementManager;
import org.jini.rio.cybernode.CybernodeImpl;
import org.jini.rio.cybernode.TransientServiceStatementManager;

public class Environment {
    static Logger logger = Logger.getLogger(CybernodeImpl.getConfigComponent());

    static void setupDefaultEnvironment() throws IOException {
        String rioHomeDirectory = Environment.getRioHomeDirectory();
        Environment.checkAccess(new File(rioHomeDirectory + "external"));
        Environment.checkAccess(new File(rioHomeDirectory + "native"), false);
        Environment.checkAccess(new File(rioHomeDirectory + "logs"));
        Environment.checkAccess(new File(rioHomeDirectory + "records"));
    }

    static ServiceStatementManager getServiceStatementManager(Configuration config) {
        TransientServiceStatementManager defaultServiceStatementManager = new TransientServiceStatementManager(config);
        ServiceStatementManager serviceStatementManager = null;
        try {
            serviceStatementManager = (ServiceStatementManager)config.getEntry(CybernodeImpl.getConfigComponent(), "serviceStatementManager", ServiceStatementManager.class, (Object)defaultServiceStatementManager, (Object)config);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Exception getting ServiceStatementManager", t);
            serviceStatementManager = defaultServiceStatementManager;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Using ServiceStatementManager : " + serviceStatementManager.getClass().getName());
        }
        return serviceStatementManager;
    }

    static String setupProvisionRoot(boolean provisionEnabled, Configuration config) throws IOException {
        String provisionRoot = Environment.getRioHomeDirectory() + "external";
        try {
            provisionRoot = (String)config.getEntry(CybernodeImpl.getConfigComponent(), "provisionRoot", String.class, (Object)provisionRoot);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Exception getting provisionRoot", t);
        }
        if (provisionEnabled) {
            File provisionDir = new File(provisionRoot);
            Environment.checkAccess(provisionDir);
            provisionRoot = provisionDir.getCanonicalPath();
        }
        return provisionRoot;
    }

    static String setupNativeLibraryDirectories(Configuration config) throws IOException {
        String[] nativeDirs = new String[]{Locator.getLibPlatform() + File.separator + "native"};
        try {
            nativeDirs = (String[])config.getEntry(CybernodeImpl.getConfigComponent(), "nativeLibDirectory", String[].class, (Object)nativeDirs);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Exception getting nativeLibDirectories", t);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < nativeDirs.length; ++i) {
            File nativeDirectory = new File(nativeDirs[i]);
            Environment.checkAccess(nativeDirectory, false);
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(nativeDirectory.getCanonicalPath());
        }
        return buffer.toString();
    }

    public static File setupRecordRoot(Configuration config) throws IOException {
        String recordDir = Environment.getRioHomeDirectory() + "records";
        try {
            recordDir = (String)config.getEntry(CybernodeImpl.getConfigComponent(), "recordDirectory", String.class, (Object)recordDir);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Exception getting recordDirectory", t);
        }
        File recordRoot = new File(recordDir);
        Environment.checkAccess(recordRoot);
        return recordRoot;
    }

    static String getRioHomeDirectory() {
        String rioHome = "";
        rioHome = System.getProperty("org.jini.rio.home") != null ? System.getProperty("org.jini.rio.home") : System.getProperty("user.home") + File.separator + ".rio";
        System.setProperty("org.jini.rio.home", rioHome);
        File rioPath = new File(rioHome);
        if (!rioPath.exists() && rioPath.mkdir() && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created home directory [" + rioHome + "]");
        }
        if (!rioHome.endsWith(File.separator)) {
            rioHome = rioHome + File.separator;
        }
        return rioHome;
    }

    static void checkAccess(File directory) throws IOException {
        Environment.checkAccess(directory, true);
    }

    static void checkAccess(File directory, boolean isWriteable) throws IOException {
        if (!directory.exists() && directory.mkdir() && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created directory [" + directory.getCanonicalPath() + "]");
        }
        if (!directory.canRead()) {
            throw new IOException("Cant read from : " + directory.getCanonicalPath());
        }
        if (isWriteable && !directory.canWrite()) {
            throw new IOException("Cant write to : " + directory.getCanonicalPath());
        }
    }
}

