/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.core.lookup.ServiceID;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import org.jini.rio.core.JSBInstantiationException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.cybernode.CybernodeImpl;
import org.jini.rio.cybernode.JSBDelegate;
import org.jini.rio.cybernode.ServiceBeanContainer;
import org.jini.rio.cybernode.ServiceBeanContainerListener;
import org.jini.rio.event.EventHandler;
import org.jini.rio.qos.ComputeResource;

public class JSBContainer
implements ServiceBeanContainer {
    private ServiceID parentServiceID;
    static int token = 0;
    static boolean shutdownSequence = false;
    ComputeResource computeResource;
    HashMap controllerMap = new HashMap();
    private volatile int activationInProcessCount = 0;
    List listeners = Collections.synchronizedList(new ArrayList());
    Configuration config;
    static Logger logger = CybernodeImpl.logger;

    public JSBContainer(Configuration config) {
        this.config = config;
    }

    @Override
    public Configuration getSharedConfiguration() {
        return this.config;
    }

    @Override
    public void setComputeResource(ComputeResource computeResource) {
        this.computeResource = computeResource;
    }

    @Override
    public void setParentServiceID(ServiceID serviceID) {
        this.parentServiceID = serviceID;
    }

    @Override
    public ServiceID getParentServiceID() {
        return this.parentServiceID;
    }

    @Override
    public ComputeResource getComputeResource() {
        return this.computeResource;
    }

    @Override
    public void terminate() {
        shutdownSequence = true;
        this.terminateServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateServices() {
        JSBDelegate[] delegatesX = null;
        HashMap hashMap = this.controllerMap;
        synchronized (hashMap) {
            Collection controllers = this.controllerMap.values();
            delegatesX = controllers.toArray(new JSBDelegate[controllers.size()]);
        }
        JSBDelegate[] delegates = delegatesX;
        ExecutorService es = Executors.newCachedThreadPool();
        ArrayList futures = new ArrayList();
        for (final JSBDelegate delegate : delegates) {
            futures.add(es.submit(new Runnable(){

                @Override
                public void run() {
                    delegate.terminate();
                }
            }));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception exception) {}
        }
        HashMap hashMap2 = this.controllerMap;
        synchronized (hashMap2) {
            this.controllerMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceRecord[] getServiceRecords() {
        ArrayList<ServiceRecord> list = new ArrayList<ServiceRecord>();
        JSBDelegate[] delegates = null;
        HashMap hashMap = this.controllerMap;
        synchronized (hashMap) {
            Collection controllers = this.controllerMap.values();
            delegates = controllers.toArray(new JSBDelegate[controllers.size()]);
        }
        for (int i = 0; i < delegates.length; ++i) {
            ServiceRecord record = delegates[i].getServiceRecord();
            if (record == null) continue;
            list.add(record);
        }
        return list.toArray(new ServiceRecord[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getServiceCounter() {
        int size = 0;
        HashMap hashMap = this.controllerMap;
        synchronized (hashMap) {
            size = this.controllerMap.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActivationInProcessCount() {
        HashMap hashMap = this.controllerMap;
        synchronized (hashMap) {
            return this.activationInProcessCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceBeanInstance activate(ServiceElement sElem, OperationalStringManager opStringMgr, Object slaEventSource, EventHandler slaEventHandler) throws JSBInstantiationException {
        Uuid serviceID = UuidFactory.generate();
        Integer identifier = null;
        Class<JSBContainer> clazz = JSBContainer.class;
        synchronized (JSBContainer.class) {
            identifier = new Integer(token++);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            JSBDelegate delegate = new JSBDelegate(identifier, serviceID, this.getParentServiceID(), this, sElem, opStringMgr, slaEventSource, slaEventHandler);
            HashMap hashMap = this.controllerMap;
            synchronized (hashMap) {
                this.controllerMap.put(identifier, delegate);
                ++this.activationInProcessCount;
            }
            boolean started = false;
            ServiceBeanInstance loadedInstance = null;
            try {
                loadedInstance = delegate.load();
                started = true;
                if (shutdownSequence) {
                    delegate.terminate();
                    throw new JSBInstantiationException("Resource unavailable, shutting down");
                }
                if (sElem.getAutoAdvertise()) {
                    delegate.advertise();
                }
            }
            catch (JSBInstantiationException e) {
                if (started) {
                    this.discarded(identifier);
                }
                throw e;
            }
            catch (Throwable t) {
                if (started) {
                    this.discarded(identifier);
                }
                logger.log(Level.SEVERE, "Activating ServiceBean", t);
                if (t.getCause() instanceof JSBInstantiationException) {
                    throw (JSBInstantiationException)t.getCause();
                }
                throw new JSBInstantiationException("ServiceBean [" + sElem.getName() + "] load failed", t, true);
            }
            finally {
                HashMap hashMap2 = this.controllerMap;
                synchronized (hashMap2) {
                    --this.activationInProcessCount;
                }
            }
            return loadedInstance;
        }
    }

    @Override
    public void update(ServiceElement[] sElems, OperationalStringManager opStringMgr) {
        if (sElems == null) {
            throw new NullPointerException("sElems is null");
        }
        if (opStringMgr == null) {
            throw new NullPointerException("opStringMgr is null");
        }
        for (int i = 0; i < sElems.length; ++i) {
            JSBDelegate[] delegates = this.getDelegates(sElems[i]);
            for (int j = 0; j < delegates.length; ++j) {
                delegates[j].update(sElems[i], opStringMgr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSBDelegate[] getAllDelegates() {
        HashMap hashMap = this.controllerMap;
        synchronized (hashMap) {
            Collection controllers = this.controllerMap.values();
            return controllers.toArray(new JSBDelegate[controllers.size()]);
        }
    }

    @Override
    public ServiceBeanInstance[] getServiceBeanInstances(ServiceElement element) {
        ArrayList<ServiceBeanInstance> list = new ArrayList<ServiceBeanInstance>();
        JSBDelegate[] delegates = this.getDelegates(element);
        for (int i = 0; i < delegates.length; ++i) {
            ServiceBeanInstance instance = delegates[i].getServiceBeanInstance();
            if (instance == null) continue;
            list.add(instance);
        }
        return list.toArray(new ServiceBeanInstance[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSBDelegate[] getDelegates(ServiceElement sElem) {
        JSBDelegate[] delegates = null;
        HashMap hashMap = this.controllerMap;
        synchronized (hashMap) {
            Collection controllers = this.controllerMap.values();
            delegates = controllers.toArray(new JSBDelegate[controllers.size()]);
        }
        if (sElem != null) {
            ArrayList<JSBDelegate> list = new ArrayList<JSBDelegate>();
            for (int i = 0; i < delegates.length; ++i) {
                if (!delegates[i].getServiceElement().equals(sElem)) continue;
                list.add(delegates[i]);
            }
            delegates = list.toArray(new JSBDelegate[list.size()]);
        }
        return delegates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void started(Object identifier) {
        JSBDelegate delegate = null;
        HashMap hashMap = this.controllerMap;
        synchronized (hashMap) {
            delegate = (JSBDelegate)this.controllerMap.get(identifier);
        }
        if (delegate == null) {
            return;
        }
        this.notifyOnInstantiation(delegate.getServiceRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discarded(Object identifier) {
        JSBDelegate delegate = null;
        HashMap hashMap = this.controllerMap;
        synchronized (hashMap) {
            delegate = (JSBDelegate)this.controllerMap.get(identifier);
        }
        if (delegate == null) {
            return;
        }
        this.notifyOnDiscard(delegate.getServiceRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object identifier) {
        if (shutdownSequence) {
            return;
        }
        HashMap hashMap = this.controllerMap;
        synchronized (hashMap) {
            this.controllerMap.remove(identifier);
        }
    }

    @Override
    public synchronized void addListener(ServiceBeanContainerListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public synchronized void removeListener(ServiceBeanContainerListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOnInstantiation(ServiceRecord serviceRecord) {
        Object[] arrLocal;
        JSBContainer jSBContainer = this;
        synchronized (jSBContainer) {
            arrLocal = this.listeners.toArray();
        }
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            ((ServiceBeanContainerListener)arrLocal[i]).serviceInstantiated(serviceRecord);
        }
    }

    void notifyOnDiscard(ServiceRecord serviceRecord) {
        Object[] arrLocal = this.listeners.toArray();
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            ((ServiceBeanContainerListener)arrLocal[i]).serviceDiscarded(serviceRecord);
        }
    }
}

