/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode;

import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.start.LifeCycle;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.dynamic.DynamicLookupLocatorDiscovery;
import net.jini.id.Uuid;
import org.jini.rio.core.AssociationManagement;
import org.jini.rio.core.JSBControlException;
import org.jini.rio.core.JSBInstantiationException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceLevelAgreements;
import org.jini.rio.core.jsb.DiscardManager;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.core.jsb.ServiceElementChangeListener;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.core.provision.SoftwareDownloadRecord;
import org.jini.rio.core.provision.SoftwareLoad;
import org.jini.rio.cybernode.CybernodeImpl;
import org.jini.rio.cybernode.ServiceBeanContainer;
import org.jini.rio.cybernode.ServiceBeanLoader;
import org.jini.rio.event.EventHandler;
import org.jini.rio.jmx.JMXUtil;
import org.jini.rio.jmx.MBeanServerFactory;
import org.jini.rio.jsb.JSBContext;
import org.jini.rio.jsb.JSBManager;
import org.jini.rio.jsb.ServiceBeanSLAManager;
import org.jini.rio.jsb.ServiceElementUtil;
import org.jini.rio.log.LoggerConfig;
import org.jini.rio.qos.ComputeResource;
import org.jini.rio.qos.capability.PlatformCapability;
import org.jini.rio.qos.measurable.MeasurableCapability;

public class JSBDelegate {
    private ServiceBeanInstance instance;
    private final Object identifier;
    private Uuid serviceID;
    private final ServiceID parentServiceID;
    private Object jsbProxy;
    private final ServiceBeanContainer container;
    private ServiceElement sElem;
    private final OperationalStringManager opStringMgr;
    private Throwable abortThrowable;
    private Throwable abortRootCause;
    private ServiceRecord serviceRecord;
    private boolean terminating = false;
    private boolean terminated = false;
    private final ArrayList downloadRecords = new ArrayList();
    private final Collection installedPlatformCapabilities = new ArrayList();
    private ServiceBeanContext context;
    private final EventHandler slaEventHandler;
    private final Object slaEventSource;
    private ServiceBeanSLAManager serviceBeanSLAManager;
    private ServiceElementChangeManager sElemChangeMgr;
    private static final int UTILIZATION_COLLECTOR_SIZE = 100;
    ArrayList cpuUtilizationList = new ArrayList(100);
    ArrayList memUtilizationList = new ArrayList(100);
    static Logger logger = CybernodeImpl.logger;
    protected ServiceBeanLoader.Result loadResult;

    public JSBDelegate(Object identifier, Uuid serviceID, ServiceID parentServiceID, ServiceBeanContainer container, ServiceElement sElem, OperationalStringManager opStringMgr, Object slaEventSource, EventHandler slaEventHandler) {
        this.identifier = identifier;
        this.serviceID = serviceID;
        this.parentServiceID = parentServiceID;
        this.container = container;
        this.sElem = sElem;
        this.opStringMgr = opStringMgr;
        this.slaEventSource = slaEventSource;
        this.slaEventHandler = slaEventHandler;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRecord getServiceRecord() {
        if (this.serviceRecord != null) {
            ServiceRecord serviceRecord = this.serviceRecord;
            synchronized (serviceRecord) {
                int type = this.serviceRecord.getType();
                Date instantiated = this.serviceRecord.getInstantiationDate();
                Date discarded = this.serviceRecord.getDiscardedDate();
                long duration = this.serviceRecord.computeElapsedTime();
                String hostName = this.serviceRecord.getHostName();
                String hostAddress = this.serviceRecord.getHostAddress();
                this.serviceRecord = new ServiceRecord(this.serviceID, this.sElem, hostName, hostAddress, type, instantiated);
                if (discarded != null) {
                    this.serviceRecord.setDiscardedDate(discarded);
                }
                ComputeResource computeResource = this.container.getComputeResource();
                MeasurableCapability mCap = computeResource.getMeasurableCapability("CPU");
                double cpuUtilization = this.addAverage(mCap.getUtilization(), this.cpuUtilizationList);
                this.serviceRecord.addResourceCost(mCap.calculateResourceCost(cpuUtilization, duration));
                mCap = computeResource.getMeasurableCapability("Memory");
                double memUtilization = this.addAverage(mCap.getUtilization(), this.memUtilizationList);
                this.serviceRecord.addResourceCost(mCap.calculateResourceCost(memUtilization, duration));
                SoftwareDownloadRecord[] records = this.getSoftwareDownloadRecords();
                for (int i = 0; i < records.length; ++i) {
                    int size = records[i].getDownloadedSize();
                    if (records[i].unarchived()) {
                        size += records[i].getExtractedSize();
                    }
                    if ((mCap = computeResource.getMeasurableCapability("DiskSpace")) != null) {
                        this.serviceRecord.addResourceCost(mCap.calculateResourceCost(new Integer(size).doubleValue(), duration));
                        continue;
                    }
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "DiskSpace capability not found, cannot create ResourceCost");
                }
                if (this.context != null) {
                    PlatformCapability[] pCaps = this.context.getComputeResourceManager().getMatchedPlatformCapabilities();
                    for (int i = 0; i < pCaps.length; ++i) {
                        this.serviceRecord.addResourceCost(pCaps[i].calculateResourceCost(duration, duration));
                    }
                }
            }
        }
        return this.serviceRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double addAverage(double value, ArrayList list) {
        double average = 0.0;
        ArrayList arrayList = list;
        synchronized (arrayList) {
            if (list.size() == 100) {
                list.remove(0);
            }
            list.add(new Double(value));
            double sum = 0.0;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                sum += ((Double)it.next()).doubleValue();
            }
            average = sum / (double)list.size();
        }
        return average;
    }

    ServiceElement getServiceElement() {
        return this.sElem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean update(ServiceElement newElem, OperationalStringManager opMgr) {
        if (!this.sElem.equals(newElem)) {
            return false;
        }
        if (this.terminated || this.terminating) {
            return false;
        }
        JSBDelegate jSBDelegate = this;
        synchronized (jSBDelegate) {
            if (this.jsbProxy == null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Cannot update [" + ServiceElementUtil.getNameWithId(this.sElem) + "], Proxy is null");
                }
                return false;
            }
            Long instanceID = this.sElem.getServiceBeanConfig().getInstanceID();
            if (instanceID != null) {
                this.sElem = ServiceElementUtil.prepareInstanceID(newElem, true, instanceID);
            } else {
                this.sElem = ServiceElementUtil.copyServiceElement(newElem);
                logger.log(Level.WARNING, "No instanceID for [" + this.sElem.getName() + "] to update");
            }
            if (!(this.context instanceof JSBContext)) {
                logger.warning("Cannot update [" + this.sElem.getName() + "], Unknown ServiceBeanContext type [" + this.context.getClass().getName() + "]");
                return false;
            }
            ((JSBContext)this.context).setServiceElement(this.sElem);
            if (!(this.context.getServiceBeanManager() instanceof JSBManager)) {
                logger.warning("Cannot update [" + this.sElem.getName() + "], Unknown ServiceBeanManager type [" + this.context.getServiceBeanManager().getClass().getName() + "]");
                return false;
            }
            ((JSBManager)this.context.getServiceBeanManager()).setOperationalStringManager(opMgr);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceBeanInstance load() throws JSBInstantiationException {
        if (this.instance != null) {
            return this.instance;
        }
        JSBDelegate jSBDelegate = this;
        synchronized (jSBDelegate) {
            this.startServiceBean(this.sElem, this.opStringMgr);
        }
        return this.instance;
    }

    public ServiceBeanInstance getServiceBeanInstance() {
        return this.instance;
    }

    public void advertise() throws JSBControlException {
        if (this.jsbProxy == null) {
            throw new JSBControlException("Cannot advertise [" + ServiceElementUtil.getNameWithId(this.sElem) + "], Proxy is null");
        }
        if (this.terminated || this.terminating) {
            throw new JSBControlException("advertising service while in the process of terminating");
        }
        try {
            ServiceBeanLoader.advertise(this.jsbProxy, this.context);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, ServiceElementUtil.getNameWithId(this.sElem) + ": advertised");
            }
        }
        catch (JSBControlException e) {
            logger.log(Level.WARNING, "Could not advertise " + ServiceElementUtil.getNameWithId(this.sElem) + ", continue on");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (this.terminated || this.terminating) {
            return;
        }
        this.terminating = true;
        this.cpuUtilizationList.clear();
        this.memUtilizationList.clear();
        if (this.serviceBeanSLAManager != null) {
            this.serviceBeanSLAManager.terminate();
        }
        if (this.context != null) {
            this.context.getServiceBeanManager().removeListener(this.sElemChangeMgr);
        }
        if (this.instance != null && this.jsbProxy != null) {
            try {
                if (this.jsbProxy instanceof Administrable) {
                    Administrable admin = (Administrable)this.jsbProxy;
                    Object adminObject = admin.getAdmin();
                    if (adminObject instanceof DestroyAdmin) {
                        DestroyAdmin destroyAdmin = (DestroyAdmin)adminObject;
                        logger.info("Terminating " + this.instance);
                        destroyAdmin.destroy();
                        this.jsbProxy = null;
                        this.setDiscarded();
                        this.container.discarded(this.identifier);
                        this.terminated = true;
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "No DestroyAdmin capabilities for " + this.jsbProxy.getClass().getName());
                    }
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "No Administrable capabilities for " + this.jsbProxy.getClass().getName());
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Terminating ServiceBean", t);
                this.terminating = false;
            }
        }
        Collection collection = this.installedPlatformCapabilities;
        synchronized (collection) {
            ComputeResource computeResource = this.container.getComputeResource();
            for (PlatformCapability pCap : this.installedPlatformCapabilities) {
                SoftwareLoad softwareLoad = pCap.getSoftwareLoad();
                if (!softwareLoad.removeOnDestroy()) continue;
                computeResource.removePlatformCapability(pCap, true);
                this.unregisterPlatformCapability(pCap);
            }
            this.installedPlatformCapabilities.clear();
        }
        this.container.remove(this.identifier);
    }

    public ServiceBeanLoader.Result getLoadResult() {
        return this.loadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startServiceBean(ServiceElement sElem, OperationalStringManager opStringMgr) throws JSBInstantiationException {
        ComputeResource computeResource;
        try {
            computeResource = this.container.getComputeResource();
            Collection downloads = sElem.getProvisionablePlatformCapabilities();
            if (downloads.size() > 0) {
                for (ServiceLevelAgreements.SystemRequirement sysReq : downloads) {
                    PlatformCapability pCap = JSBContext.createPlatformCapability(sysReq.getClassName(), sysReq.getClasspath(), sysReq.getAttributes());
                    this.installedPlatformCapabilities.add(pCap);
                    ComputeResource cr = computeResource;
                    SoftwareDownloadRecord[] dRecords = cr.provision(pCap, sysReq.getSoftwareLoad());
                    for (int i = 0; i < dRecords.length; ++i) {
                        ArrayList arrayList = this.downloadRecords;
                        synchronized (arrayList) {
                            this.downloadRecords.add(dRecords[i]);
                            continue;
                        }
                    }
                }
            }
            JSBDiscardManager discardManager = new JSBDiscardManager();
            this.loadResult = ServiceBeanLoader.load(sElem, this.serviceID, this.parentServiceID, discardManager, this.container.getComputeResource(), opStringMgr, this.container.getSharedConfiguration());
            this.jsbProxy = this.loadResult.proxy;
            this.serviceID = this.loadResult.serviceID;
            this.context = this.loadResult.context;
            this.registerPlatformCapabilities();
            AssociationManagement associationManagement = this.context.getAssociationManagement();
            try {
                Method setBackend = associationManagement.getClass().getMethod("setBackend", Object.class);
                setBackend.invoke((Object)associationManagement, this.loadResult.impl);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to get setBackend method from ServiceBean [" + sElem.getName() + "] impl", this.getRootCause(e));
            }
            associationManagement.setServiceBeanContainer(this.container);
            associationManagement.setServiceBeanContext(this.context);
            this.sElemChangeMgr = new ServiceElementChangeManager();
            this.context.getServiceBeanManager().addListener(this.sElemChangeMgr);
            this.instance = new ServiceBeanInstance(this.serviceID, this.loadResult.mi, this.context.getServiceBeanConfig(), this.container.getComputeResource().getAddress().getHostAddress(), this.container.getComputeResource().getAddress().getHostName());
            JSBDelegate jSBDelegate = this;
            synchronized (jSBDelegate) {
                this.serviceRecord = new ServiceRecord(this.serviceID, sElem, computeResource.getAddress().getHostName(), computeResource.getAddress().getHostAddress());
            }
            this.serviceBeanSLAManager = new ServiceBeanSLAManager(this.loadResult.impl, this.jsbProxy, this.context, this.slaEventHandler);
            this.serviceBeanSLAManager.addSLAs(sElem.getServiceLevelAgreements().getServiceSLAs());
            this.serviceBeanSLAManager.createSLAThresholdEventAdapter();
            this.container.started(this.identifier);
        }
        catch (Throwable t) {
            StringBuffer buff = new StringBuffer();
            if (sElem.getComponentBundle() != null) {
                String[] jars = sElem.getComponentBundle().getJARNames();
                for (int i = 0; i < jars.length; ++i) {
                    if (i > 0) {
                        buff.append(", ");
                    }
                    buff.append(sElem.getComponentBundle().getCodebase() + jars[i]);
                }
            } else {
                buff.append("<unknown>");
            }
            this.abortThrowable = t;
            this.abortRootCause = this.getRootCause(t);
            logger.log(Level.FINER, "Failed to load the ServiceBean [" + ServiceElementUtil.getNameWithId(sElem) + "] classpath [" + buff.toString() + "]", this.abortRootCause);
            this.container.remove(this.identifier);
        }
        if (this.abortRootCause != null) {
            if (this.installedPlatformCapabilities.size() > 0) {
                logger.log(Level.WARNING, "Removing software loads provisioned for ServiceBean {0}", sElem.getName());
                computeResource = this.container.getComputeResource();
                for (PlatformCapability pCap : this.installedPlatformCapabilities) {
                    computeResource.removePlatformCapability(pCap, true);
                }
            }
            boolean unInstantiable = true;
            if (this.abortThrowable instanceof JSBInstantiationException) {
                unInstantiable = ((JSBInstantiationException)this.abortThrowable).isUninstantiable();
            }
            throw new JSBInstantiationException("Processing Unit [" + ServiceElementUtil.getNameWithId(sElem) + "] instantiation failed. " + (unInstantiable ? "Service is un-instantiable" : ""), this.abortRootCause, unInstantiable);
        }
    }

    private void registerPlatformCapabilities() {
        for (PlatformCapability pCap : this.installedPlatformCapabilities) {
            try {
                ObjectName objectName = JMXUtil.getObjectName(this.context, "", "PlatformCapability", pCap.getName());
                MBeanServerFactory.getMBeanServer().registerMBean(pCap, objectName);
            }
            catch (Exception e) {
                Throwable cause = e;
                if (e.getCause() != null) {
                    cause = e.getCause();
                }
                logger.log(Level.WARNING, "Registering PlatformCapability [" + pCap.getName() + "] to JMX", cause);
            }
        }
    }

    private void unregisterPlatformCapability(PlatformCapability pCap) {
        try {
            ObjectName objectName = JMXUtil.getObjectName(this.context, "", "PlatformCapability", pCap.getName());
            MBeanServerFactory.getMBeanServer().unregisterMBean(objectName);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unregistering PlatformCapability [" + pCap.getName() + "]:" + e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SoftwareDownloadRecord[] getSoftwareDownloadRecords() {
        SoftwareDownloadRecord[] records = null;
        ArrayList arrayList = this.downloadRecords;
        synchronized (arrayList) {
            records = this.downloadRecords.toArray(new SoftwareDownloadRecord[this.downloadRecords.size()]);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDiscarded() {
        if (this.serviceRecord == null) {
            logger.warning("Discarding [" + ServiceElementUtil.getNameWithId(this.sElem) + "] service, has no ServiceRecord");
            return;
        }
        ServiceRecord serviceRecord = this.serviceRecord;
        synchronized (serviceRecord) {
            this.serviceRecord.setDiscardedDate(new Date());
            this.serviceRecord.setType(2);
        }
    }

    private Throwable getRootCause(Throwable e) {
        Throwable cause;
        Throwable t = cause = e;
        while (t != null) {
            t = cause.getCause();
            if (t == null) continue;
            cause = t;
        }
        return cause;
    }

    public class JSBDiscardManager
    implements DiscardManager,
    LifeCycle {
        @Override
        public void discard() {
            if (JSBDelegate.this.terminated) {
                return;
            }
            JSBDelegate.this.setDiscarded();
            JSBDelegate.this.container.discarded(JSBDelegate.this.identifier);
            JSBDelegate.this.instance = null;
            JSBDelegate.this.terminate();
        }

        public boolean unregister(Object impl) {
            if (JSBDelegate.this.terminated) {
                return true;
            }
            JSBDelegate.this.setDiscarded();
            JSBDelegate.this.container.discarded(JSBDelegate.this.identifier);
            JSBDelegate.this.instance = null;
            JSBDelegate.this.terminate();
            return true;
        }
    }

    class ServiceElementChangeManager
    implements ServiceElementChangeListener {
        ServiceElementChangeManager() {
        }

        @Override
        public void changed(ServiceElement preElem, ServiceElement postElem) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[" + JSBDelegate.this.context.getServiceElement().getName() + "] ServiceElementChangeManager notified");
            }
            ServiceLevelAgreements slas = postElem.getServiceLevelAgreements();
            JSBDelegate.this.serviceBeanSLAManager.updateSLAs(slas.getServiceSLAs());
            if (ServiceElementUtil.hasDifferentLoggerConfig(preElem, postElem)) {
                Map map = postElem.getServiceBeanConfig().getConfigurationParamaters();
                LoggerConfig[] newLoggerConfigs = (LoggerConfig[])map.get("loggerConfig");
                map = preElem.getServiceBeanConfig().getConfigurationParamaters();
                LoggerConfig[] currentLoggerConfigs = (LoggerConfig[])map.get("loggerConfig");
                for (int i = 0; i < newLoggerConfigs.length; ++i) {
                    if (LoggerConfig.isNewLogger(newLoggerConfigs[i], currentLoggerConfigs)) {
                        newLoggerConfigs[i].getLogger();
                        continue;
                    }
                    if (!LoggerConfig.levelChanged(newLoggerConfigs[i], currentLoggerConfigs)) continue;
                    Logger.getLogger(newLoggerConfigs[i].getLoggerName()).setLevel(newLoggerConfigs[i].getLoggerLevel());
                }
            }
            if (ServiceElementUtil.hasDifferentGroups(preElem, postElem) || ServiceElementUtil.hasDifferentLocators(preElem, postElem)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("[" + JSBDelegate.this.context.getServiceElement().getName() + "] Discovery has changed");
                }
                if (JSBDelegate.this.jsbProxy instanceof Administrable) {
                    try {
                        Administrable admin = (Administrable)JSBDelegate.this.jsbProxy;
                        Object adminObject = admin.getAdmin();
                        if (adminObject instanceof JoinAdmin) {
                            JoinAdmin joinAdmin = (JoinAdmin)adminObject;
                            if (ServiceElementUtil.hasDifferentGroups(preElem, postElem)) {
                                joinAdmin.setLookupGroups(postElem.getServiceBeanConfig().getGroups());
                            }
                            if (!DynamicLookupLocatorDiscovery.dynamicLocatorsEnabled()) {
                                if (ServiceElementUtil.hasDifferentLocators(preElem, postElem)) {
                                    joinAdmin.setLookupLocators(postElem.getServiceBeanConfig().getLocators());
                                }
                            } else if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Skipping lookup locators update due to dynamic locatorsenabled");
                            }
                        } else if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "No JoinAdmin capabilities for " + JSBDelegate.this.context.getServiceElement().getName());
                        }
                    }
                    catch (RemoteException e) {
                        logger.log(Level.SEVERE, "Modifying Discovery attributes", e);
                    }
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "No Administrable capabilities for " + JSBDelegate.this.jsbProxy.getClass().getName());
                }
            }
        }
    }
}

