/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode;

import com.gigaspaces.internal.io.BootIOUtils;
import com.sun.jini.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.provision.ServiceStatement;
import org.jini.rio.core.provision.ServiceStatementManager;
import org.jini.rio.cybernode.CybernodeImpl;
import org.jini.rio.cybernode.Environment;

public class PersistentServiceStatementManager
implements ServiceStatementManager {
    File recordRoot;
    static final String STATEMENT_EXT = ".stmt";
    static final long SECOND = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final long ETERNITY = 0L;
    long clean = 2592000000L;
    Timer taskTimer;
    Object rwSemaphore = new Object();
    static Logger logger = Logger.getLogger(CybernodeImpl.getConfigComponent());

    public PersistentServiceStatementManager(Configuration config) {
        try {
            this.recordRoot = Environment.setupRecordRoot(config);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Storing service statements in [" + this.recordRoot.getCanonicalPath() + "]");
            }
            long age = this.clean;
            try {
                age = Config.getLongEntry((Configuration)config, (String)CybernodeImpl.getConfigComponent(), (String)"recordAge", (long)30L, (long)0L, (long)Long.MAX_VALUE);
                age *= 86400000L;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "PersistentServiceStatementManager : exception getting recordAge", t);
            }
            if (age != 0L) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "ServiceStatement maximum age [" + age / 86400000L + " days]");
                }
                this.taskTimer = new Timer(true);
                long now = System.currentTimeMillis();
                this.taskTimer.scheduleAtFixedRate((TimerTask)new FileSweeper(age), new Date(now + 1000L), 3600000L);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ServiceStatements live forever");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void terminate() {
        if (this.taskTimer != null) {
            this.taskTimer.cancel();
        }
    }

    @Override
    public ServiceStatement[] get() {
        ArrayList<ServiceStatement> list = new ArrayList<ServiceStatement>();
        File[] statements = BootIOUtils.listFiles((File)this.recordRoot);
        for (int i = 0; i < statements.length; ++i) {
            try {
                ServiceStatement statement = this.read(statements[i]);
                if (statement == null) continue;
                list.add(statement);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Getting ServiceStatement instances", e);
            }
        }
        return list.toArray(new ServiceStatement[list.size()]);
    }

    @Override
    public ServiceStatement get(ServiceElement sElem) {
        ServiceStatement statement = null;
        try {
            statement = this.read(this.makeName(sElem) + STATEMENT_EXT);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Getting ServiceStatement", e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Getting ServiceStatement", e);
        }
        return statement;
    }

    @Override
    public void record(ServiceStatement statement) {
        try {
            this.write(statement);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Writing ServiceStatement", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(ServiceStatement statement) throws IOException {
        Object object = this.rwSemaphore;
        synchronized (object) {
            File record = new File(this.recordRoot, this.makeName(statement.getServiceElement()) + STATEMENT_EXT);
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(record));
            oos.writeObject(statement);
            oos.flush();
        }
    }

    ServiceStatement read(String fileName) throws ClassNotFoundException, IOException {
        File file = new File(this.recordRoot, fileName);
        if (file.exists()) {
            return this.read(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceStatement read(File input) throws ClassNotFoundException, IOException {
        Object object = this.rwSemaphore;
        synchronized (object) {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(input));
            return (ServiceStatement)ois.readObject();
        }
    }

    String makeName(ServiceElement sElem) {
        return sElem.getOperationalStringName() + "." + sElem.getName();
    }

    class FileSweeper
    extends TimerTask {
        long oldAge;

        FileSweeper(long oldAge) {
            this.oldAge = oldAge;
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            File[] files = BootIOUtils.listFiles((File)PersistentServiceStatementManager.this.recordRoot);
            for (int i = 0; i < files.length; ++i) {
                long lastModified;
                long age;
                if (!files[i].getName().endsWith(PersistentServiceStatementManager.STATEMENT_EXT) || (age = now - (lastModified = files[i].lastModified())) <= this.oldAge) continue;
                files[i].delete();
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.INFO, "ServiceStatement [" + files[i].getName() + "] has aged past [" + this.oldAge / 86400000L + " days], file has been removed");
            }
        }
    }
}

