/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode;

import com.gigaspaces.start.ClassLoaderType;
import com.gigaspaces.start.ClasspathBuilder;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.start.XapModules;
import com.sun.jini.config.Config;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.LookupGroups;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.io.MarshalledInstance;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.jini.rio.boot.ClassAnnotator;
import org.jini.rio.boot.CommonClassLoader;
import org.jini.rio.boot.ServiceClassLoader;
import org.jini.rio.boot.SharedServiceData;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.JSBControlException;
import org.jini.rio.core.JSBInstantiationException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanControl;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.jsb.DiscardManager;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.core.jsb.ServiceBeanContextFactory;
import org.jini.rio.core.jsb.ServiceBeanFactory;
import org.jini.rio.cybernode.JSBContextFactory;
import org.jini.rio.jsb.JSBLoader;
import org.jini.rio.jsb.JSBManager;
import org.jini.rio.jsb.ServiceElementUtil;
import org.jini.rio.log.LoggerConfig;

public class ServiceBeanLoader {
    static final String COMPONENT = "org.jini.rio.cybernode";
    static final String CONFIG_COMPONENT = "service.load";
    static Logger logger = Logger.getLogger("org.jini.rio.cybernode");

    public static Result load(ServiceElement sElem, Uuid serviceID, ServiceID parentServiceID, DiscardManager discardManager, Object computeResource, OperationalStringManager opStringMgr, Configuration sharedConfiguration) throws JSBInstantiationException {
        ServiceBeanContext context;
        Object proxy = null;
        MarshalledInstance mi = null;
        Object impl = null;
        CommonClassLoader commonCL = CommonClassLoader.getInstance();
        if (sElem.getComponentBundle() != null) {
            Map sharedResources = null;
            try {
                sharedResources = sElem.getComponentBundle().getSharedComponents();
            }
            catch (MalformedURLException e) {
                throw new JSBInstantiationException("Unable to load SharedComponents for [" + sElem.getName() + "]", e);
            }
            if (sharedResources.size() > 0) {
                for (Map.Entry e : sharedResources.entrySet()) {
                    String name = (String)e.getKey();
                    URL[] urls = (URL[])e.getValue();
                    if (urls == null) continue;
                    commonCL.addComponent(name, urls);
                }
            }
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        try {
            Object adminObject;
            String jeeContainer = (String)sElem.getServiceBeanConfig().getInitParameters().get("jee.container");
            SharedServiceData.getJeeClassLoader((String)jeeContainer, (String[])new String[0]);
            ClassBundle jsbBundle = sElem.getComponentBundle();
            URL[] implJARs = jsbBundle == null ? new URL[]{} : jsbBundle.getJARs();
            Map attributes = sElem.getServiceBeanConfig().getConfigurationParamaters();
            ClassAnnotator annotator = ServiceBeanLoader.getClassAnnotator(sElem.getExportURLs(), attributes, sharedConfiguration, currentClassLoader);
            ServiceClassLoader jsbCL = new ServiceClassLoader(ServiceElementUtil.getNameWithId(sElem), implJARs, annotator, (ClassLoader)commonCL);
            jsbCL.addURLs(ServiceBeanLoader.createServiceClassLoaderClassPath());
            currentThread.setContextClassLoader((ClassLoader)jsbCL);
            if (logger.isLoggable(Level.FINEST)) {
                StringBuffer buffer = new StringBuffer();
                if (implJARs.length == 0) {
                    buffer.append("<empty>");
                } else {
                    for (int i = 0; i < implJARs.length; ++i) {
                        if (i > 0) {
                            buffer.append(", ");
                        }
                        buffer.append(implJARs[i].toExternalForm());
                    }
                }
                String className = jsbBundle == null ? "<not defined>" : jsbBundle.getClassName();
                logger.log(Level.FINEST, "Create ServiceClassLoader for {0}, classpath {1}, codebase {2}", new Object[]{className, buffer.toString(), jsbCL.getClassAnnotation()});
            }
            JSBManager jsbManager = new JSBManager(sElem, computeResource);
            jsbManager.setOperationalStringManager(opStringMgr);
            jsbManager.setDiscardManager(discardManager);
            jsbManager.setServiceID(serviceID);
            ServiceBeanContextFactory serviceBeanContextFactory = (ServiceBeanContextFactory)Config.getNonNullEntry((Configuration)sharedConfiguration, (String)CONFIG_COMPONENT, (String)"serviceBeanContextFactory", ServiceBeanContextFactory.class, (Object)new JSBContextFactory());
            context = serviceBeanContextFactory.create(sElem, parentServiceID, jsbManager, computeResource, sharedConfiguration);
            Map map = context.getServiceBeanConfig().getConfigurationParamaters();
            LoggerConfig[] loggerConfigs = (LoggerConfig[])map.get("loggerConfig");
            if (loggerConfigs != null) {
                for (int i = 0; i < loggerConfigs.length; ++i) {
                    try {
                        loggerConfigs[i].getLogger();
                        continue;
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "Loading LoggerConfig", t);
                    }
                }
            }
            ServiceBeanFactory serviceBeanFactory = (ServiceBeanFactory)Config.getNonNullEntry((Configuration)context.getConfiguration(), (String)CONFIG_COMPONENT, (String)"serviceBeanFactory", ServiceBeanFactory.class, (Object)new JSBLoader());
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "service = {0}serviceBeanFactory = {1}", new Object[]{sElem.getName(), serviceBeanFactory});
            }
            ServiceBeanFactory.Created created = serviceBeanFactory.create(context);
            impl = created.impl;
            if (context.getServiceElement().getComponentBundle() == null) {
                String compName = impl.getClass().getName();
                if (compName.indexOf(".") > 0) {
                    int index = compName.lastIndexOf(".");
                    compName = compName.substring(0, index);
                }
                context.getServiceBeanConfig().addInitParameter("org.jini.rio.boot.configComponent", compName);
            }
            ProxyPreparer servicePreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)context.getConfiguration(), (String)CONFIG_COMPONENT, (String)"servicePreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            proxy = created.proxy;
            if (proxy != null) {
                proxy = servicePreparer.prepareProxy(proxy);
            }
            mi = new MarshalledInstance(proxy);
            ((JSBManager)context.getServiceBeanManager()).setMarshalledInstance(mi);
            if (proxy instanceof ReferentUuid) {
                serviceID = ((ReferentUuid)proxy).getReferentUuid();
                ((JSBManager)context.getServiceBeanManager()).setServiceID(serviceID);
            }
            if (proxy instanceof Administrable && (adminObject = ((Administrable)proxy).getAdmin()) instanceof ServiceBeanControl) {
                context.getAssociationManagement().setServiceBeanControl((ServiceBeanControl)adminObject);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Proxy =  {0}", proxy);
            }
        }
        catch (Throwable t) {
            JSBInstantiationException e = null;
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Loading ServiceBean", t);
            }
            e = t instanceof JSBInstantiationException ? (JSBInstantiationException)t : new JSBInstantiationException(t.getClass().getName() + ": " + t.getLocalizedMessage(), t);
            throw e;
        }
        finally {
            currentThread.setContextClassLoader(currentClassLoader);
        }
        return new Result(context, impl, proxy, mi, serviceID);
    }

    private static List<URL> createServiceClassLoaderClassPath() throws MalformedURLException {
        FileFilter requiredCommonFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !XapModules.isRequiredCommonOrBoot((String)pathname.getName().toLowerCase());
            }
        };
        ClasspathBuilder classpathBuilder = new ClasspathBuilder().append(SystemInfo.singleton().locations().getLibRequired(), requiredCommonFilter).appendOptional("cxx/CxxPu.jar").appendOptional("mule").appendOptional("spring");
        for (XapModules xapModule : XapModules.getByClassLoaderType((ClassLoaderType)ClassLoaderType.SERVICE)) {
            classpathBuilder.append(SystemInfo.singleton().locations().lib() + xapModule.getJarFilePath());
        }
        return classpathBuilder.toURLs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void advertise(Object jsbProxy, ServiceBeanContext context) throws JSBControlException {
        if (jsbProxy == null) {
            throw new NullPointerException("jsbProxy is null");
        }
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Entry[] configuredAttrs = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        try {
            ClassLoader jsbCL = jsbProxy.getClass().getClassLoader();
            currentThread.setContextClassLoader(jsbCL);
            configuredAttrs = ServiceBeanLoader.getConfiguredAttributes(context);
        }
        finally {
            currentThread.setContextClassLoader(currentClassLoader);
        }
        ServiceBeanLoader.advertise(jsbProxy, context.getServiceElement().getName(), context.getServiceElement().getOperationalStringName(), context.getServiceElement().getServiceBeanConfig().getGroups(), context.getServiceElement().getServiceBeanConfig().getLocators(), configuredAttrs);
    }

    public static void advertise(Object jsbProxy, String serviceName, String opStringName, String[] groups, LookupLocator[] locators, Entry[] attrs) throws JSBControlException {
        block39: {
            if (jsbProxy == null) {
                throw new NullPointerException("instance is null");
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader currentClassLoader = currentThread.getContextClassLoader();
            try {
                ClassLoader jsbCL = jsbProxy.getClass().getClassLoader();
                currentThread.setContextClassLoader(jsbCL);
                if (jsbProxy instanceof Administrable) {
                    int i;
                    Entry[] attributes;
                    ArrayList<Object> addList;
                    JoinAdmin joinAdmin;
                    block40: {
                        Administrable admin = (Administrable)jsbProxy;
                        Object adminObject = admin.getAdmin();
                        if (adminObject instanceof ServiceBeanControl) {
                            ServiceBeanControl controller = (ServiceBeanControl)adminObject;
                            controller.advertise();
                            if (attrs.length > 0) {
                                JoinAdmin joinAdmin2 = (JoinAdmin)adminObject;
                                ServiceBeanLoader.addAttributes(attrs, joinAdmin2);
                            }
                            break block39;
                        }
                        if (!(adminObject instanceof JoinAdmin)) break block39;
                        joinAdmin = (JoinAdmin)adminObject;
                        addList = new ArrayList<Object>();
                        if (opStringName != null && opStringName.length() > 0) {
                            try {
                                boolean add = true;
                                Class<?> opStringEntryClass = jsbCL.loadClass("org.jini.rio.entry.OperationalStringEntry");
                                Constructor<?> cons = opStringEntryClass.getConstructor(String.class);
                                Object opStringEntry = cons.newInstance(opStringName);
                                attributes = joinAdmin.getLookupAttributes();
                                for (i = 0; i < attributes.length; ++i) {
                                    if (!attributes[i].getClass().getName().equals(opStringEntryClass.getName())) continue;
                                    add = false;
                                    break;
                                }
                                if (add) {
                                    addList.add(opStringEntry);
                                }
                            }
                            catch (Exception e) {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.log(Level.FINEST, "OperationalStringEntry not found, cannot add an OperationalStringEntry", e);
                                    break block40;
                                }
                                logger.warning("OperationalStringEntry not found, cannot add an OperationalStringEntry");
                            }
                        } else if (logger.isLoggable(Level.FINEST)) {
                            String s = opStringName == null ? "[null]" : "[empty string]";
                            logger.finest("OperationalString name is " + s);
                        }
                    }
                    try {
                        Class<?> nameClass = jsbCL.loadClass("net.jini.lookup.entry.Name");
                        Constructor<?> cons = nameClass.getConstructor(String.class);
                        Object name = cons.newInstance(serviceName);
                        boolean add = true;
                        attributes = joinAdmin.getLookupAttributes();
                        for (i = 0; i < attributes.length; ++i) {
                            if (!attributes[i].getClass().getName().equals(nameClass.getName())) continue;
                            Field n = attributes[i].getClass().getDeclaredField("name");
                            String value = (String)n.get(attributes[i]);
                            if (!value.equals(serviceName)) break;
                            add = false;
                            break;
                        }
                        if (add) {
                            addList.add(name);
                        }
                    }
                    catch (Exception e) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "Name not found, cannot add a Name Entry", e);
                        }
                        logger.warning("Name not found, cannot add a Name Entry");
                    }
                    for (int i2 = 0; i2 < attrs.length; ++i2) {
                        addList.add(attrs[i2]);
                    }
                    if (addList.size() > 0) {
                        Entry[] adds = addList.toArray(new Entry[addList.size()]);
                        ServiceBeanLoader.addAttributes(adds, joinAdmin);
                    }
                    if (groups == null || groups.length == 0) {
                        groups = LookupGroups.none();
                    }
                    if (groups != null && groups.length > 0) {
                        if (groups.length == 1 && groups[0].equals("all")) {
                            groups = LookupGroups.all();
                        } else {
                            for (int i3 = 0; i3 < groups.length; ++i3) {
                                if (!groups[i3].equals("public")) continue;
                                groups[i3] = "";
                            }
                        }
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        StringBuffer buff = new StringBuffer();
                        if (groups == null || groups.length == 0) {
                            buff.append("LookupDiscovery.NO_GROUPS");
                        } else {
                            for (int i4 = 0; i4 < groups.length; ++i4) {
                                if (i4 > 0) {
                                    buff.append(",");
                                }
                                buff.append(groups[i4]);
                            }
                        }
                        logger.finest("Setting groups [" + buff.toString() + "] using JoinAdmin.setLookupGroups");
                    }
                    joinAdmin.setLookupGroups(groups);
                    if (locators != null && locators.length > 0) {
                        if (logger.isLoggable(Level.FINEST)) {
                            StringBuffer buff = new StringBuffer();
                            for (int i5 = 0; i5 < locators.length; ++i5) {
                                if (i5 > 0) {
                                    buff.append(",");
                                }
                                buff.append(locators[i5].toString());
                            }
                            logger.finest("Setting locators [" + buff.toString() + "] using JoinAdmin.setLookupLocators");
                        }
                        joinAdmin.setLookupLocators(locators);
                    }
                    break block39;
                }
                throw new JSBControlException("Unable to obtain mechanism to advertise [" + serviceName + "]");
            }
            catch (JSBControlException e) {
                throw e;
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Advertising ServiceBean", t);
                throw new JSBControlException("advertise", t);
            }
            finally {
                currentThread.setContextClassLoader(currentClassLoader);
            }
        }
    }

    public static Entry[] getConfiguredAttributes(ServiceBeanContext context) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        ArrayList<Entry> attrList = new ArrayList<Entry>();
        String serviceBeanComponent = null;
        String className = null;
        if (context.getServiceElement().getComponentBundle() == null) {
            serviceBeanComponent = (String)context.getInitParameter("org.jini.rio.boot.configComponent");
        } else {
            if (context.getServiceElement().getComponentBundle() != null) {
                className = context.getServiceElement().getComponentBundle().getClassName();
            }
            if (className == null) {
                className = context.getServiceElement().getExportBundles()[0].getClassName();
            }
            if (className.indexOf(".") > 0) {
                int index = className.lastIndexOf(".");
                serviceBeanComponent = className.substring(0, index);
            } else {
                serviceBeanComponent = className;
            }
        }
        if (serviceBeanComponent != null) {
            int i;
            try {
                Entry[] serviceUIs = (Entry[])context.getConfiguration().getEntry(serviceBeanComponent, "serviceUIs", Entry[].class, (Object)new Entry[0], (Object)context.getExportCodebase());
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Obtained [" + serviceUIs.length + "] serviceUI declarations for [" + context.getServiceElement().getName() + "] using component [" + serviceBeanComponent + "]");
                }
                for (i = 0; i < serviceUIs.length; ++i) {
                    attrList.add(serviceUIs[i]);
                }
            }
            catch (ConfigurationException e) {
                logger.log(Level.WARNING, "Getting ServiceUIs", e);
            }
            try {
                Entry[] initialAttributes = (Entry[])context.getConfiguration().getEntry(serviceBeanComponent, "initialAttributes", Entry[].class, (Object)new Entry[0]);
                for (i = 0; i < initialAttributes.length; ++i) {
                    attrList.add(initialAttributes[i]);
                }
            }
            catch (ConfigurationException e) {
                logger.log(Level.WARNING, "Getting initialAttributes", e);
            }
        }
        return attrList.toArray(new Entry[attrList.size()]);
    }

    public static ClassAnnotator getClassAnnotator(URL[] urls, Map attributes, Configuration config, ClassLoader loader) throws ConfigurationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        String classAnnotator = (String)config.getEntry(CONFIG_COMPONENT, "classAnnotator", String.class, (Object)"com.gigaspaces.grid.gsc.AdaptiveClassAnnotator");
        Class<?> annotatorClass = loader.loadClass(classAnnotator);
        Constructor<?> annotatorCons = annotatorClass.getConstructor(URL[].class, Properties.class);
        Properties p = new Properties();
        for (Map.Entry mapEntry : attributes.entrySet()) {
            Object key = mapEntry.getKey();
            Object value = mapEntry.getValue();
            if (value == null) continue;
            p.put(key, value);
        }
        ClassAnnotator annotator = (ClassAnnotator)annotatorCons.newInstance(urls, p);
        return annotator;
    }

    static void addAttributes(Entry[] attrs, JoinAdmin joinAdmin) {
        try {
            joinAdmin.addLookupAttributes(attrs);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Unable to add Entry attributes", e);
            } else {
                logger.warning("Unable to add Entry attributes");
            }
            e.printStackTrace();
        }
    }

    public static class Result {
        public final Object impl;
        public final MarshalledInstance mi;
        public final ServiceBeanContext context;
        public final Uuid serviceID;
        public final Object proxy;

        public Result(ServiceBeanContext c, Object o, Object proxy, MarshalledInstance m, Uuid s) {
            this.context = c;
            this.impl = o;
            this.proxy = proxy;
            this.mi = m;
            this.serviceID = s;
        }
    }
}

