/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode;

import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.security.gsc.SecuredGSCProxy;
import com.gigaspaces.grid.security.gsm.SecuredGSMProxy;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.jini.SharedLeaseRenewalManager;
import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.event.EventRegistration;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.lookup.BackwardsServiceDiscoveryManager;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.jini.rio.core.provision.ProvisionManager;
import org.jini.rio.core.provision.ServiceBeanInstantiator;
import org.jini.rio.cybernode.CybernodeImpl;
import org.jini.rio.monitor.ProvisionMonitor;
import org.jini.rio.qos.ComputeResource;
import org.jini.rio.qos.ResourceCapability;
import org.jini.rio.resources.util.TimeUtil;

public class ServiceConsumer
implements ServiceDiscoveryListener {
    int serviceLimit;
    ServiceBeanInstantiator instantiator;
    private final Hashtable leaseTable;
    ComputeResource computeResource;
    ProvisionMonitor.PeerInfo dummyPeerInfo = new ProvisionMonitor.PeerInfo();
    private final Hashtable<ServiceID, ProvisionMonitor.PeerInfo> provisioners = new Hashtable();
    private BackwardsServiceDiscoveryManager sdm;
    long provisionerLeaseDuration;
    int provisionerRetryCount;
    long provisionerRetryDelay;
    ProxyPreparer provisionerPreparer;
    Configuration config;
    static Logger logger = CybernodeImpl.logger;

    ServiceConsumer(ServiceBeanInstantiator instantiator, ComputeResource computeResource, int serviceLimit, Configuration config) throws ConfigurationException {
        if (instantiator == null) {
            throw new NullPointerException("instantiator is null");
        }
        if (computeResource == null) {
            throw new NullPointerException("computeResource is null");
        }
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        this.config = config;
        long DEFAULT_LEASE_TIME = 60000L;
        long MIN_LEASE_TIME = 10000L;
        this.provisionerLeaseDuration = Config.getLongEntry((Configuration)config, (String)"org.jini.rio.cybernode", (String)"provisionerLeaseDuration", (long)DEFAULT_LEASE_TIME, (long)MIN_LEASE_TIME, (long)Long.MAX_VALUE);
        int DEFAULT_RETRY_COUNT = 3;
        int MIN_RETRY_COUNT = 0;
        this.provisionerRetryCount = Config.getIntEntry((Configuration)config, (String)"org.jini.rio.cybernode", (String)"provisionerRetryCount", (int)DEFAULT_RETRY_COUNT, (int)MIN_RETRY_COUNT, (int)Integer.MAX_VALUE);
        long DEFAULT_RETRY_DELAY = 1000L;
        long MIN_RETRY_DELAY = 0L;
        this.provisionerRetryDelay = Config.getLongEntry((Configuration)config, (String)"org.jini.rio.cybernode", (String)"provisionerRetryDelay", (long)DEFAULT_RETRY_DELAY, (long)MIN_RETRY_DELAY, (long)Long.MAX_VALUE);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "LeaseDuration={0}, RetryCount={1}, RetryDelay={2}", new Object[]{new Long(this.provisionerLeaseDuration), new Integer(this.provisionerRetryCount), new Long(this.provisionerRetryDelay)});
        }
        this.provisionerPreparer = (ProxyPreparer)config.getEntry("org.jini.rio.cybernode", "provisionerPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "ProxyPreparer={0}", this.provisionerPreparer);
        }
        this.leaseTable = new Hashtable();
        this.computeResource = computeResource;
        this.instantiator = instantiator;
        this.serviceLimit = serviceLimit;
        new ComputeResourceObserver(computeResource);
    }

    void initializeProvisionDiscovery(DiscoveryManagement dm) throws IOException, ConfigurationException {
        ServiceTemplate template = new ServiceTemplate(null, new Class[]{ProvisionManager.class}, null);
        this.sdm = new BackwardsServiceDiscoveryManager(dm, SharedLeaseRenewalManager.getLeaseRenewalManager(), this.config);
        this.sdm.createLookupCache(template, null, (ServiceDiscoveryListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        this.sdm.terminate();
        this.cancelRegistrations();
        Hashtable<ServiceID, ProvisionMonitor.PeerInfo> hashtable = this.provisioners;
        synchronized (hashtable) {
            this.provisioners.clear();
        }
    }

    void setServiceLimit(int serviceLimit) {
        this.serviceLimit = serviceLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceAdded(ServiceDiscoveryEvent sdEvent) {
        ServiceItem item = sdEvent.getPostEventServiceItem();
        if (logger.isLoggable(Level.FINEST)) {
            if (item == null) {
                logger.finest("Post event service item is null.");
            } else {
                logger.finest("item=" + item.toString() + "item.service=" + (item.service == null ? "null" : item.service.toString()));
            }
        }
        if (item == null || item.service == null) {
            return;
        }
        Hashtable<ServiceID, ProvisionMonitor.PeerInfo> hashtable = this.provisioners;
        synchronized (hashtable) {
            if (this.provisioners.contains(item.serviceID)) {
                return;
            }
            this.provisioners.put(item.serviceID, this.dummyPeerInfo);
        }
        logger.log(Level.FINEST, "GSM discovered {0}", new Object[]{item.service.toString()});
        this.register(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRemoved(ServiceDiscoveryEvent sdEvent) {
        ServiceItem item = sdEvent.getPreEventServiceItem();
        try {
            for (int i = 0; i < 3; ++i) {
                ((GSM)item.service).ping();
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
        catch (RemoteException e) {
            ProvisionMonitor.PeerInfo peerInfo = null;
            Hashtable<ServiceID, ProvisionMonitor.PeerInfo> hashtable = this.provisioners;
            synchronized (hashtable) {
                peerInfo = this.provisioners.remove(item.serviceID);
            }
            if (peerInfo == null) {
                logger.log(Level.INFO, "Removal notification for GSM - " + item.service + " service-id[" + item.serviceID + "]");
            } else {
                logger.log(Level.INFO, "Unregistered with GSM - " + peerInfo + " service-id[" + item.serviceID + "]");
            }
            ProvisionLeaseManager leaseManager = (ProvisionLeaseManager)this.leaseTable.remove(item.service);
            if (leaseManager != null) {
                leaseManager.drop(true);
            }
            return;
        }
    }

    public void serviceChanged(ServiceDiscoveryEvent sdEvent) {
    }

    void register(ServiceItem item) {
        try {
            Lease lease;
            if (this.haveRegistration(item)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Already registered to {0}", new Object[]{item.service});
                }
                return;
            }
            ProvisionManager provisioner = (ProvisionManager)this.provisionerPreparer.prepareProxy(item.service);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "ServiceConsumer - prepared ProvisionManager proxy: {0}", provisioner);
            }
            ResourceCapability rCap = this.computeResource.getResourceCapability();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "ResourceCapability {0}", new Object[]{rCap});
            }
            if ((lease = this.connect(provisioner)) == null) {
                return;
            }
            this.leaseTable.put(item.service, new ProvisionLeaseManager(lease, provisioner));
            ProvisionMonitor.PeerInfo peerInfo = ((ProvisionMonitor)provisioner).getPeerInfo();
            this.provisioners.put(item.serviceID, peerInfo);
            logger.log(Level.INFO, "Registered with GSM - [" + peerInfo + "] service-id[" + item.serviceID + "]");
        }
        catch (Throwable t) {
            this.provisioners.remove(item.serviceID);
            logger.log(Level.SEVERE, "Failed registering with GSM - " + item.service + " service-id[" + item.serviceID + "]", t);
        }
    }

    void cancelRegistrations() {
        Enumeration e = this.leaseTable.keys();
        while (e.hasMoreElements()) {
            Object service = e.nextElement();
            ProvisionLeaseManager leaseManager = (ProvisionLeaseManager)this.leaseTable.remove(service);
            if (leaseManager == null) continue;
            leaseManager.drop(false);
        }
    }

    void updateMonitors(ResourceCapability resourceCapability, int serviceLimit) {
        this.setServiceLimit(serviceLimit);
        this.updateMonitors(resourceCapability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMonitors(ResourceCapability resourceCapability) {
        ProvisionLeaseManager[] mgrs = null;
        Hashtable hashtable = this.leaseTable;
        synchronized (hashtable) {
            Collection c = this.leaseTable.values();
            mgrs = c.toArray(new ProvisionLeaseManager[c.size()]);
        }
        if (mgrs == null) {
            return;
        }
        if (mgrs.length == 0) {
            return;
        }
        for (int i = 0; i < mgrs.length; ++i) {
            try {
                mgrs[i].provisioner.update(this.instantiator, resourceCapability, this.serviceLimit, this.instantiator.getServiceRecords(1));
                continue;
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Failure to update GSM " + mgrs[i].provisioner, t);
            }
        }
    }

    private Lease connect(ProvisionManager provisioner) {
        Exception connectException = null;
        boolean connected = false;
        Lease lease = null;
        if (!this.allowedToConnect(provisioner)) {
            logger.log(Level.WARNING, "Security restriction - unable to connect with GSM:\n {0}", new Object[]{provisioner.toString()});
            return null;
        }
        int totalRetries = (int)((long)this.provisionerRetryCount * (this.provisionerLeaseDuration / this.provisionerRetryDelay));
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Trying to connect with GSM [" + provisioner + "] provisionerLeaseDuration=" + this.provisionerLeaseDuration + " provisionerRetryCount=" + this.provisionerRetryCount + " provisionerRetryDelay=" + this.provisionerRetryDelay + " totalRetries=" + totalRetries);
        }
        for (int i = 0; i <= totalRetries && !Thread.currentThread().isInterrupted(); ++i) {
            try {
                block17: {
                    EventRegistration er = provisioner.register(this.instantiator, null, this.computeResource.getResourceCapability(), this.serviceLimit, this.provisionerLeaseDuration, this.instantiator.getServiceRecords(1));
                    lease = (Lease)this.provisionerPreparer.prepareProxy((Object)er.getLease());
                    long leaseTime = lease.getExpiration() - SystemTime.timeMillis();
                    if (leaseTime > 0L) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Established GSM registration [" + provisioner + "]");
                        }
                        connected = true;
                        break;
                    }
                    logger.log(Level.WARNING, "Invalid Lease time [" + leaseTime + "] returned from GSM [" + provisioner + "], retry count [" + i + "]");
                    try {
                        lease.cancel();
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.FINE)) break block17;
                        logger.log(Level.FINE, "Canceling Lease with invalid lease time", e);
                    }
                }
                try {
                    Thread.sleep(this.provisionerRetryDelay);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Exception e) {
                connectException = e;
                if (i == 0) {
                    logger.log(Level.WARNING, "Failed registering lease with GSM [" + provisioner + "] - will retry for " + TimeUnit.MILLISECONDS.toMinutes((long)this.provisionerRetryCount * this.provisionerLeaseDuration) + " minutes, total retries [" + totalRetries + "]", e);
                } else if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Failed registering lease with GSM [" + provisioner + "], retry count [" + i + "]", e);
                }
                int category = ThrowableConstants.retryable((Throwable)e);
                if (i <= this.provisionerRetryCount && category != 0 && category != 3) continue;
                try {
                    Thread.sleep(this.provisionerRetryDelay);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            break;
        }
        if (!connected) {
            logger.log(Level.WARNING, (Thread.currentThread().isInterrupted() ? "Interrupted - " : "") + "Unable to register with GSM: " + provisioner, connectException);
            return null;
        }
        return lease;
    }

    private boolean allowedToConnect(ProvisionManager provisioner) {
        return !(provisioner instanceof SecuredGSMProxy) ^ this.instantiator instanceof SecuredGSCProxy;
    }

    boolean haveRegistration(ServiceItem item) {
        Enumeration e = this.leaseTable.keys();
        while (e.hasMoreElements()) {
            Object service = e.nextElement();
            if (!service.equals(item.service)) continue;
            return true;
        }
        return false;
    }

    class ComputeResourceObserver
    implements Observer {
        ComputeResource computeResource;

        ComputeResourceObserver(ComputeResource computeResource) {
            this.computeResource = computeResource;
            computeResource.addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            if (!(o instanceof ComputeResource)) {
                logger.log(Level.WARNING, "Observable update is not a ComputeResource, detach");
                this.computeResource.deleteObserver(this);
                return;
            }
            ServiceConsumer.this.updateMonitors((ResourceCapability)arg);
        }
    }

    class ProvisionLeaseManager
    extends Thread {
        long leaseTime;
        volatile boolean keepAlive;
        volatile Lease lease;
        ProvisionManager provisioner;
        ProvisionMonitor.PeerInfo peerInfo;

        ProvisionLeaseManager(Lease lease, ProvisionManager provisioner) {
            super("ProvisionLeaseManager");
            this.keepAlive = true;
            this.lease = lease;
            this.leaseTime = lease.getExpiration() - SystemTime.timeMillis();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "ProvisionMonitor Lease expiration : [" + lease.getExpiration() + "]  millis, [" + lease.getExpiration() / 1000L + "] seconds, duration : [" + this.leaseTime + "] millis, [" + this.leaseTime / 1000L + "], secs");
            }
            this.provisioner = provisioner;
            try {
                this.peerInfo = ((ProvisionMonitor)provisioner).getPeerInfo();
            }
            catch (RemoteException e) {
                this.peerInfo = null;
            }
            this.setDaemon(true);
            this.start();
        }

        void drop(boolean removed) {
            if (!removed) {
                try {
                    this.lease.cancel();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not drop GSM lease, already cancelled [" + this.lease + "]");
                }
            }
            this.lease = null;
            this.keepAlive = false;
            this.interrupt();
        }

        @Override
        public void run() {
            Object removed;
            while (!ProvisionLeaseManager.interrupted()) {
                if (!this.keepAlive) {
                    return;
                }
                long nextLeaseRenewalTime = TimeUtil.computeLeaseRenewalTime(this.leaseTime);
                if (nextLeaseRenewalTime + this.leaseTime < this.lease.getExpiration()) {
                    try {
                        ProvisionLeaseManager.sleep(nextLeaseRenewalTime);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (IllegalArgumentException iae) {
                        logger.warning("Next Lease renewal time incorrect : " + nextLeaseRenewalTime);
                    }
                }
                if (this.lease == null) continue;
                try {
                    this.lease.renew(this.leaseTime);
                }
                catch (Exception e) {
                    if (this.lease == null) continue;
                    logger.log(Level.FINEST, "Failed to renew lease [" + this.lease + "] with GSM - [" + this.peerInfo + "], expires [" + new Date(this.lease.getExpiration()) + "], canceling lease", e);
                    try {
                        this.lease.cancel();
                    }
                    catch (Exception e1) {
                        logger.log(Level.FINEST, "Failed to cancel a failed lease renewal [" + this.lease + "] with GSM - [" + this.peerInfo + "]", e1);
                    }
                    if (this.keepAlive) {
                        boolean connected;
                        if (logger.isLoggable(Level.INFO)) {
                            logger.log(Level.INFO, "Failed to renew lease with GSM - [" + this.peerInfo + "], attempts to reconnect", e);
                        }
                        if (connected = this.reconnect()) {
                            if (!logger.isLoggable(Level.INFO)) continue;
                            logger.log(Level.INFO, "Reconnect with GSM - [" + this.peerInfo + "] successful, granted lease of: [" + this.leaseTime + " ms], expires at [" + new Date(this.lease.getExpiration()) + "]");
                            continue;
                        }
                        if (!logger.isLoggable(Level.WARNING)) break;
                        logger.log(Level.WARNING, "Failed to renew lease with GSM - [" + this.peerInfo + "], attempt to reconnect failed");
                        break;
                    }
                    if (!logger.isLoggable(Level.FINE)) break;
                    logger.log(Level.FINE, "No retry attempted, GSM - [" + this.peerInfo + "] determined unreachable");
                    break;
                }
            }
            if ((removed = ServiceConsumer.this.leaseTable.remove(this.provisioner)) != null && logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Remove ProvisionLeaseManager from leaseManagerTable");
            }
        }

        boolean reconnect() {
            boolean connected;
            if (!this.keepAlive) {
                return false;
            }
            this.lease = ServiceConsumer.this.connect(this.provisioner);
            boolean bl = connected = this.lease != null;
            if (!connected) {
                this.keepAlive = false;
            } else {
                this.leaseTime = this.lease.getExpiration() - SystemTime.timeMillis();
            }
            return connected;
        }
    }
}

