/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.provision.ServiceStatement;
import org.jini.rio.core.provision.ServiceStatementManager;

public class TransientServiceStatementManager
implements ServiceStatementManager {
    private static final Logger LOGGER = Logger.getLogger(TransientServiceStatementManager.class.getName());
    private Map statementMap = new HashMap();

    public TransientServiceStatementManager(Configuration config) {
    }

    @Override
    public void terminate() {
        this.statementMap = null;
    }

    @Override
    public synchronized ServiceStatement[] get() {
        return this.statementMap.values().toArray(new ServiceStatement[0]);
    }

    @Override
    public synchronized ServiceStatement get(ServiceElement sElem) {
        return (ServiceStatement)this.statementMap.get(sElem);
    }

    @Override
    public synchronized void record(ServiceStatement statement) {
        ServiceElement key = statement.getServiceElement();
        boolean active = statement.hasActiveServiceRecords();
        if (active) {
            this.statementMap.put(key, statement);
        } else {
            this.remove(key);
        }
    }

    private void remove(ServiceElement key) {
        this.statementMap.remove(key);
        LOGGER.log(Level.FINEST, key.getName() + " is Inactive, Removed Records.");
    }
}

