/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode.ui;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.cybernode.Cybernode;
import org.jini.rio.cybernode.CybernodeAdmin;
import org.jini.rio.cybernode.ui.ServiceTable;
import org.jini.rio.entry.ComputeResourceUtilization;

public class CybernodeUI
extends JPanel
implements Runnable {
    private static final long serialVersionUID = 5656139331548422424L;
    private ServiceTable serviceTable;
    private ServiceItem item;
    private JTextField maxSvcCount;
    private JTextField currentSvcCount;
    private JTextField utilizationTF;
    private Cybernode cybernode;
    private CybernodeAdmin cybernodeAdmin;
    private JButton apply;
    private JButton replicate;
    private Integer svcCount;
    private Integer maxCount;
    private Hashtable idTable;
    private List queue = Collections.synchronizedList(new LinkedList());
    private boolean keepAlive = true;
    private transient Thread thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CybernodeUI(Object arg) {
        this.getAccessibleContext().setAccessibleName("Container admin");
        this.item = (ServiceItem)arg;
        this.cybernode = (Cybernode)this.item.service;
        try {
            this.cybernodeAdmin = (CybernodeAdmin)this.cybernode.getAdmin();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.idTable = new Hashtable();
        JPanel qPanel = new JPanel();
        qPanel.setLayout(new BoxLayout(qPanel, 0));
        qPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Compute Resource"), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        qPanel.add(new JLabel("Description"));
        qPanel.add(Box.createHorizontalStrut(8));
        ComputeResourceUtilization computeResource = this.getComputeResourceUtilization(this.item.attributeSets);
        String field = "unknown: system error";
        if (computeResource != null) {
            field = computeResource.description;
        }
        JTextField descTF = new JTextField(field);
        descTF.setEnabled(false);
        qPanel.add(descTF);
        qPanel.add(Box.createHorizontalStrut(8));
        qPanel.add(new JLabel("Utilization"));
        qPanel.add(Box.createHorizontalStrut(8));
        if (computeResource != null) {
            field = computeResource.utilization.toString();
        }
        this.utilizationTF = new JTextField(field);
        this.utilizationTF.setEnabled(false);
        qPanel.add(this.utilizationTF);
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new GridLayout(0, 3, 4, 4));
        cPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Container Attributes"), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        this.maxSvcCount = new JTextField();
        this.currentSvcCount = new JTextField();
        this.currentSvcCount.setEnabled(false);
        this.apply = new JButton("Apply");
        this.apply.addActionListener(new ApplyHandler());
        this.maxCount = new Integer(0);
        this.svcCount = new Integer(0);
        try {
            this.maxCount = this.cybernodeAdmin.getServiceLimit();
            this.maxSvcCount.setText(this.maxCount.toString());
            this.svcCount = this.cybernodeAdmin.getServiceCount();
            this.currentSvcCount.setText(this.svcCount.toString());
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        cPanel.add(new JLabel("Contained Services"));
        cPanel.add(this.currentSvcCount);
        cPanel.add(new JLabel(""));
        cPanel.add(new JLabel("Service Limit"));
        cPanel.add(this.maxSvcCount);
        cPanel.add(this.apply);
        JPanel cq = new JPanel();
        cq.setLayout(new BorderLayout());
        cq.add("North", qPanel);
        cq.add("Center", cPanel);
        this.serviceTable = new ServiceTable();
        this.setLayout(new BorderLayout(8, 8));
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.add("North", cq);
        this.add("Center", this.serviceTable);
        this.thread = new Thread(this);
        this.thread.start();
        List list = this.queue;
        synchronized (list) {
            this.queue.add(new Object());
            this.queue.notifyAll();
        }
    }

    @Override
    public void removeNotify() {
        this.terminate();
    }

    @Override
    public void run() {
        if (this.cybernode == null) {
            this.showError("Reference to Container is null");
            return;
        }
        while (!this.thread.isInterrupted() && this.keepAlive) {
            try {
                this.serviceTable.clear();
                ServiceRecord[] records = this.cybernode.getServiceRecords(1);
                for (int i = 0; i < records.length; ++i) {
                    this.serviceTable.addService(records[i]);
                }
                this.currentSvcCount.setText(this.getCybernodeCount().toString());
                Double utilization = new Double(this.cybernodeAdmin.getUtilization());
                this.utilizationTF.setText(utilization.toString());
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException e) {
                    if (this.keepAlive) continue;
                }
            }
            catch (Exception e) {
                if (!this.keepAlive) break;
                e.printStackTrace();
                this.showError(e.toString());
                if (this.apply != null) {
                    this.apply.setEnabled(false);
                }
                if (this.replicate == null) break;
                this.replicate.setEnabled(false);
            }
            break;
        }
    }

    public void terminate() {
        this.keepAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        if (this.apply != null) {
            this.apply.setEnabled(false);
        }
        if (this.replicate != null) {
            this.replicate.setEnabled(false);
        }
    }

    protected void showInformation(String text) {
        JOptionPane.showMessageDialog(this, text, "Information Message", 1);
    }

    protected void showError(String text) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(this, text, "System Error", 0);
    }

    JTextField createAttrTextField() {
        JTextField tf = new JTextField();
        tf.setEnabled(false);
        return tf;
    }

    Integer getCybernodeCount() {
        try {
            this.svcCount = this.cybernodeAdmin.getServiceCount();
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return this.svcCount;
    }

    ComputeResourceUtilization getComputeResourceUtilization(Entry[] attrs) {
        for (int x = 0; x < attrs.length; ++x) {
            if (!(attrs[x] instanceof ComputeResourceUtilization)) continue;
            return (ComputeResourceUtilization)attrs[x];
        }
        return null;
    }

    class ApplyHandler
    implements ActionListener {
        ApplyHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String title;
                Integer newCount = null;
                Integer count = CybernodeUI.this.cybernodeAdmin.getServiceLimit();
                String s = CybernodeUI.this.maxSvcCount.getText();
                try {
                    newCount = new Integer(s);
                }
                catch (Throwable t) {
                    CybernodeUI.this.showError("You must enter a valid number");
                    return;
                }
                if (count.equals(newCount)) {
                    return;
                }
                String message = "Set service limit to [" + s + "] ?";
                int answer = JOptionPane.showConfirmDialog(null, message, title = "Container Service Configuration Change Confirmation", 0);
                if (answer != 0) {
                    return;
                }
                CybernodeUI.this.cybernodeAdmin.setServiceLimit(newCount);
                CybernodeUI.this.maxCount = CybernodeUI.this.cybernodeAdmin.getServiceLimit();
            }
            catch (RemoteException re) {
                re.printStackTrace();
                CybernodeUI.this.showError(re.getMessage());
            }
        }
    }
}

