/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.cybernode.Cybernode;
import org.jini.rio.cybernode.CybernodeAdmin;
import org.jini.rio.cybernode.ui.PropertiesTable;
import org.jini.rio.qos.capability.PlatformCapability;

public class PlatformCapabilityUI
extends JPanel
implements Runnable {
    private static final long serialVersionUID = 2355681752352261395L;
    Cybernode cybernode;
    CybernodeAdmin cybernodeAdmin;
    JTable capabilityTable;
    PlatformCapabilityModel dataModel;
    JCheckBox supportsProvisioning;

    public PlatformCapabilityUI(Object arg) {
        this.getAccessibleContext().setAccessibleName("Platform Capabilities");
        ServiceItem item = (ServiceItem)arg;
        this.cybernode = (Cybernode)item.service;
        try {
            this.cybernodeAdmin = (CybernodeAdmin)this.cybernode.getAdmin();
        }
        catch (Exception e) {
            this.showError(e);
        }
        this.setLayout(new BorderLayout(2, 4));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        JPanel provPanel = new JPanel();
        provPanel.setLayout(new BorderLayout(8, 8));
        provPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Persistent Provisioning"), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        JLabel label = new JLabel("<html>Set whether the Cybernode supports persistent provisioning of qualitative capabilities</html>");
        provPanel.add((Component)label, "North");
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        this.supportsProvisioning = new JCheckBox("Supports persistent provisioning");
        label.setLabelFor(this.supportsProvisioning);
        subPanel.add(this.supportsProvisioning);
        JButton apply = new JButton("Apply");
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    PlatformCapabilityUI.this.cybernodeAdmin.setPersistentProvisioning(PlatformCapabilityUI.this.supportsProvisioning.isSelected());
                }
                catch (Exception e) {
                    PlatformCapabilityUI.this.showError(e);
                }
            }
        });
        subPanel.add(Box.createHorizontalGlue());
        subPanel.add(apply);
        provPanel.add((Component)subPanel, "Center");
        this.add((Component)provPanel, "North");
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout(8, 8));
        tablePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Current Platform Capabilities"), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        this.capabilityTable = new JTable();
        this.capabilityTable.addMouseListener(new RowListener());
        this.dataModel = new PlatformCapabilityModel();
        this.capabilityTable.setModel(this.dataModel);
        TableColumnModel cm = this.capabilityTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(30);
        this.capabilityTable.setAutoResizeMode(3);
        JScrollPane scroller = new JScrollPane(this.capabilityTable);
        tablePanel.add((Component)scroller, "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        JButton details = new JButton("Details");
        details.setToolTipText("Get details on the selected PlatformCapability");
        details.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int row = PlatformCapabilityUI.this.capabilityTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                PlatformCapabilityUI.this.showDetails(PlatformCapabilityUI.this.getPlatformCapability(row));
            }
        });
        buttons.add(details);
        tablePanel.add((Component)buttons, "South");
        this.add((Component)tablePanel, "Center");
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        try {
            this.supportsProvisioning.setSelected(this.cybernodeAdmin.getPersistentProvisioning());
            PlatformCapability[] pCaps = this.cybernodeAdmin.getPlatformCapabilties();
            for (int i = 0; i < pCaps.length; ++i) {
                this.addPlatformCapability(pCaps[i]);
            }
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    void addPlatformCapability(PlatformCapability pCap) {
        this.dataModel.addItem(pCap);
        this.dataModel.fireTableDataChanged();
    }

    void removePlatformCapability(int row) {
        this.dataModel.removeItem(row);
    }

    void clearPlatformCapabilities() {
        this.dataModel.clear();
    }

    PlatformCapability getPlatformCapability(int row) {
        if (row == -1) {
            return null;
        }
        return (PlatformCapability)this.dataModel.getItem(row);
    }

    void showError(Exception e) {
        StringBuffer buffer = new StringBuffer();
        StackTraceElement[] trace = e.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            buffer.append("at " + trace[i] + "<br>");
        }
        this.showError("<html>Exception : <font color=red>" + e.getClass().getName() + "</font><br>" + buffer.toString() + "</html>");
    }

    void showError(String text) {
        JOptionPane.showMessageDialog(this, text, "System Error", 0);
    }

    void showDetails(PlatformCapability pCap) {
        PlatformCapabilityDetails details = new PlatformCapabilityDetails(null, pCap);
        if (details.changed) {
            Thread thread = new Thread(this);
            this.clearPlatformCapabilities();
            thread.start();
        }
    }

    class KeyValueDialog
    extends JDialog {
        private static final long serialVersionUID = -3252840929875023159L;
        JPanel base;
        JTextField key;
        JTextField value;

        KeyValueDialog(JDialog parent) {
            this(parent, "", "");
        }

        KeyValueDialog(JDialog parent, String keyText, String valueText) {
            super(parent, "Platform Capability Mapping", true);
            this.base = new JPanel();
            this.base.setLayout(new BorderLayout(6, 6));
            this.base.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
            JPanel basics = new JPanel();
            basics.setLayout(new GridLayout(4, 1, 8, 8));
            JLabel keyLabel = new JLabel("<html>Enter a value for the key</html>");
            this.key = new JTextField();
            this.key.setText(keyText);
            keyLabel.setLabelFor(this.key);
            JLabel valueLabel = new JLabel("<html>Enter a value for the value</html>");
            this.value = new JTextField();
            this.value.setText(valueText);
            valueLabel.setLabelFor(this.value);
            JButton accept = new JButton("OK");
            accept.setToolTipText("Accept entries for key,value pair");
            accept.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (KeyValueDialog.this.key.getText().length() == 0) {
                        KeyValueDialog.this.showError("You must provide a value for the key");
                        return;
                    }
                    if (KeyValueDialog.this.value.getText().length() == 0) {
                        KeyValueDialog.this.showError("You must provide a value for the value");
                        return;
                    }
                    KeyValueDialog.this.dispose();
                }
            });
            JButton close = new JButton("Close");
            close.setToolTipText("Closes the dialog");
            close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyValueDialog.this.dispose();
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            buttonPanel.add(accept);
            buttonPanel.add(Box.createHorizontalGlue());
            buttonPanel.add(close);
            basics.add(keyLabel);
            basics.add(this.key);
            basics.add(valueLabel);
            basics.add(this.value);
            basics.add(buttonPanel);
            this.base.add((Component)basics, "Center");
            this.base.add((Component)buttonPanel, "South");
            this.getContentPane().add(this.base);
            this.pack();
            this.display();
        }

        public String getKey() {
            return this.key.getText();
        }

        public String getValue() {
            return this.value.getText();
        }

        private void display() {
            int width = 365;
            int height = 205;
            this.pack();
            this.setSize(width, height);
            this.getContentPane().add(this.base);
            WindowAdapter l = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    KeyValueDialog.this.dispose();
                }
            };
            this.addWindowListener(l);
            Rectangle rect = this.getParent().getBounds();
            int widthLoc = (int)rect.getWidth() / 2 + this.getParent().getX() - width / 2;
            this.setLocation(widthLoc, this.getParent().getY() + 20);
            this.setVisible(true);
        }

        void showError(String text) {
            JOptionPane.showMessageDialog(this, text, "User Input Error", 0);
        }
    }

    class PlatformCapabilityDetails
    extends JDialog {
        private static final long serialVersionUID = -6880280124223083005L;
        final PlatformCapability pCap;
        JPanel base;
        JDialog instance;
        PropertiesTable propsTable;
        boolean changed;

        PlatformCapabilityDetails(JFrame frameOwner, PlatformCapability pCap) {
            super(frameOwner, "Platform Capability Details", true);
            this.changed = false;
            this.pCap = pCap;
            this.instance = this;
            this.base = new JPanel();
            this.base.setLayout(new BorderLayout(2, 4));
            this.base.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
            JPanel basics = new JPanel();
            basics.setLayout(new GridLayout(3, 2, 4, 4));
            basics.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General Information"), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
            basics.add(new JLabel("Description"));
            basics.add(this.createTextField(pCap.getDescription()));
            basics.add(new JLabel("Class"));
            basics.add(this.createTextField(pCap.getClass().getName()));
            basics.add(new JLabel("Type"));
            basics.add(this.createTextField(pCap.getType() == 1 ? "STATIC" : "PROVISIONABLE"));
            this.base.add((Component)basics, "North");
            JPanel capabilityPanel = new JPanel();
            capabilityPanel.setLayout(new BorderLayout(4, 4));
            capabilityPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Capability Support Mappings"), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
            Properties props = new Properties();
            Object[] keys = pCap.getPlatformKeys();
            for (int i = 0; i < keys.length; ++i) {
                props.put(keys[i], pCap.getValue(keys[i]));
            }
            if (pCap.getPath() != null) {
                props.put("Path", pCap.getPath());
            }
            String storageClass = "org.jini.rio.qos.capability.system.StorageCapability";
            if (pCap.getClass().getName().equals(storageClass)) {
                Double dVal = (Double)props.get("Available");
                if (dVal != null) {
                    props.put("Available", this.formatStorageCapabilityValue(dVal));
                }
                if ((dVal = (Double)props.get("Capacity")) != null) {
                    props.put("Capacity", this.formatStorageCapabilityValue(dVal));
                }
            }
            this.propsTable = new PropertiesTable(props);
            capabilityPanel.add((Component)this.propsTable, "Center");
            this.base.add((Component)capabilityPanel, "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            JButton close = new JButton("Close");
            close.setToolTipText("Closes the dialog");
            close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlatformCapabilityDetails.this.dispose();
                }
            });
            buttonPanel.add(Box.createHorizontalGlue());
            buttonPanel.add(close);
            buttonPanel.add(Box.createHorizontalGlue());
            this.base.add((Component)buttonPanel, "South");
            this.getContentPane().add(this.base);
            this.pack();
            this.showDialog();
        }

        JTextField createTextField(String text) {
            JTextField tf = new JTextField(text);
            tf.setEditable(false);
            return tf;
        }

        String formatStorageCapabilityValue(Double dVal) {
            String result = dVal.toString();
            try {
                double value = dVal / 1024.0;
                result = new Double(value).intValue() + " kbytes";
            }
            catch (Exception e) {
                System.err.println("Bad StorageCapability value [" + dVal + "]");
            }
            return result;
        }

        private void showDialog() {
            int width = 400;
            int height = 370;
            this.pack();
            this.setSize(width, height);
            this.getContentPane().add(this.base);
            WindowAdapter l = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PlatformCapabilityDetails.this.dispose();
                }
            };
            this.addWindowListener(l);
            this.setVisible(true);
        }
    }

    class RowListener
    extends MouseAdapter {
        RowListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int clickCount = e.getClickCount();
            if (clickCount == 2) {
                int row = PlatformCapabilityUI.this.capabilityTable.rowAtPoint(new Point(e.getX(), e.getY()));
                if (row == -1) {
                    return;
                }
                PlatformCapabilityUI.this.showDetails(PlatformCapabilityUI.this.getPlatformCapability(row));
            }
        }
    }

    class PlatformCapabilityModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2656499082879179286L;
        Vector tableData = new Vector();
        final String[] columnNames = new String[]{"Name", "Description", "Class", "Package"};

        @Override
        public Object getValueAt(int index, int columnIndex) {
            try {
                PlatformCapability pCap = (PlatformCapability)this.tableData.elementAt(index);
                switch (columnIndex) {
                    case 0: {
                        return pCap.getValue("Name");
                    }
                    case 1: {
                        return pCap.getDescription();
                    }
                    case 2: {
                        String name = pCap.getClass().getName();
                        int ndx = name.lastIndexOf(".");
                        if (ndx != -1) {
                            name = name.substring(ndx + 1, name.length());
                        }
                        return name;
                    }
                    case 3: {
                        String pkgName = pCap.getClass().getName();
                        int x = pkgName.lastIndexOf(".");
                        if (x != -1) {
                            pkgName = pkgName.substring(0, x);
                        }
                        return pkgName;
                    }
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        void clear() {
            this.tableData.clear();
            this.fireTableDataChanged();
        }

        public void addItem(Object item) {
            int rowNum = this.tableData.size();
            this.tableData.insertElementAt(item, rowNum);
            this.fireTableRowsInserted(rowNum, rowNum);
        }

        public void removeItem(int row) {
            this.tableData.removeElementAt(row);
            this.fireTableDataChanged();
        }

        public Object getItem(int row) {
            return this.tableData.elementAt(row);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void setValueAt(Object item, int rowNum) {
            this.tableData.setElementAt(item, rowNum);
            this.fireTableRowsUpdated(rowNum, rowNum);
        }
    }
}

