/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.cybernode.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class PropertiesTable
extends JPanel {
    private static final long serialVersionUID = 434263888436439459L;
    JTable propertiesTable;
    PropertiesTableModel propertiesTableModel;

    public PropertiesTable() {
        this.setLayout(new BorderLayout());
        this.propertiesTable = new JTable();
        this.propertiesTableModel = new PropertiesTableModel();
        this.propertiesTable.setModel(this.propertiesTableModel);
        this.propertiesTable.setAutoResizeMode(3);
        TableColumnModel cm = this.propertiesTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(100);
        cm.getColumn(0).setMaxWidth(200);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setForeground(Color.gray);
        cm.getColumn(0).setCellRenderer(renderer);
        JScrollPane scroller = new JScrollPane(this.propertiesTable);
        this.add((Component)scroller, "Center");
    }

    public PropertiesTable(Properties props) {
        this();
        this.setProperties(props);
    }

    public void setProperties(Properties props) {
        if (props == null) {
            throw new NullPointerException("props is null");
        }
        this.propertiesTableModel.setData(props);
    }

    void addMapping(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.propertiesTableModel.addKeyValue(key, value);
    }

    String getKey(int row) {
        return (String)this.propertiesTableModel.getValueAt(row, 0);
    }

    String getValue(int row) {
        if (row == -1) {
            return null;
        }
        return (String)this.propertiesTableModel.getValueAt(row, 1);
    }

    void setKey(String key, int row) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.propertiesTableModel.setValueAt(key, row, 0);
    }

    void setValue(String value, int row) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.propertiesTableModel.setValueAt(value, row, 1);
    }

    Properties getProperties() {
        return this.propertiesTableModel.getProperties();
    }

    public void clearTable() {
        this.propertiesTableModel.removeAll();
    }

    boolean removeSelectedRow() {
        int row = this.propertiesTable.getSelectedRow();
        if (row == -1) {
            return false;
        }
        this.propertiesTableModel.removeItem(row);
        return true;
    }

    int getSelectedRow() {
        return this.propertiesTable.getSelectedRow();
    }

    class PropertiesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3058220292080562538L;
        Vector keys = new Vector();
        Vector values = new Vector();
        final String[] columnNames = new String[]{"Key", "Value"};

        void setData(Properties props) {
            this.keys.clear();
            Enumeration<Object> e = props.propertyNames();
            while (e.hasMoreElements()) {
                this.keys.add(e.nextElement());
            }
            this.values.clear();
            e = this.keys.elements();
            while (e.hasMoreElements()) {
                this.values.add(props.getProperty((String)e.nextElement()));
            }
            this.fireTableDataChanged();
        }

        void addKeyValue(String key, String value) {
            this.keys.add(key);
            this.values.add(value);
            this.fireTableDataChanged();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (column == 1) {
                this.values.set(row, value);
                this.fireTableRowsUpdated(row, row);
            } else {
                super.setValueAt(value, row, column);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                switch (column) {
                    case 0: {
                        return this.keys.elementAt(row);
                    }
                    case 1: {
                        return this.values.elementAt(row);
                    }
                }
            }
            catch (Throwable t) {
                System.out.println("bad row number : " + row);
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.keys == null) {
                return 0;
            }
            return this.keys.size();
        }

        public void removeAll() {
            this.keys.clear();
            this.values.clear();
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void removeItem(int row) {
            this.keys.remove(row);
            this.values.remove(row);
            this.fireTableDataChanged();
        }

        Properties getProperties() {
            Properties props = new Properties();
            for (int i = 0; i < this.keys.size(); ++i) {
                props.put(this.keys.get(i), this.values.get(i));
            }
            return props;
        }
    }
}

