/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.entry;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.entry.AbstractEntry;
import net.jini.lookup.entry.ServiceControlled;

public class ApplianceInfo
extends AbstractEntry
implements ServiceControlled {
    static final long serialVersionUID = 1L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.config");
    public String osName;
    public String osVersion;
    public String arch;
    public String jvmVendor;
    public String jvmVersion;
    public String hostName;
    public String hostAddress;

    public void initialize(InetAddress address) {
        this.osName = System.getProperty("os.name");
        this.osVersion = System.getProperty("os.version");
        this.arch = System.getProperty("os.arch");
        this.jvmVendor = System.getProperty("java.vendor");
        this.jvmVersion = System.getProperty("java.version");
        this.hostName = address.getHostName();
        this.hostAddress = address.getHostAddress();
    }

    public static ApplianceInfo getApplianceInfo(Entry[] attrs) {
        ApplianceInfo ai = null;
        for (int x = 0; x < attrs.length; ++x) {
            if (!attrs[x].getClass().getName().equals(ApplianceInfo.class.getName())) continue;
            if (attrs[x] instanceof ApplianceInfo) {
                ai = (ApplianceInfo)attrs[x];
                break;
            }
            ai = new ApplianceInfo();
            try {
                Field ha = attrs[x].getClass().getDeclaredField("hostAddress");
                Field hn = attrs[x].getClass().getDeclaredField("hostName");
                ai.hostAddress = (String)ha.get(attrs[x]);
                ai.hostName = (String)hn.get(attrs[x]);
                break;
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return ai;
    }
}

