/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.entry;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import net.jini.entry.AbstractEntry;
import net.jini.lookup.entry.ServiceControlled;

public class ComputeResourceUtilization
extends AbstractEntry
implements Comparable,
ServiceControlled,
Externalizable {
    static final long serialVersionUID = 1L;
    public String description;
    public String hostName;
    public String address;
    public Double utilization;
    public Map<String, Double> utilizationMap;

    public ComputeResourceUtilization() {
    }

    public ComputeResourceUtilization(String description, String hostName, String address, Double utilization, Map uMap) {
        if (description == null) {
            throw new NullPointerException("description is null");
        }
        if (hostName == null) {
            throw new NullPointerException("hostName is null");
        }
        if (address == null) {
            throw new NullPointerException("address is null");
        }
        if (utilization == null) {
            throw new NullPointerException("utilization is null");
        }
        if (uMap == null) {
            throw new NullPointerException("utilizationMap is null");
        }
        this.description = description;
        this.hostName = hostName;
        this.address = address;
        this.utilization = utilization;
        this.utilizationMap = new HashMap<String, Double>(uMap);
    }

    public int compareTo(Object o) {
        ComputeResourceUtilization that = (ComputeResourceUtilization)o;
        return this.utilization.compareTo(that.utilization);
    }

    private byte buildFlags() {
        byte flags = 0;
        if (this.description != null) {
            flags = (byte)(flags | 1);
        }
        if (this.hostName != null) {
            flags = (byte)(flags | 2);
        }
        if (this.address != null) {
            flags = (byte)(flags | 4);
        }
        if (this.utilization != null) {
            flags = (byte)(flags | 8);
        }
        if (this.utilizationMap != null) {
            flags = (byte)(flags | 0x10);
        }
        return flags;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte flags = this.buildFlags();
        out.writeByte(flags);
        if (flags == 0) {
            return;
        }
        if (this.description != null) {
            out.writeUTF(this.description);
        }
        if (this.hostName != null) {
            out.writeUTF(this.hostName);
        }
        if (this.address != null) {
            out.writeUTF(this.address);
        }
        if (this.utilization != null) {
            out.writeDouble(this.utilization);
        }
        if (this.utilizationMap != null) {
            out.writeInt(this.utilizationMap.size());
            for (Map.Entry<String, Double> entry : this.utilizationMap.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeDouble(entry.getValue());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        if (flags == 0) {
            return;
        }
        if ((flags & 1) != 0) {
            this.description = in.readUTF();
        }
        if ((flags & 2) != 0) {
            this.hostName = in.readUTF();
        }
        if ((flags & 4) != 0) {
            this.address = in.readUTF();
        }
        if ((flags & 8) != 0) {
            this.utilization = in.readDouble();
        }
        if ((flags & 0x10) != 0) {
            this.utilizationMap = new HashMap<String, Double>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.utilizationMap.put(in.readUTF(), in.readDouble());
            }
        }
    }

    private static interface BitMap {
        public static final byte DESCRIPTION = 1;
        public static final byte HOST_NAME = 2;
        public static final byte ADDRESS = 4;
        public static final byte UTILIZATION = 8;
        public static final byte UTILIZATION_MAP = 16;
    }
}

