/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.event;

import com.gigaspaces.time.SystemTime;
import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.EmptyConfiguration;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.export.Exporter;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import org.jini.rio.config.ExporterConfig;
import org.jini.rio.event.EventConsumer;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventProducer;
import org.jini.rio.event.RemoteServiceEvent;
import org.jini.rio.event.RemoteServiceEventListener;
import org.jini.rio.resources.util.TimeUtil;
import org.jini.rio.watch.StopWatch;
import org.jini.rio.watch.Watch;
import org.jini.rio.watch.WatchDataSourceRegistry;

public class BasicEventConsumer
implements EventConsumer,
ServerProxyTrust {
    private final EventConsumer eventConsumer;
    private final Exporter exporter;
    private final Configuration config;
    private final ProxyPreparer eventLeasePreparer;
    protected List eventSubscribers = Collections.synchronizedList(new ArrayList());
    protected Hashtable<ServiceID, EventLeaseManagerTask> leaseTable;
    protected Hashtable<ServiceID, Future> leaseFutureTable;
    protected Hashtable eventRegistrationTable;
    protected EventDescriptor edTemplate;
    protected int received = 0;
    protected long sktime;
    protected long ektime;
    protected MarshalledObject handback = null;
    public static final int DEFAULT_LEASE_DURATION = 300000;
    protected long leaseDuration = 300000L;
    protected StopWatch responseWatch = null;
    protected WatchDataSourceRegistry watchRegistry = null;
    private final int connectRetries;
    private static final int DEFAULT_CONNECT_RETRY_COUNT = 3;
    private final long retryWait;
    private static final int DEFAULT_RETRY_WAIT = 1000;
    public static final String RESPONSE_WATCH = "Response Time";
    static final String COMPONENT = "org.jini.rio.event";
    static Logger logger = Logger.getLogger("org.jini.rio.event");
    static int token = 0;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(Math.max(4, Runtime.getRuntime().availableProcessors()), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Event Lease Manager");
            thread.setDaemon(true);
            return thread;
        }
    });

    public BasicEventConsumer(EventDescriptor edTemplate) throws Exception {
        this(edTemplate, null, null, null);
    }

    public BasicEventConsumer(EventDescriptor edTemplate, Configuration config) throws Exception {
        this(edTemplate, null, null, config);
    }

    public BasicEventConsumer(EventDescriptor edTemplate, RemoteServiceEventListener listener) throws Exception {
        this(edTemplate, listener, null, null);
    }

    public BasicEventConsumer(EventDescriptor edTemplate, RemoteServiceEventListener listener, Configuration config) throws Exception {
        this(edTemplate, listener, null, config);
    }

    public BasicEventConsumer(EventDescriptor edTemplate, RemoteServiceEventListener listener, MarshalledObject handback, Configuration config) throws Exception {
        BasicProxyPreparer basicLeasePreparer = new BasicProxyPreparer();
        if (config == null) {
            config = EmptyConfiguration.INSTANCE;
        }
        this.config = config;
        this.leaseDuration = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"eventLeaseDuration", (long)300000L, (long)60000L, (long)Long.MAX_VALUE);
        this.exporter = ExporterConfig.getExporter(config, COMPONENT, "eventConsumerExporter");
        this.eventLeasePreparer = (ProxyPreparer)config.getEntry(COMPONENT, "eventLeasePreparer", ProxyPreparer.class, (Object)basicLeasePreparer);
        this.connectRetries = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)"connectRetries", (int)3, (int)0, (int)5);
        this.retryWait = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"retryWait", (long)1000L, (long)0L, (long)Long.MAX_VALUE);
        this.eventConsumer = (EventConsumer)((Object)this.exporter.export((Remote)((Object)this)));
        this.edTemplate = edTemplate;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Create BasicEventConsumer for EventDescriptor : " + edTemplate.toString());
        }
        this.handback = handback;
        this.leaseTable = new Hashtable();
        this.leaseFutureTable = new Hashtable();
        this.eventRegistrationTable = new Hashtable();
        if (listener != null) {
            this.register(listener);
        }
    }

    @Override
    public void terminate() {
        RemoteServiceEventListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                this.deregister(listeners[i]);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Deregistering EventConsumer", e);
            }
        }
        this.destroyWatch();
        if (this.eventConsumer != null) {
            try {
                this.exporter.unexport(true);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "EventConsumer not unexported", t);
            }
        }
    }

    @Override
    public boolean register(RemoteServiceEventListener listener) {
        return this.register(listener, null);
    }

    @Override
    public boolean register(RemoteServiceEventListener listener, MarshalledObject handback) {
        this.handback = handback;
        boolean added = this.eventSubscribers.add(listener);
        return added;
    }

    @Override
    public boolean deregister(RemoteServiceEventListener listener) {
        return this.removeListener(listener);
    }

    public void createWatch(WatchDataSourceRegistry watchRegistry) {
        if (watchRegistry == null) {
            throw new NullPointerException("watchRegistry is null");
        }
        this.responseWatch = new StopWatch(RESPONSE_WATCH, this.config);
        this.watchRegistry = watchRegistry;
        watchRegistry.register(this.responseWatch);
    }

    public void destroyWatch() {
        if (this.watchRegistry != null) {
            this.watchRegistry.deregister(this.responseWatch);
        }
        if (this.responseWatch != null) {
            try {
                this.responseWatch.getWatchDataSource().clear();
                this.responseWatch.getWatchDataSource().close();
            }
            catch (RemoteException e) {
                logger.log(Level.WARNING, "RemoteException Destroying Watch", e);
            }
        }
        this.responseWatch = null;
    }

    public Watch getWatch() {
        return this.responseWatch;
    }

    public EventRegistration register(ServiceItem item) {
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        if (!(item.service instanceof EventProducer)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Service is not an EventProducer");
            }
            return null;
        }
        EventDescriptor eDesc = this.getDescriptor(item.attributeSets, this.edTemplate);
        if (eDesc == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Cannot get EventDescriptor match");
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "ServiceItem.service ClassLoader {0}, EventDescriptor {1}, EventDescriptor ClassLoader {2}", new Object[]{item.service.getClass().getClassLoader().toString(), this.edTemplate.toString(), this.edTemplate.getClass().getClassLoader().toString()});
            }
            return null;
        }
        if (this.leaseTable.containsKey(item.serviceID)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Already registered to EventProducer");
            }
            return (EventRegistration)this.eventRegistrationTable.get(eDesc.eventID);
        }
        EventProducer producer = (EventProducer)item.service;
        EventRegistration eReg = null;
        Lease lease = this.connect(producer, eDesc);
        if (lease != null) {
            EventLeaseManagerTask task = new EventLeaseManagerTask(producer, lease, eDesc);
            this.leaseTable.put(item.serviceID, task);
            ScheduledFuture<?> future = this.executorService.scheduleWithFixedDelay(task, task.getDelay(), task.getDelay(), TimeUnit.MILLISECONDS);
            this.leaseFutureTable.put(item.serviceID, future);
            eReg = (EventRegistration)this.eventRegistrationTable.get(eDesc.eventID);
        }
        return eReg;
    }

    Lease connect(EventProducer producer, EventDescriptor eDesc) {
        Lease lease = null;
        for (int i = 1; i <= this.connectRetries; ++i) {
            try {
                block12: {
                    EventRegistration eReg = producer.register(eDesc, (RemoteEventListener)this.eventConsumer, this.handback, this.leaseDuration);
                    this.eventRegistrationTable.put(eDesc.eventID, eReg);
                    lease = (Lease)this.eventLeasePreparer.prepareProxy((Object)eReg.getLease());
                    long leaseTime = lease.getExpiration() - SystemTime.timeMillis();
                    if (leaseTime > 0L) {
                        if (!logger.isLoggable(Level.FINEST)) break;
                        logger.finest("Event Registration Lease acquired and prepared. Duration=" + leaseTime + "(" + leaseTime / 1000L + " seconds)");
                        break;
                    }
                    logger.log(Level.WARNING, "Invalid Lease time [" + leaseTime + "], retry count [" + i + "]");
                    try {
                        lease.cancel();
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.FINEST)) break block12;
                        logger.log(Level.FINEST, "Cancelling Lease with invalid lease time", e);
                    }
                }
                if (this.retryWait <= 0L) continue;
                try {
                    Thread.sleep(this.retryWait);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (Throwable t) {
                if (this.isUnrecoverableRemoteException(t)) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.WARNING, "Unrecoverable Exception {0} trying to register with {1} for a lease, retry #{2}/{3}", new Object[]{t, producer, i, this.connectRetries});
                        break;
                    }
                    logger.log(Level.WARNING, "Unrecoverable Exception {0} trying to register with {1} for a lease, retry #{2}/{3}", new Object[]{t.toString(), producer, i, this.connectRetries});
                    break;
                }
                if (this.retryWait <= 0L) continue;
                try {
                    Thread.sleep(this.retryWait);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return lease;
    }

    @Override
    public Object getEventRegistrationSource(long eventID) {
        EventRegistration eReg = (EventRegistration)this.eventRegistrationTable.get(new Long(eventID));
        Object source = null;
        if (eReg != null) {
            source = eReg.getSource();
        }
        return source;
    }

    public void deregister(ServiceID serviceID) {
        this.deregister(serviceID, true);
    }

    public void deregister(ServiceID serviceID, boolean disconnect) {
        Future future;
        if (serviceID == null) {
            throw new NullPointerException("serviceID is null");
        }
        EventLeaseManagerTask elm = this.leaseTable.remove(serviceID);
        if (elm != null) {
            try {
                elm.drop(disconnect);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((future = this.leaseFutureTable.remove(serviceID)) != null) {
            try {
                future.cancel(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void notify(RemoteEvent rEvent) throws UnknownEventException {
        if (!(rEvent instanceof RemoteServiceEvent)) {
            throw new UnknownEventException("Unsupported event class");
        }
        RemoteServiceEvent rsEvent = (RemoteServiceEvent)rEvent;
        long startTime = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Received RemoteEvent [" + rEvent.getClass().getName() + "], Number of subscribers : " + this.eventSubscribers.size());
        }
        RemoteServiceEventListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Notify subscriber [" + listeners[i].getClass().getName() + "]");
            }
            listeners[i].notify(rsEvent);
            ++this.received;
            this.printStats();
        }
        if (this.responseWatch != null) {
            long now = System.currentTimeMillis();
            long elapsed = now - startTime;
            this.responseWatch.setElapsedTime(elapsed, now);
        }
    }

    public TrustVerifier getProxyVerifier() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(this.getClass().getName(), "getProxyVerifier");
        }
        return new BasicProxyTrustVerifier((Object)this.eventConsumer);
    }

    protected EventDescriptor getDescriptor(Entry[] attrs, EventDescriptor template) {
        EventDescriptor matchedDescriptor = null;
        for (int x = 0; x < attrs.length; ++x) {
            if (!(attrs[x] instanceof EventDescriptor)) continue;
            EventDescriptor ed = (EventDescriptor)attrs[x];
            try {
                ed.getClass().getMethod("matches", EventDescriptor.class);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.WARNING, "Rio version mismatch, " + EventDescriptor.class.getName() + " missing matches method", e);
                return null;
            }
            if (!ed.matches(template)) continue;
            matchedDescriptor = ed;
            break;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Matched [" + template.toString() + "] ? " + (matchedDescriptor == null ? "NO" : "YES"));
        }
        return matchedDescriptor;
    }

    protected void printStats() {
        int m;
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        if (this.received == 0) {
            this.sktime = System.currentTimeMillis();
        }
        if ((m = this.received % 1000) == 0 && this.received > 0) {
            this.ektime = System.currentTimeMillis();
            float tmp = (float)(this.ektime - this.sktime) / 1000.0f;
            logger.finest("Recvd [" + this.received + "]\t[1000/" + tmp + "]\t[" + 1000.0f / tmp + "/Second]");
            this.sktime = System.currentTimeMillis();
        }
    }

    private boolean removeListener(RemoteServiceEventListener l) {
        boolean removed = this.eventSubscribers.remove(l);
        if (removed && this.eventSubscribers.size() == 0) {
            ArrayList<ServiceID> keyList = new ArrayList<ServiceID>();
            Enumeration<ServiceID> e = this.leaseTable.keys();
            while (e.hasMoreElements()) {
                keyList.add(e.nextElement());
            }
            for (ServiceID sid : keyList) {
                this.deregister(sid);
            }
        }
        return removed;
    }

    protected void finalize() throws Throwable {
        this.terminate();
        super.finalize();
    }

    protected RemoteServiceEventListener[] getListeners() {
        return this.eventSubscribers.toArray(new RemoteServiceEventListener[this.eventSubscribers.size()]);
    }

    private boolean isUnrecoverableRemoteException(Throwable ex) {
        if (ex instanceof ConnectException && ex.getCause() instanceof IOException) {
            return false;
        }
        int category = ThrowableConstants.retryable((Throwable)ex);
        return category == 1 || category == 2;
    }

    @Deprecated
    class EventLeaseManager
    extends Thread {
        long leaseTime;
        boolean keepAlive;
        EventProducer producer;
        Lease lease;
        EventDescriptor eDesc;
        private Integer id;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EventLeaseManager(EventProducer producer, Lease lease, EventDescriptor eDesc) {
            super("EventLeaseManager");
            this.keepAlive = true;
            Class<EventLeaseManager> clazz = EventLeaseManager.class;
            synchronized (EventLeaseManager.class) {
                this.id = new Integer(token++);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                this.producer = producer;
                this.lease = lease;
                this.leaseTime = lease.getExpiration() - SystemTime.timeMillis();
                this.eDesc = eDesc;
                this.setDaemon(true);
                this.start();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Created EventLeaseManager ID={0}, EventDescriptor={1}, Lease Time={2} seconds", new Object[]{this.id, eDesc.toString(), new Long(this.leaseTime / 1000L)});
                }
                return;
            }
        }

        void drop(boolean disconnect) {
            this.interrupt();
            if (disconnect) {
                try {
                    this.lease.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void interrupt() {
            this.keepAlive = false;
            super.interrupt();
        }

        @Override
        public void run() {
            while (!this.isInterrupted() && this.keepAlive) {
                try {
                    long waitTillRenew = TimeUtil.computeLeaseRenewalTime(this.leaseTime);
                    EventLeaseManager.sleep(waitTillRenew);
                }
                catch (InterruptedException waitTillRenew) {
                    // empty catch block
                }
                if (this.lease == null) continue;
                try {
                    this.lease.renew(this.leaseTime);
                }
                catch (Exception e) {
                    int category = ThrowableConstants.retryable((Throwable)e);
                    if (category == 1 || category == 2) {
                        this.keepAlive = false;
                        logger.log(Level.WARNING, "EventLeaseManager ID={0}, Unrecoverable Exception renewing Lease, dropping Lease renewal for {1}", new Object[]{this.id, this.eDesc.toString()});
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "Unrecoverable Exception renewing Lease for " + this.eDesc.toString(), e);
                        }
                    }
                    if (!this.keepAlive) continue;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Attempt to reconnect to producer {0} for event {1}", new Object[]{this.producer, this.eDesc.toString()});
                    }
                    this.lease = BasicEventConsumer.this.connect(this.producer, this.eDesc);
                    if (this.lease == null) {
                        logger.log(Level.WARNING, "EventLeaseManager ID={0}, Unable to obtain Lease, dropping Lease renewal for {1}", new Object[]{this.id, this.eDesc.toString()});
                        this.keepAlive = false;
                        continue;
                    }
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "Reconnect succeeded to producer {0} for event {1}", new Object[]{this.producer, this.eDesc.toString()});
                }
            }
        }
    }

    class EventLeaseManagerTask
    implements Runnable {
        final long leaseTime;
        boolean keepAlive = true;
        EventProducer producer;
        Lease lease;
        EventDescriptor eDesc;
        private Integer id;
        private final long delay;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EventLeaseManagerTask(EventProducer producer, Lease lease, EventDescriptor eDesc) {
            Class<EventLeaseManagerTask> clazz = EventLeaseManagerTask.class;
            synchronized (EventLeaseManagerTask.class) {
                this.id = new Integer(token++);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                this.producer = producer;
                this.lease = lease;
                this.leaseTime = lease.getExpiration() - SystemTime.timeMillis();
                this.eDesc = eDesc;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Created EventLeaseManager ID={0}, EventDescriptor={1}, Lease Time={2} seconds", new Object[]{this.id, eDesc.toString(), new Long(this.leaseTime / 1000L)});
                }
                this.delay = TimeUtil.computeLeaseRenewalTime(this.leaseTime);
                return;
            }
        }

        void drop(boolean disconnect) {
            if (disconnect) {
                try {
                    this.lease.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        long getDelay() {
            return this.delay;
        }

        @Override
        public void run() {
            block7: {
                if (this.lease != null) {
                    try {
                        this.lease.renew(this.leaseTime);
                    }
                    catch (Exception e) {
                        if (BasicEventConsumer.this.isUnrecoverableRemoteException(e)) {
                            logger.log(Level.WARNING, "EventLeaseManager ID={0}, Unrecoverable Exception renewing Lease, dropping Lease renewal for {1}, exception{2}", new Object[]{this.id, this.eDesc.toString(), e.toString()});
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.log(Level.FINEST, "Unrecoverable Exception renewing Lease for " + this.eDesc.toString(), e);
                            }
                            throw new RuntimeException(e);
                        }
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "Attempt to reconnect to producer {0} for event {1}", new Object[]{this.producer, this.eDesc.toString()});
                        }
                        this.lease = BasicEventConsumer.this.connect(this.producer, this.eDesc);
                        if (this.lease == null) {
                            logger.log(Level.WARNING, "EventLeaseManager ID={0}, Unable to obtain Lease, dropping Lease renewal for {1}", new Object[]{this.id, this.eDesc.toString()});
                            throw new RuntimeException(e);
                        }
                        if (!logger.isLoggable(Level.FINEST)) break block7;
                        logger.log(Level.FINEST, "Reconnect succeeded to producer {0} for event {1}", new Object[]{this.producer, this.eDesc.toString()});
                    }
                }
            }
        }
    }
}

