/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.event;

import com.sun.jini.constants.ThrowableConstants;
import java.net.ConnectException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventHandler;
import org.jini.rio.event.RemoteServiceEvent;
import org.jini.rio.resources.servicecore.ServiceResource;

public class DispatchEventHandler
extends EventHandler {
    static Logger logger = Logger.getLogger("org.jini.rio.event");

    public DispatchEventHandler(EventDescriptor descriptor) throws Exception {
        super(descriptor);
    }

    public DispatchEventHandler(EventDescriptor descriptor, Configuration config) throws Exception {
        super(descriptor, config);
    }

    @Override
    public void fire(RemoteServiceEvent event) throws RemoteException {
        event.setEventID(this.descriptor.eventID);
        event.setSequenceNumber(this.sequenceNumber);
        ServiceResource[] resources = this.resourceMgr.getServiceResources();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("DispatchEventHandler: notify [" + resources.length + "] listeners with event [" + event.getClass().getName() + "]");
        }
        for (int i = 0; i < resources.length; ++i) {
            ServiceResource sr = resources[i];
            EventHandler.EventRegistrationResource er = (EventHandler.EventRegistrationResource)sr.getResource();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("DispatchEventHandler: dispatch event [" + event.getClass().getName() + ": " + event + "] to " + er.getListener());
            }
            if (!this.landlord.ensure(sr)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("DispatchEventHandler.fire() Could not ensure lease for ServiceResource [" + er.getListener() + "] resources count now : " + this.resourceMgr.getServiceResources().length);
                }
                try {
                    this.resourceMgr.removeResource(sr);
                    this.landlord.remove(sr);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.WARNING, "Removing Resource and Cancelling Lease", e);
                }
                continue;
            }
            try {
                RemoteEventListener listener = er.getListener();
                MarshalledObject handback = er.getHandback();
                event.setHandback(handback);
                this.t0 = System.currentTimeMillis();
                listener.notify((RemoteEvent)event);
                this.t1 = System.currentTimeMillis();
                this.sendTime = this.t1 - this.t0;
                if (this.responseWatch != null) {
                    this.responseWatch.setElapsedTime(this.sendTime, this.t1);
                }
                ++this.sent;
                this.printStats(0);
                continue;
            }
            catch (UnknownEventException uee) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.WARNING, "UnknownEventException for EventDescriptor [" + this.descriptor.toString() + "]", uee);
                }
                try {
                    this.resourceMgr.removeResource(sr);
                    this.landlord.cancel(sr.getCookie());
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.WARNING, "Removing resource and cancelling Lease", e);
                }
                continue;
            }
            catch (RemoteException re) {
                int category;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.WARNING, "fire() for EventDescriptor [" + this.descriptor.toString() + "]", re);
                }
                if ((category = ThrowableConstants.retryable((Throwable)re)) != 1 && category != 2 && (re.detail == null || !(re.detail instanceof ConnectException))) continue;
                try {
                    this.resourceMgr.removeResource(sr);
                    this.landlord.cancel(sr.getCookie());
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.WARNING, "Removing resource and cancelling Lease", e);
                }
                continue;
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.WARNING, "DispatchEventHandler.fire() [" + this.descriptor.toString() + "]", t);
            }
        }
        ++this.sequenceNumber;
    }
}

