/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.event;

import com.j_spaces.core.jini.SharedLeaseRenewalManager;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.config.Configuration;
import net.jini.config.EmptyConfiguration;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.lookup.BackwardsServiceDiscoveryManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.FaultDetectionHandler;
import org.jini.rio.core.FaultDetectionListener;
import org.jini.rio.core.jsb.ServiceBeanAdmin;
import org.jini.rio.event.BasicEventConsumer;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventProducer;
import org.jini.rio.event.RemoteServiceEventListener;
import org.jini.rio.resources.client.FaultDetectionHandlerFactory;
import org.jini.rio.resources.client.ServiceDiscoveryAdapter;

public class DynamicEventConsumer
extends BasicEventConsumer {
    private EventProducerManager producerManager;
    private BackwardsServiceDiscoveryManager sdm;
    private LookupCache lCache;
    private Hashtable fdhTable = new Hashtable();
    static Logger logger = BasicEventConsumer.logger;

    public DynamicEventConsumer(EventDescriptor edTemplate, DiscoveryManagement dMgr) throws Exception {
        this(edTemplate, null, dMgr);
    }

    public DynamicEventConsumer(EventDescriptor edTemplate, RemoteServiceEventListener listener, DiscoveryManagement dMgr) throws Exception {
        this(edTemplate, listener, null, dMgr);
    }

    public DynamicEventConsumer(EventDescriptor edTemplate, RemoteServiceEventListener listener, MarshalledObject handback, DiscoveryManagement dMgr) throws Exception {
        this(edTemplate, listener, handback, dMgr, null);
    }

    public DynamicEventConsumer(EventDescriptor edTemplate, RemoteServiceEventListener listener, MarshalledObject handback, DiscoveryManagement dMgr, Configuration config) throws Exception {
        super(edTemplate, listener, handback, config);
        this.producerManager = new EventProducerManager();
        ServiceTemplate template = new ServiceTemplate(null, null, new Entry[]{edTemplate});
        config = config == null ? EmptyConfiguration.INSTANCE : config;
        this.sdm = new BackwardsServiceDiscoveryManager(dMgr, SharedLeaseRenewalManager.getLeaseRenewalManager(), config);
        this.lCache = this.sdm.createLookupCache(template, null, null);
        this.lCache.addListener((ServiceDiscoveryListener)this.producerManager);
    }

    @Override
    public void terminate() {
        ArrayList<FaultDetectionHandler> list = Collections.list(this.fdhTable.elements());
        for (FaultDetectionHandler fdh : list) {
            fdh.terminate();
            ServiceFaultListener sfl = (ServiceFaultListener)this.fdhTable.remove(fdh);
            if (sfl == null) continue;
            sfl.terminate();
        }
        if (this.sdm != null) {
            try {
                this.sdm.terminate();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Terminating SDM", t);
            }
        }
        super.terminate();
    }

    @Override
    public boolean register(RemoteServiceEventListener listener, MarshalledObject handback) {
        this.handback = handback;
        boolean added = super.register(listener, handback);
        try {
            if (this.lCache != null) {
                ServiceItem[] items = this.lCache.lookup(null, Integer.MAX_VALUE);
                for (int i = 0; i < items.length; ++i) {
                    this.register(items[i]);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Register RemoteServiceEventListener", e);
        }
        return added;
    }

    public EventProducer[] getEventProducers() {
        ServiceItem[] items = this.lCache.lookup(null, Integer.MAX_VALUE);
        EventProducer[] producers = new EventProducer[items.length];
        for (int i = 0; i < items.length; ++i) {
            producers[i] = (EventProducer)items[i].service;
        }
        return producers;
    }

    class ServiceFaultListener
    extends ServiceDiscoveryAdapter
    implements FaultDetectionListener {
        boolean useLookupCache;
        ServiceID serviceID;

        ServiceFaultListener(boolean useLookupCache, ServiceID serviceID) {
            this.useLookupCache = useLookupCache;
            this.serviceID = serviceID;
        }

        @Override
        public synchronized void serviceFailure(Object proxy, ServiceID serviceID) {
            if (logger.isLoggable(Level.FINEST)) {
                String name = proxy.getClass().getName();
                logger.log(Level.FINEST, "EventProducer removed {0}", name);
            }
            this.terminate();
        }

        @Override
        public void serviceRemoved(ServiceDiscoveryEvent sdEvent) {
            if (!this.useLookupCache) {
                return;
            }
            ServiceItem item = sdEvent.getPreEventServiceItem();
            if (item.service != null) {
                if (item.serviceID.equals((Object)this.serviceID)) {
                    if (logger.isLoggable(Level.FINEST)) {
                        String name = item.service.getClass().getName();
                        logger.log(Level.FINEST, "EventProducer removed {0}", name);
                    }
                    this.terminate();
                }
            } else {
                logger.log(Level.SEVERE, "Unable to deregister EventProducer {0}, unknown service", item);
            }
        }

        void terminate() {
            DynamicEventConsumer.this.fdhTable.remove(this.serviceID);
            DynamicEventConsumer.this.lCache.removeListener((ServiceDiscoveryListener)this);
            DynamicEventConsumer.this.deregister(this.serviceID);
        }
    }

    class EventProducerManager
    extends ServiceDiscoveryAdapter {
        EventProducerManager() {
        }

        @Override
        public void serviceAdded(ServiceDiscoveryEvent sdEvent) {
            block16: {
                ServiceItem item = sdEvent.getPostEventServiceItem();
                try {
                    if (item != null && item.service != null) {
                        FaultDetectionHandler fdh;
                        block15: {
                            if (logger.isLoggable(Level.FINEST)) {
                                String name = item.service.getClass().getName();
                                logger.log(Level.FINEST, "EventProducer discovered {0}", name);
                            }
                            fdh = null;
                            if (item.service instanceof Administrable) {
                                try {
                                    Object admin = ((Administrable)item.service).getAdmin();
                                    if (admin instanceof ServiceBeanAdmin) {
                                        ServiceBeanAdmin sbAdmin = (ServiceBeanAdmin)admin;
                                        ClassBundle fdhBundle = sbAdmin.getServiceElement().getFaultDetectionHandlerBundle();
                                        fdh = FaultDetectionHandlerFactory.getFaultDetectionHandler(fdhBundle, item.service.getClass().getClassLoader());
                                    } else if (logger.isLoggable(Level.FINEST)) {
                                        String name = item.service.getClass().getName();
                                        logger.log(Level.FINEST, "EventProducer {0} does not implement ServiceBeanAdmin, respond only to serviceRemoved notifications for service failure", name);
                                    }
                                }
                                catch (Exception e) {
                                    if (logger.isLoggable(Level.FINEST)) {
                                        logger.log(Level.WARNING, "Unable to create FaultDetectionHandler for EventProducer " + item.service.toString(), e);
                                        break block15;
                                    }
                                    logger.log(Level.WARNING, "Unable to create FaultDetectionHandler for EventProducer " + item.service.toString());
                                }
                            } else if (logger.isLoggable(Level.FINEST)) {
                                String name = item.service.getClass().getName();
                                logger.log(Level.FINEST, "EventProducer {0} does not implement Administrable, respond only to serviceRemoved notifications for service failure", name);
                            }
                        }
                        ServiceFaultListener faultListener = null;
                        if (fdh != null) {
                            faultListener = new ServiceFaultListener(false, item.serviceID);
                            fdh.register(faultListener);
                            DynamicEventConsumer.this.fdhTable.put(item.serviceID, fdh);
                            fdh.monitor(item.service, item.serviceID, DynamicEventConsumer.this.lCache);
                        }
                        if (DynamicEventConsumer.this.eventSubscribers.size() > 0) {
                            DynamicEventConsumer.this.register(item);
                        }
                        break block16;
                    }
                    logger.log(Level.WARNING, "Unable to register EventProducer {0}", item);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Adding EventProducer", t);
                }
            }
        }
    }
}

