/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.event;

import com.gigaspaces.events.GSEventRegistration;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.EmptyConfiguration;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventProducer;
import org.jini.rio.event.NoEventConsumerException;
import org.jini.rio.event.RemoteServiceEvent;
import org.jini.rio.resources.servicecore.LandlordLessor;
import org.jini.rio.resources.servicecore.LeasedListManager;
import org.jini.rio.resources.servicecore.ServiceResource;
import org.jini.rio.watch.StopWatch;
import org.jini.rio.watch.Watch;
import org.jini.rio.watch.WatchDataSourceRegistry;

public abstract class EventHandler {
    protected Configuration config;
    protected EventDescriptor descriptor;
    protected LandlordLessor landlord;
    protected int sent = 0;
    protected long sktime;
    protected long ektime;
    protected float tmp;
    protected StopWatch responseWatch = null;
    protected WatchDataSourceRegistry watchRegistry = null;
    protected LeasedListManager resourceMgr;
    public static final String RESPONSE_WATCH = "Response Time - ";
    protected int step = 0;
    protected long t0;
    protected long t1;
    protected long sendTime;
    static final Logger logger = Logger.getLogger("org.jini.rio.event");
    protected long sequenceNumber = 0L;

    public EventHandler(EventDescriptor descriptor) throws Exception {
        this(descriptor, (Configuration)EmptyConfiguration.INSTANCE);
    }

    public EventHandler(EventDescriptor descriptor, Configuration config) throws Exception {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is null");
        }
        this.descriptor = descriptor;
        this.config = config;
        this.resourceMgr = new LeasedListManager();
        this.landlord = new LandlordLessor(config);
        this.landlord.addLeaseListener(this.resourceMgr);
    }

    public EventRegistration register(EventProducer eventSource, RemoteEventListener listener, MarshalledObject handback, long duration) throws LeaseDeniedException {
        EventRegistrationResource resource = new EventRegistrationResource(listener, handback);
        ServiceResource sr = new ServiceResource(resource);
        Lease lease = this.landlord.newLease(sr, duration);
        GSEventRegistration registration = new GSEventRegistration(this.descriptor.eventID.longValue(), (Object)eventSource, lease, this.sequenceNumber);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Total registrations for {0} {1}", new Object[]{this.descriptor, new Integer(this.getRegistrantCount())});
        }
        return registration;
    }

    public void terminate() {
        this.landlord.removeAll();
        this.landlord.stop(true);
        this.destroyWatch();
    }

    public void createWatch(WatchDataSourceRegistry watchRegistry) {
        this.responseWatch = new StopWatch(RESPONSE_WATCH + this.descriptor.toString(), this.config);
        if (watchRegistry == null) {
            return;
        }
        this.watchRegistry = watchRegistry;
        watchRegistry.register(this.responseWatch);
    }

    public void destroyWatch() {
        if (this.watchRegistry != null) {
            this.watchRegistry.deregister(this.responseWatch);
        }
        if (this.responseWatch != null) {
            try {
                this.responseWatch.getWatchDataSource().clear();
                this.responseWatch.getWatchDataSource().close();
            }
            catch (RemoteException e) {
                logger.log(Level.SEVERE, "Destroying Watches", e);
            }
        }
        this.responseWatch = null;
    }

    public Watch getWatch() {
        return this.responseWatch;
    }

    public abstract void fire(RemoteServiceEvent var1) throws NoEventConsumerException, RemoteException;

    public int getRegistrantCount() {
        return this.landlord.total();
    }

    protected ServiceResource getNextServiceResource() {
        ServiceResource sr;
        block4: {
            sr = null;
            try {
                while ((sr = this.resourceMgr.getNext()) != null && !this.landlord.ensure(sr)) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Could not ensure resource lease for {0}", sr);
                    }
                    this.resourceMgr.removeResource(sr);
                    this.landlord.remove(sr);
                }
            }
            catch (NoSuchElementException e) {
                if (!logger.isLoggable(Level.FINEST)) break block4;
                logger.finest("No ServiceResource instances");
            }
        }
        return sr;
    }

    protected void printStats(int id) {
        int m;
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        if (this.sent == 0) {
            this.sktime = System.currentTimeMillis();
        }
        if ((m = this.sent % 1000) == 0 && this.sent > 0) {
            this.ektime = System.currentTimeMillis();
            this.tmp = (float)(this.ektime - this.sktime) / 1000.0f;
            logger.finest("Sent [" + this.sent + "]\t[1000/" + this.tmp + "]\t[" + 1000.0f / this.tmp + "/Second]\tReported by [" + id + "]");
            this.sktime = System.currentTimeMillis();
        }
    }

    protected static class EventRegistrationResource {
        private RemoteEventListener listener;
        private MarshalledObject handback;

        public EventRegistrationResource(RemoteEventListener listener, MarshalledObject handback) {
            this.listener = listener;
            this.handback = handback;
        }

        public RemoteEventListener getListener() {
            return this.listener;
        }

        public MarshalledObject getHandback() {
            return this.handback;
        }
    }
}

