/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.event;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.discovery.DiscoveryManagement;
import org.jini.rio.event.RemotePropertyChangeConsumer;

public class MappedRemotePropertyChangeConsumer
extends RemotePropertyChangeConsumer
implements PropertyChangeListener {
    static final Logger logger = Logger.getLogger("org.jini.rio.event");
    private Map map = Collections.synchronizedMap(new HashMap());
    private Map beanMap = Collections.synchronizedMap(new HashMap());

    public MappedRemotePropertyChangeConsumer(DiscoveryManagement dmgr) throws Exception {
        this(dmgr, 8475432875L);
    }

    public MappedRemotePropertyChangeConsumer(DiscoveryManagement dmgr, long eventID) throws Exception {
        super(dmgr, eventID);
        this.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        Object target = this.map.get(source);
        if (target != null) {
            BeanBag beanbag = (BeanBag)this.beanMap.get(target.getClass());
            if (beanbag != null) {
                Method method = beanbag.getWriteMethod(event.getPropertyName());
                if (method != null) {
                    try {
                        method.invoke(target, event.getNewValue());
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Invoking listener", e);
                    }
                }
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Could not get beaninfo for {0}", target.getClass());
            }
        }
    }

    public void addBean(Object bean) throws IntrospectionException {
        this.map.put(bean, bean);
        Class<?> clazz = bean.getClass();
        if (!this.beanMap.containsKey(clazz)) {
            this.beanMap.put(clazz, new BeanBag(clazz));
        }
    }

    public void removeBean(Object bean) {
        this.map.remove(bean);
    }

    static class BeanBag {
        public BeanInfo beaninfo;
        public HashMap writeMethods = new HashMap();
        public HashMap readMethods = new HashMap();

        public BeanBag(Class clazz) throws IntrospectionException {
            this.beaninfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] descriptors = this.beaninfo.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                String property = descriptors[i].getName();
                Method method = descriptors[i].getWriteMethod();
                if (method != null) {
                    this.writeMethods.put(property, method);
                }
                if ((method = descriptors[i].getReadMethod()) == null) continue;
                this.readMethods.put(property, method);
            }
        }

        public Method getWriteMethod(String property) {
            return (Method)this.writeMethods.get(property);
        }

        public Method getReadMethod(String property) {
            return (Method)this.readMethods.get(property);
        }
    }
}

